include("NEPCore.jl")

# Load the quadratic eigenvalue problem from Inf Bilanczos paper
nep=QDEP(400);
n0=size(nep,1);
nep.A=[full(nep.A[1]), full(nep.A[2])];

include("broydenmethod.jl")

pmax=20;
tic();
(SH,XH,HH,all_errhistH,all_timehistH,all_iterhistH)=
deflated_broyden(Complex128, nep,nep,σ=0.1im,pmax=pmax,
                 maxit=2000,
                 addconj=true,
                 check_error_every=1,
                 print_error_every=10,
                 broyden_variant=:H,threshold=0.05,
                 add_nans=true
                 );
ttH=toc();
gc()
sleep(10);
tic()
(ST,XT,HH,all_errhistT,all_timehistT,all_iterhistT)=
deflated_broyden(Complex128, nep,nep,σ=0.1im,pmax=pmax,
                 maxit=2000,
                 addconj=true,
                 check_error_every=1,
                 print_error_every=10,
                 broyden_variant=:T,threshold=0.05,
                 add_nans=true);
ttT=toc();
gc()
sleep(10);
tic();
(SJ,XJ,HH,all_errhistJ,all_timehistJ,all_iterhistJ)=
deflated_broyden(Complex128, nep,nep,σ=0.1im,pmax=pmax,
                 maxit=2000,
                 addconj=true,
                 check_error_every=1,
                 print_error_every=10,
                 broyden_variant=:J,threshold=0.05,
                 add_nans=true);
ttJ=toc();


using PyPlot;
figure(1);
clf()
semilogy(all_iterhistH,all_errhistH,"gd-",markersize=10);
hold(true);
semilogy(all_iterhistT,all_errhistT,"ro-");
semilogy(all_iterhistJ,all_errhistJ,"kx-");

if (norm(SJ-ST)>1e-10)
    error("Simulation inconsistent");
end
figure(2);
clf();
semilogy(all_timehistH,all_errhistH,"gd-",markersize=10);
hold(true);
semilogy(all_timehistT,all_errhistT,"ro-");
semilogy(all_timehistJ,all_errhistJ,"kx-");

## Save the data 
println("writecsv(\"../gfx/num_comp1_J_data.csv\",[all_iterhistJ all_errhistJ all_timehistJ])")
println("writecsv(\"../gfx/num_comp1_H_data.csv\",[all_iterhistH all_errhistH all_timehistH])")
println("writecsv(\"../gfx/num_comp1_T_data.csv\",[all_iterhistT all_errhistT all_timehistT])")



if (false)
    # Minimality index two.
    (SJ,XJ,HH,all_errhistJ2,all_timehistJ2,all_iterhistJ2)=
    deflated_broyden_ell2(Complex128, nep,nep,σ=0.1im,pmax=pmax,
                          maxit=2000,
                          addconj=false,
                          check_error_every=1,
                          print_error_every=10,
                          threshold=0.05,
                          add_nans=true);

    figure(2);
    semilogy(all_timehistJ2,all_errhistJ2,"bx-");

    figure(1);
    semilogy(all_iterhistJ2,all_errhistJ2,"bx-");
    
end

