#using NEPSolver
using NEPCore

include("GalleryPeriodicDDE.jl");
include("bueler_method.jl")
include("broydenmethod.jl");
import Base.size;
import NEPCore.compute_Mlincomb;


L=1;  # Length of beam
Ac=1; # Area of beam
#ee=70e4; # Elasticity module 
#ee=70e2; # Elasticity module
ee=1;
#beta=2e-7;  # Material damping  in Voigt-Model ?
#p0=2.7e-1;    # density 
#b0= beta*ee*p0;
d=1;

omega0=1;
zeta0=1;  # Zeta (damping) butcher
m=1; # Mass butcher
#ap=0.2;
ap=1
KR=1
KT=1;
#KR=3;
#KT=1;

#
#L=0.1;  # Length of beam
#Ac=1; # Area of beam
##ee=70e4; # Elasticity module 
##ee=70e2; # Elasticity module
#ee=1;
#beta=2e-7;  # Material damping  in Voigt-Model ?
##p0=2.7e-1;    # density 
##b0= beta*ee*p0;
#d=1;
#
#omega0=920;
#zeta0=0.0032;  # Zeta (damping) butcher
#m=2.573; # Mass butcher
##ap=0.2;
#ap=5e-4;
#KR=2e3;
#KT=5.5e3;
##KR=3;
##KT=1;
#

Omega=60
tau=60/Omega;
N=500; h=L/N;
e=ones(N,1);       
# Pinv = full(h*spdiags([e/6 2*e/3 e/6], -1:1, n, n));
#Dxx = (1/h)*spdiags([-e 2*e -e], -1:1, n, n);         
#Dxx[end,end]=Dxx(end,end)/2;
Dxx=(1/h)*spdiagm((-e[1:N-1],2*e[1:N],-e[1:N-1]), -1:1,N,N);
Dxx[end,end]=Dxx[end,end]/2;



Pinv = full(h*spdiagm((e[1:N-1]/6,2*e/3,e[1:N-1]/6), -1:1, N, N));
#Dxx = (1/h)*spdiags([-e 2*e -e], -1:1, n, n);         
Pinv[end,end]=Pinv[end,end]/2;

P=inv(Pinv);
pN=P[:,end];


E=eye(2*N+2,2*N+2);
E[(N+2):(end-1),(N+2):(end-1)]=Pinv;
E=sparse(E);
local A0, Wmat;

phi=t -> 2*pi*t/tau;
h=t -> (t<tau/2).*(sin(phi(t)).^2*KR+KT*cos(phi(t)).*sin(phi(t)));
#h=t -> 0.0*(t<tau/2).*(sin(phi(t)).^2*KR+KT*cos(phi(t)).*sin(phi(t)));

#if (false)
#    # With P incorprorated
#    A0=zeros(2*N+2,2*N+2);
#    A0[1:N+1,(N+2):end]=eye(N+1,N+1);
#    A0[N+1+(1:N),1:N]=-ee*P*Dxx;
#    A0[N+1+(1:N),N+1+(1:N)]=-d*P*Dxx;
#    A0[end,N+1]=-omega0^2
#    A0[end,end]=-2*zeta0*omega0;
#    A0=sparse(A0);
#    Wmat=zeros(2*N+2,2*N+2);
#    Wmat[N+1+(1:N),N]=-ap*pN/Ac;
#    Wmat[N+1+(1:N),N+1]=-ap*pN/Ac;
#    Wmat[end,N]=-ap/m;
#    Wmat[end,N+1]=-ap/m;
#    Wmat=sparse(Wmat);
#else
# Sparse 
eN=zeros(N); eN[end]=1;
A0=zeros(2*N+2,2*N+2);
A0[1:N+1,(N+2):end]=eye(N+1,N+1);
A0[N+1+(1:N),1:N]=-ee*Dxx;
A0[N+1+(1:N),N+1+(1:N)]=-d*Dxx;
A0[end,N+1]=-omega0^2
A0[end,end]=-2*zeta0*omega0;
A0=sparse(A0);
Wmat=zeros(2*N+2,2*N+2);
Wmat[N+1+(1:N),N]=-ap*eN/Ac;
Wmat[N+1+(1:N),N+1]=-ap*eN/Ac;
Wmat[end,N]=-ap/m;
Wmat[end,N+1]=-ap/m;
Wmat=sparse(Wmat);
Pinv=sparse(Pinv);
    


if (false) # Only Benchmark
   A0=A0[[N+1,2*N+2],[N+1,2*N+2]];
   Wmat=Wmat[[N+1,2*N+2],[N+1,2*N+2]];
end

A=t-> A0+h(t)*Wmat;
B=t-> -h(t)*Wmat;



nep=PeriodicDDE_NEP_DAE(A,B,E,tau)
approxnep=PeriodicDDE_NEP_DAE(A,B,E,tau)

#nep=PeriodicDDE_NEP(A,B,tau)
#happrox=t -> (t<tau/2).*h(tau/4);
#Aapprox=t->A0+happrox(t)*Wmat;
#Bapprox=t->-happrox(t)*Wmat;
#approxnep=PeriodicDDE_NEP(Aapprox,Bapprox,tau)



nep.N=10
N0=10
approxnep.N=N0;

#approxnep.isconst=true;
σ=-1+0.1im;
n=size(nep,1);
Ac=(λ,t)-> A(t)+B(t)*exp(-tau*λ)-λ*nep.E;
approxnep= NEP_Mder(
    λ-> ode_be_dae(t-> Ac(λ,t), nep.E,0,nep.tau,N0,eye(n))-eye(n),
    n)

#
#n=size(nep,1);
#Mconst=(AC,BC,λ,t) -> expm(t*full(AC+BC*exp(-tau*λ)-λ*eye(n)));

#approxnep= NEP_Mder(λ -> Mconst(Aapprox(tau),Bapprox(tau),λ,tau/2)*Mconst(Aapprox(0),Bapprox(0),λ,tau/2)-eye(n), n );

#Z0=compute_Mder(approxnep,σ)
#Z1=Mconst(Aapprox(0),Bapprox(0),σ,tau/2);
#Z2=Mconst(Aapprox(tau),Bapprox(tau),σ,tau/2);
#Z=Z2*Z1-eye(n); 
#ZZ=compute_Mder(approxnep,σ);
#
#

pmax=2;


function myerrmeasure(λ,v,r)
    return norm(compute_Mlincomb(nep,λ,v))/norm(v);
end


TT=Complex128
(ST,X,HH,all_errhistT,all_timehistT,all_iterhistT)=    
  deflated_broyden(TT, nep,approxnep,σ=σ,pmax=pmax,
                   maxit=2000,
                   addconj=true,
                   check_error_every=1,
                   print_error_every=1,
                   broyden_variant=:T,threshold=0.5,
                   tol=1e-5;
                   add_nans=true,
#                   errmeasure=myerrmeasure
                   );


#
#AA=compute_Mder(nep,ST[1,1]);
#svdvals(AA)
#AA=compute_Mder(nep,ST[3,3]);
#svdvals(AA)


using PyPlot

semilogy(all_timehistT,all_errhistT,"*")
