

include("NEPCore.jl");
include("GalleryPeriodicDDE.jl");
include("bueler_method.jl");
nep_be=problem_gallery(PeriodicDDE_NEP,name="milling1_be")
nep_rk4=problem_gallery(PeriodicDDE_NEP,name="milling1_rk4",TT=Float64)

include("broydenmethod.jl")

#σ=-1+0.1im;
σ=-2.9
nep_rk4.N=5000;
pmax=1;
(Sref,X,HH,all_errhist_org,all_timehist1,all_iterhist1)=
deflated_broyden(Float64, nep_rk4,nep_rk4,σ=σ,pmax=pmax,
                 maxit=2000,
                 addconj=false,
                 check_error_every=1,
                 print_error_every=10,
                 threshold=0.5,
                 tol=1e-15,
                 add_nans=true,
                 eigmethod=:eig,
                 );

NV1=2.^(1:8);
# Add odd points so to be fair, since time-dependence is discontinous at tau/2.
NV2=Vector{Int64}(NV1*1.5+1); NV2=NV2[find(isodd.(NV2))]
NV=sort([NV1;NV2]);

Sv1=zeros(Complex128,size(NV));
Sv2=zeros(Complex128,size(NV));
for i=1:size(NV,1);
    λ0=Sref[1,1];
    nep_rk4.N=NV[i];
    (S1,X,HH,all_errhist1,all_timehist1,all_iterhist1)=
    deflated_broyden(Float64, nep_rk4,nep_rk4,σ=λ0,pmax=pmax,
                     maxit=2000,
                     addconj=false,
                     check_error_every=1,
                     print_error_every=Inf,
                     #broyden_variant=:T,
                     threshold=0.5,
                     tol=1e-15,
                     add_nans=true,
                     eigmethod=:eig,
                     );
    Sv1[i]=S1[1,1];
    
    dd=bueler(nep_rk4;m=NV[i],use_sparse=false, σ=-0.1)
    tau=1
    S2=log.(complex(dd))/tau;
    Sv2[i]=S2[indmin(abs.(S2-Sref[1]))]
end



function eigval_errmeasure(λ,v,rk);
    return abs(λ-Sref[1])

end

λ0=-1;

nep_rk4.N=10;
maxit=25;
(S1,X,HH,all_errhist1,all_timehist1,all_iterhist1)=
deflated_broyden(Float64, nep_rk4,nep_rk4,σ=λ0,pmax=pmax,
                 maxit=maxit,
                 addconj=false,
                 check_error_every=1,
                 print_error_every=Inf,
                 #broyden_variant=:T,
                 threshold=0.5,
                 tol=1e-14,
                 add_nans=true,
                 eigmethod=:eig,
                 errmeasure=eigval_errmeasure
                 );
nep_rk4.N=100;
(S1,X,HH,all_errhist2,all_timehist2,all_iterhist2)=
deflated_broyden(Float64, nep_rk4,nep_rk4,σ=λ0,pmax=pmax,
                 maxit=maxit,
                 addconj=false,
                 check_error_every=1,
                 print_error_every=Inf,
                 #broyden_variant=:T,
                 threshold=0.5,
                 tol=1e-14,
                 add_nans=true,
                 eigmethod=:eig,
                 errmeasure=eigval_errmeasure                 
                 );
nep_rk4.N=1000;
(S1,X,HH,all_errhist3,all_timehist3,all_iterhist3)=
deflated_broyden(Float64, nep_rk4,nep_rk4,σ=λ0,pmax=pmax,
                 maxit=maxit,
                 addconj=false,
                 check_error_every=1,
                 print_error_every=Inf,
                 #broyden_variant=:T,
                 threshold=0.5,
                 tol=1e-14,
                 add_nans=true,
                 eigmethod=:eig,
                 errmeasure=eigval_errmeasure                 
                 );



using PyPlot;

figure(1);
clf();
errv1=Array{Float64}(abs.(Sv1-Sref[1]));
errv2=Array{Float64}(abs.(Sv2-Sref[1]));
loglog(1./NV,errv1,"*-")
hold(true);
loglog(1./NV,errv2,"+-")

figure(2);
clf();
semilogy(all_iterhist1,all_errhist1)
hold(true);
semilogy(all_iterhist2,all_errhist2)
semilogy(all_iterhist3,all_errhist3)




println("writecsv(\"../gfx/milling1_data.csv\",[1./NV errv1 errv2])")

println("writecsv(\"../gfx/milling1_iter1_data.csv\",[all_iterhist1 all_errhist1 all_timehist1])")
println("writecsv(\"../gfx/milling1_iter2_data.csv\",[all_iterhist2 all_errhist2 all_timehist2])")
println("writecsv(\"../gfx/milling1_iter3_data.csv\",[all_iterhist3 all_errhist3 all_timehist3])")

