

include("NEPCore.jl")
include("broydenmethod.jl");
nep=get_double_DEP(Float64);

σ=10im;
p=3;
eigval_errmeasure=(λ,v,r) -> abs(λ-pi*3im); # Use eigenvalue distance with reference solution as errmeasure
(S1,X1,HH,all_errhist,all_timehist,all_iterhist)=
deflated_broyden(Complex128,nep,nep,σ=σ,pmax=2,
                 maxit=10000,
                 addconj=false,
                 check_error_every=1,
                 threshold=1,
                 broyden_variant=:T,
                 tol=1e-7,
                 add_nans=true,
                 errmeasure=eigval_errmeasure;
                 );

#
#
using PyPlot;
clf()
semilogy(all_errhist,"ro");
iter=all_iterhist;

hold(true);

golden=1.61803398875;
reference=(golden.^-iter)
semilogy(iter,reference,"k*")

println("writecsv(\"../gfx/double_eig_conv_data.csv\",[iter all_errhist reference])")

