function bueler(nep::PeriodicDDE_NEP;m=20,use_sparse=false,
                σ=-0.1)
    n=size(nep,1);
    mn=m*n;
    (t,D)=ddecheb(nep.tau,m);
    local In=1;
    if (!use_sparse)
        In=eye(n,n);
        D=kron(D,In);
        D[mn-n+1:mn,:]=[zeros(n,mn-n) In];
        MA=zeros(mn,mn); 
    else
        In=speye(n,n);
        D=kron(sparse(D),In);
        D[mn-n+1:mn,:]=[spzeros(n,mn-n) In];
        MA=spzeros(mn,mn); 
    end
    MB=copy(MA);
    for s=1:m-1
        MA[n*(s-1)+1:n*s,n*(s-1)+1:n*s]=nep.A(t[s]);
        MB[n*(s-1)+1:n*s,n*(s-1)+1:n*s]=nep.B(t[s]);
    end;
    MB[mn-n+1:mn,1:n]=In; # from connection equation

    print("Starting eig: ");
    tic()
    if (use_sparse)
        (D,V)=eigs(complex(MB),complex(D-MA),sigma=σ,which=:LM);
        println(".")
        return D;
    else
        (D,V)=eig(MB,D-MA);
        println(".")        
        return D;
    end
    
    toc();
#    mm=diag(D);
#    [rho,I]=max(abs(mm));
#    lambda=log(mm)/tau;
#    v=V(1:n,I);


end



function ddecheb(tau,m)
    N=m-1
    if N==0
        D=[0.0];
        t=1;
        return (vec([t]),D);
    end
    x = cos.(pi*(0:N)/N); 
    c = [2; ones(N-1); 2].*(-1).^(0:N);
    X = repmat(x,1,N+1);

    antisym_X = X-X';
    D  = (c*(1./c)')./(antisym_X+(eye(N+1)));  # off-diagonal entries

    D  = D - diagm(vec(sum(D,2)));             # diagonal entries
    # normalize
    t=(tau/2)*(x+1);
    D=(2/tau)*D;   

    return (t,D)
end

