import Base.size;
using MAT;
abstract type NEP; end;

type PEP <: NEP;
    n::Integer
    A::Array   # Monomial coefficients of PEP   
end

function compute_Mlincomb(nep :: PEP,λ::Number,v)
    z=copy(v)*0;
    for i=1:size(nep.A,1)
        z=z+nep.A[i]*v*(λ^(i-1));
    end
    return z;
end


function size(nep::NEP,dim=-1)
    n=nep.n;
    if (dim==-1)
        return (n,n)
    else
        return n
    end
end

type DEP <: NEP;  # Represents -λ+A0+A1*exp(-λ)
    n::Integer
    A::Array   # Coefficients in the DEP
end

function compute_Mlincomb(nep :: DEP,λ::Number,v)
    tau=1;
    z=-λ*v+nep.A[1]*v+nep.A[2]*v*exp(-tau*λ);
    return z;
end
function compute_Mder(nep::DEP,λ)
    tau=1
    Z=nep.A[1]+nep.A[2]*exp(-λ*tau);
    if (issparse(Z))
        Z=Z-speye(size(nep,1))*λ;
    else
        Z=Z-eye(size(nep,1))*λ;        
    end
end


function get_double_DEP(TT::DataType=Complex128)
    n=3;
    mypi=TT(pi)
    denom = 8+5*mypi;
    a1 = 2/5 *(65*mypi + 32)/(denom);
    a2 = 9*mypi^2*(13+5*mypi)/(denom);
    a3 = (324*mypi^2/5)*(5*mypi+4)/(denom);
    b1 = (260*mypi + 128 + 225*mypi^2)/(10*denom);
    b2 = 45*mypi^2/denom;
    b3 = 81*mypi^2*(40*mypi + 32 + 25*mypi^2)/(10*denom);
    A0=zeros(TT,n,n);
    A0[1,2]=1;
    A0[2,3]=1;
    A0[3,:]=[-a3  -a2  -a1];
    A1=zeros(TT,n,n);
    A1[3,:] = [  -b3  -b2  -b1];
    nep=DEP(n,[A0,A1])
end


type QDEP <: NEP;  # Represents -λ^2+A0+A1*exp(-λ)
    n::Integer
    A::Array   # Coefficients in the QDEP
end

function compute_Mlincomb(nep :: QDEP,λ::Number,v)
    tau=1;
    z=-λ^2*v+nep.A[1]*v+nep.A[2]*v*exp(-tau*λ);
    return z;
end
function compute_Mder(nep::QDEP,λ)
    tau=1
    Z=nep.A[1]+nep.A[2]*exp(-λ*tau);
    if (issparse(Z))
        Z=Z-speye(size(nep,1))*λ^2;
    else
        Z=Z-eye(size(nep,1))*λ^2;        
    end
end


function QDEP(n=Inf) # Create the QEP from the inf bilanczos paper.
    qdepfile=joinpath(dirname(@__FILE__()),
                      "qdep_infbilanczos.mat")
    file=matopen(qdepfile);    
    A0=read(file,"A0");
    A1=read(file,"A1");
    close(file)
    if (n<size(A0,1))
        A0=A0[1:n,1:n];
        A1=A1[1:n,1:n];        
    end    
    return QDEP(size(A0,1),[A0,A1]);
end





function get_pep0(n=200);
    srand(0)
    A0=randn(n,n)
    A1=randn(n,n)
    A2=randn(n,n)
    A=[A0,A1,A2]
    nep=PEP(n,A)
    return nep
end
