/*
 * Decompiled with CFR 0.152.
 */
package com.miguno.akka.testing;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import akka.actor.Scheduler$class;
import com.miguno.akka.testing.MockCancellable;
import com.miguno.akka.testing.Task;
import com.miguno.akka.testing.VirtualTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.PriorityQueue;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001-\u0011Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003\u001d!Xm\u001d;j]\u001eT!!\u0002\u0004\u0002\t\u0005\\7.\u0019\u0006\u0003\u000f!\ta!\\5hk:|'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003']i\u0011\u0001\u0006\u0006\u0003+Y\tQ!Y2u_JT\u0011!B\u0005\u00031Q\u0011\u0011bU2iK\u0012,H.\u001a:\t\u0011i\u0001!\u0011!Q\u0001\nm\tA\u0001^5nKB\u0011A$H\u0007\u0002\u0005%\u0011aD\u0001\u0002\f-&\u0014H/^1m)&lW\rC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0003E\r\u0002\"\u0001\b\u0001\t\u000biy\u0002\u0019A\u000e\t\r\u0015\u0002\u0001\u0015)\u0003'\u0003\tIG\r\u0005\u0002\u000eO%\u0011\u0001F\u0004\u0002\u0005\u0019>tw\r\u0003\u0004+\u0001\u0001\u0006KaK\u0001\u0006i\u0006\u001c8n\u001d\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003a9\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011TFA\u0007Qe&|'/\u001b;z#V,W/\u001a\t\u00039QJ!!\u000e\u0002\u0003\tQ\u000b7o\u001b\u0005\u0006o\u0001!\t\u0001O\u0001\u0005i&\u001c7\u000eF\u0001:!\ti!(\u0003\u0002<\u001d\t!QK\\5u\u0011\u0015i\u0004\u0001\"\u0011?\u00031\u00198\r[3ek2,wJ\\2f)\ry4j\u0015\u000b\u0003\u0001\u000e\u0003\"aE!\n\u0005\t#\"aC\"b]\u000e,G\u000e\\1cY\u0016DQ\u0001\u0012\u001fA\u0004\u0015\u000b\u0001\"\u001a=fGV$xN\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011:\t!bY8oGV\u0014(/\u001a8u\u0013\tQuI\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")A\n\u0010a\u0001\u001b\u0006)A-\u001a7bsB\u0011a*U\u0007\u0002\u001f*\u0011\u0001kR\u0001\tIV\u0014\u0018\r^5p]&\u0011!k\u0014\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0015!F\b1\u0001V\u0003!\u0011XO\u001c8bE2,\u0007C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0011a\u0017M\\4\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\t%Vtg.\u00192mK\")a\f\u0001C!?\u0006A1o\u00195fIVdW\r\u0006\u0003aE\u00124GC\u0001!b\u0011\u0015!U\fq\u0001F\u0011\u0015\u0019W\f1\u0001N\u00031Ig.\u001b;jC2$U\r\\1z\u0011\u0015)W\f1\u0001N\u0003!Ig\u000e^3sm\u0006d\u0007\"\u0002+^\u0001\u0004)\u0006\"\u00025\u0001\t\u0013I\u0017AC1eIR{G+Y:lgR!\u0001I[6m\u0011\u0015au\r1\u0001N\u0011\u0015!v\r1\u0001V\u0011\u0015)w\r1\u0001n!\ria.T\u0005\u0003_:\u0011aa\u00149uS>t\u0007BB9\u0001\t\u0003\u0011!/\u0001\u0006dC:\u001cW\r\u001c+bg.$\"!O:\t\u000bQ\u0004\b\u0019A\u001a\u0002\tQ\f7o\u001b\u0005\u0006m\u0002!\ta^\u0001\u0012i&lW-\u00168uS2tU\r\u001f;UCN\\G#A7\t\u000fe\u0004!\u0019!C!u\u0006aQ.\u0019=Ge\u0016\fX/\u001a8dsV\t1\u0010\u0005\u0002\u000ey&\u0011QP\u0004\u0002\u0007\t>,(\r\\3\t\r}\u0004\u0001\u0015!\u0003|\u00035i\u0017\r\u001f$sKF,XM\\2zA\u0001")
public class MockScheduler
implements Scheduler {
    private final VirtualTime time;
    private long id;
    private PriorityQueue<Task> tasks;
    private final double maxFrequency;

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler$class.schedule((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler$class.schedule((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler$class.schedule((Scheduler)this, initialDelay, interval, f, executor);
    }

    @Override
    public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler$class.schedule((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler$class.scheduleOnce((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler$class.scheduleOnce((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler$class.scheduleOnce((Scheduler)this, delay, f, executor);
    }

    @Override
    public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler$class.scheduleOnce((Scheduler)this, delay, runnable, executor);
    }

    @Override
    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler$class.schedule$default$6(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler$class.scheduleOnce$default$5(this, delay, receiver, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tick() {
        Object object = this.time.lock();
        synchronized (object) {
            while (this.tasks.nonEmpty() && ((Task)this.tasks.head()).delay().$less$eq((Object)this.time.elapsed())) {
                BoxedUnit boxedUnit;
                Task head = (Task)this.tasks.dequeue();
                head.runnable().run();
                Option<FiniteDuration> option = head.interval();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration interval = (FiniteDuration)some.x();
                    boxedUnit = this.tasks.$plus$eq((Object)new Task(head.delay().$plus(interval), head.id(), head.runnable(), head.interval()));
                    continue;
                }
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError(option);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        return this.addToTasks(delay, runnable, (Option<FiniteDuration>)None$.MODULE$);
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return this.addToTasks(initialDelay, runnable, (Option<FiniteDuration>)Option$.MODULE$.apply((Object)interval));
    }

    private Cancellable addToTasks(FiniteDuration delay, Runnable runnable, Option<FiniteDuration> interval) {
        Object object = this.time.lock();
        synchronized (object) {
            ++this.id;
            FiniteDuration startTime = this.time.elapsed().$plus(delay);
            Task task = new Task(startTime, this.id, runnable, interval);
            this.tasks.$plus$eq((Object)task);
            MockCancellable mockCancellable = new MockCancellable(this, task);
            return mockCancellable;
        }
    }

    public void cancelTask(Task task) {
        Object object = this.time.lock();
        synchronized (object) {
            this.tasks = (PriorityQueue)this.tasks.filterNot((Function1)new Serializable(this, task){
                public static final long serialVersionUID = 0L;
                private final Task task$1;

                public final boolean apply(Task x) {
                    return x.id() == this.task$1.id();
                }
                {
                    this.task$1 = task$1;
                }
            });
            return;
        }
    }

    public Option<FiniteDuration> timeUntilNextTask() {
        Object object = this.time.lock();
        synchronized (object) {
            None$ none$ = this.tasks.nonEmpty() ? new Some((Object)((Task)this.tasks.head()).delay().$minus(this.time.elapsed())) : None$.MODULE$;
            return (Option)none$;
        }
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public MockScheduler(VirtualTime time) {
        this.time = time;
        Scheduler$class.$init$(this);
        this.id = 0L;
        this.tasks = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.maxFrequency = new package.DurationInt(package$.MODULE$.DurationInt(1)).second().$div((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).millis());
    }
}

