package modbat.test

import modbat.mbt.Predef._
import modbat.mbt.MBT
import modbat.mbt.MBT._
import modbat.mbt.Model

object SimpleLingelingModel {
  // transitions
  def instance() = {
    var num_variables : Int = 0
    var num_clauses : Int = 0
    var added_clauses : Int = 0

    new MBT (
      "reset" -> "init" := {
	 println ("init")
      },
      "init" -> "cnf" := {
	 added_clauses = 0
	 num_variables = choose (100, 1000);
	 var threshold = choose (350, 450);
	 num_clauses = (num_variables * threshold) / 100
      },
      "cnf" -> "clause" := { require(added_clauses < num_clauses) },
      "cnf" -> "generated" := { require(added_clauses == num_clauses) },
      "clause" -> "binary" := {
	var lit = 1 // chooseLit
	println ("add " + lit);
      },
      "binary" -> "ternary" := {
	var lit = 2 // chooseLit
	println ("add " + lit)
      },
      "ternary" -> "cnf" := {
	var lit = 3 // chooseLit
	println ("add " + lit)
	println ("add 0")
	added_clauses += 1
      },
      "generated" -> "sat" := { println ("sat"); },
      "generated" -> "init",
      "generated" -> "simp" := {
	var simplificationLevel : Int = 1 //choose between 0 and 3
	println ("simp " + simplificationLevel)
      },
      "generated" -> "end"
    )
  }
}

