package modbat.test

import modbat.mbt.Predef._
import modbat.mbt.MBT
import modbat.mbt.Model
import java.io.EOFException
import java.io.FileNotFoundException
import java.io.IOException

object FileTestModel extends Model {
  // transitions
  def instance() = {
    var isOpen: Boolean = false

    new MBT (
      "uninit" -> "open" := {
	require(!isOpen); println("*** open *** "); isOpen = true
      },
      "uninit" -> "open" := {
	require(!isOpen)
	println("*** open2 *** ")
	maybe (throw new FileNotFoundException)
	maybe (throw new IOException)
      } throws ("FileNotFoundException"),
      "open" -> "open" := {
	maybe (throw new IOException)
	maybe (throw new EOFException)
      } catches ("IOException" -> "err", "EOFException" -> "err2"),
      "open" -> "open" := {
	require(isOpen)
	println("*** r/w ***")
	maybe { throw new IOException }
      },
      "open" -> "open", // empty transition action (do nothing)
      "open" -> "closed" := { require(isOpen); println("*** close *** ") },
      "err" -> "err2" := { println("*** cleanup -> err2 *** ") }
    )
  }
}
