/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.visitor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import serp.bytecode.Attribute;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.ClassInstruction;
import serp.bytecode.Code;
import serp.bytecode.ConstantInstruction;
import serp.bytecode.ConstantValue;
import serp.bytecode.Constants;
import serp.bytecode.ExceptionHandler;
import serp.bytecode.Exceptions;
import serp.bytecode.GetFieldInstruction;
import serp.bytecode.IIncInstruction;
import serp.bytecode.IfInstruction;
import serp.bytecode.InnerClass;
import serp.bytecode.Instruction;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LineNumber;
import serp.bytecode.LoadInstruction;
import serp.bytecode.LocalVariable;
import serp.bytecode.LookupSwitchInstruction;
import serp.bytecode.MethodInstruction;
import serp.bytecode.MultiANewArrayInstruction;
import serp.bytecode.NewArrayInstruction;
import serp.bytecode.Project;
import serp.bytecode.PutFieldInstruction;
import serp.bytecode.RetInstruction;
import serp.bytecode.SourceFile;
import serp.bytecode.StoreInstruction;
import serp.bytecode.TableSwitchInstruction;
import serp.bytecode.WideInstruction;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.FieldEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.InterfaceMethodEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.MethodEntry;
import serp.bytecode.lowlevel.NameAndTypeEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;

public class PrettyPrintVisitor
extends BCVisitor {
    private PrintWriter _out = null;
    private String _prefix = "";
    private int _entryCount = 0;

    public static void main(String[] stringArray) throws ClassNotFoundException, IOException {
        if (stringArray.length == 0) {
            System.err.println("Usage: java serp.bytecode.visitor.PrettyPrintVisitor <classname>+");
            System.exit(1);
        }
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        Project project = new Project();
        for (int i = 0; i < stringArray.length; ++i) {
            BCClass bCClass = stringArray[i].endsWith(".class") ? project.loadClass(new File(stringArray[i])) : project.loadClass(Class.forName(stringArray[i]));
            prettyPrintVisitor.visit(bCClass);
        }
    }

    public PrettyPrintVisitor() {
        this._out = new PrintWriter(System.out);
    }

    public PrettyPrintVisitor(PrintWriter printWriter) {
        this._out = printWriter;
    }

    public void visit(VisitAcceptor visitAcceptor) {
        super.visit(visitAcceptor);
        this._out.flush();
    }

    public void enterProject(Project project) {
        this.openBlock("Project");
        this.println("name=" + project.getName());
    }

    public void exitProject(Project project) {
        this.closeBlock();
    }

    public void enterBCClass(BCClass bCClass) {
        this.openBlock("Class");
        this.println("magic=" + bCClass.getMagic());
        this.println("minor=" + bCClass.getMinorVersion());
        this.println("major=" + bCClass.getMajorVersion());
        this.println("access=" + bCClass.getAccessFlags());
        this.println("name=" + bCClass.getIndex() + " <" + bCClass.getName() + ">");
        this.println("super=" + bCClass.getSuperclassIndex() + " <" + bCClass.getSuperclassName() + ">");
        int[] nArray = bCClass.getDeclaredInterfaceIndexes();
        String[] stringArray = bCClass.getDeclaredInterfaceNames();
        for (int i = 0; i < nArray.length; ++i) {
            this.println("interface=" + nArray[i] + " <" + stringArray[i] + ">");
        }
    }

    public void exitBCClass(BCClass bCClass) {
        this.closeBlock();
    }

    public void enterBCField(BCField bCField) {
        this.openBlock("Field");
        this.println("access=" + bCField.getAccessFlags());
        this.println("name=" + bCField.getNameIndex() + " <" + bCField.getName() + ">");
        this.println("type=" + bCField.getDescriptorIndex() + " <" + bCField.getTypeName() + ">");
    }

    public void exitBCField(BCField bCField) {
        this.closeBlock();
    }

    public void enterBCMethod(BCMethod bCMethod) {
        this.openBlock("Method");
        this.println("access=" + bCMethod.getAccessFlags());
        this.println("name=" + bCMethod.getNameIndex() + " <" + bCMethod.getName() + ">");
        this.println("descriptor=" + bCMethod.getDescriptorIndex());
        this.println("return=" + bCMethod.getReturnName());
        String[] stringArray = bCMethod.getParamNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.println("param=" + stringArray[i]);
        }
    }

    public void exitBCMethod(BCMethod bCMethod) {
        this.closeBlock();
    }

    public void enterAttribute(Attribute attribute) {
        this.openBlock(attribute.getName());
    }

    public void exitAttribute(Attribute attribute) {
        this.closeBlock();
    }

    public void enterConstantValue(ConstantValue constantValue) {
        this.println("value=" + constantValue.getValueIndex() + " <" + constantValue.getTypeName() + "=" + constantValue.getValue() + ">");
    }

    public void enterExceptions(Exceptions exceptions) {
        int[] nArray = exceptions.getExceptionIndexes();
        String[] stringArray = exceptions.getExceptionNames();
        for (int i = 0; i < nArray.length; ++i) {
            this.println("exception=" + nArray[i] + " <" + stringArray[i] + ">");
        }
    }

    public void enterSourceFile(SourceFile sourceFile) {
        this.println("source=" + sourceFile.getFileIndex() + " <" + sourceFile.getFileName() + ">");
    }

    public void enterCode(Code code) {
        this.println("maxStack=" + code.getMaxStack());
        this.println("maxLocals=" + code.getMaxLocals());
        this.println("");
    }

    public void enterExceptionHandler(ExceptionHandler exceptionHandler) {
        this.openBlock("ExceptionHandler");
        this.println("startPc=" + exceptionHandler.getTryStartPc());
        this.println("endPc=" + exceptionHandler.getTryEndPc());
        this.println("handlerPc=" + exceptionHandler.getHandlerStartPc());
        this.println("catch=" + exceptionHandler.getCatchIndex() + " <" + exceptionHandler.getCatchName() + ">");
    }

    public void exitExceptionHandler(ExceptionHandler exceptionHandler) {
        this.closeBlock();
    }

    public void enterInnerClass(InnerClass innerClass) {
        this.openBlock("InnerClass");
        this.println("access=" + innerClass.getAccessFlags());
        this.println("name=" + innerClass.getNameIndex() + " <" + innerClass.getName() + ">");
        this.println("type=" + innerClass.getTypeIndex() + "<" + innerClass.getTypeName() + ">");
        this.println("declarer=" + innerClass.getDeclarerIndex() + "<" + innerClass.getDeclarerName() + ">");
    }

    public void exitInnerClass(InnerClass innerClass) {
        this.closeBlock();
    }

    public void enterLineNumber(LineNumber lineNumber) {
        this.openBlock("LineNumber");
        this.println("startPc=" + lineNumber.getStartPc());
        this.println("line=" + lineNumber.getLine());
    }

    public void exitLineNumber(LineNumber lineNumber) {
        this.closeBlock();
    }

    public void enterLocalVariable(LocalVariable localVariable) {
        this.openBlock("LocalVariable");
        this.println("startPc=" + localVariable.getStartPc());
        this.println("length=" + localVariable.getLength());
        this.println("local=" + localVariable.getLocal());
        this.println("name=" + localVariable.getNameIndex() + " <" + localVariable.getName() + ">");
        this.println("type=" + localVariable.getTypeIndex() + " <" + localVariable.getTypeName() + ">");
    }

    public void exitLocalVariable(LocalVariable localVariable) {
        this.closeBlock();
    }

    public void enterInstruction(Instruction instruction) {
        this._out.print(this._prefix + instruction.getByteIndex() + " " + instruction.getName() + " ");
    }

    public void exitInstruction(Instruction instruction) {
        this._out.println();
    }

    public void enterClassInstruction(ClassInstruction classInstruction) {
        this._out.print(classInstruction.getTypeIndex() + " <" + classInstruction.getTypeName() + ">");
    }

    public void enterConstantInstruction(ConstantInstruction constantInstruction) {
        this._out.print("<" + constantInstruction.getValue() + ">");
    }

    public void enterGetFieldInstruction(GetFieldInstruction getFieldInstruction) {
        this._out.print(getFieldInstruction.getFieldIndex() + " <" + getFieldInstruction.getFieldTypeName() + " " + getFieldInstruction.getFieldDeclarerName() + "." + getFieldInstruction.getFieldName() + ">");
    }

    public void enterIIncInstruction(IIncInstruction iIncInstruction) {
        this._out.print(iIncInstruction.getLocal() + " ");
        if (iIncInstruction.getIncrement() < 0) {
            this._out.print("-");
        }
        this._out.print(iIncInstruction.getIncrement());
    }

    public void enterJumpInstruction(JumpInstruction jumpInstruction) {
        this._out.print(jumpInstruction.getOffset());
    }

    public void enterIfInstruction(IfInstruction ifInstruction) {
        this._out.print(ifInstruction.getOffset());
    }

    public void enterLoadInstruction(LoadInstruction loadInstruction) {
        this._out.print("<" + loadInstruction.getLocal() + ">");
    }

    public void enterLookupSwitchInstruction(LookupSwitchInstruction lookupSwitchInstruction) {
        this._out.println();
        this._prefix = this._prefix + "  ";
        int[] nArray = lookupSwitchInstruction.getOffsets();
        int[] nArray2 = lookupSwitchInstruction.getMatches();
        for (int i = 0; i < nArray.length; ++i) {
            this.println("case " + nArray2[i] + "=" + nArray[i]);
        }
        this._out.print(this._prefix + "default=" + lookupSwitchInstruction.getDefaultOffset());
        this._prefix = this._prefix.substring(2);
    }

    public void enterMethodInstruction(MethodInstruction methodInstruction) {
        this._out.print(methodInstruction.getMethodIndex() + " <" + methodInstruction.getMethodReturnName() + " " + methodInstruction.getMethodDeclarerName() + "." + methodInstruction.getMethodName() + "(");
        String[] stringArray = methodInstruction.getMethodParamNames();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(46);
            if (n != -1) {
                stringArray[i] = stringArray[i].substring(n + 1);
            }
            this._out.print(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            this._out.print(", ");
        }
        this._out.print(")>");
    }

    public void enterMultiANewArrayInstruction(MultiANewArrayInstruction multiANewArrayInstruction) {
        this._out.print(multiANewArrayInstruction.getTypeIndex() + " " + multiANewArrayInstruction.getDimensions() + " <" + multiANewArrayInstruction.getTypeName());
        String string = "";
        for (int i = 0; i < multiANewArrayInstruction.getDimensions(); ++i) {
            string = string + "[]";
        }
        this._out.print(string + ">");
    }

    public void enterNewArrayInstruction(NewArrayInstruction newArrayInstruction) {
        this._out.print(newArrayInstruction.getTypeCode() + " <" + newArrayInstruction.getTypeName() + "[]>");
    }

    public void enterPutFieldInstruction(PutFieldInstruction putFieldInstruction) {
        this._out.print(putFieldInstruction.getFieldIndex() + " <" + putFieldInstruction.getFieldTypeName() + " " + putFieldInstruction.getFieldDeclarerName() + "." + putFieldInstruction.getFieldName() + ">");
    }

    public void enterRetInstruction(RetInstruction retInstruction) {
        this._out.print(retInstruction.getLocal());
    }

    public void enterStoreInstruction(StoreInstruction storeInstruction) {
        this._out.print("<" + storeInstruction.getLocal() + ">");
    }

    public void enterTableSwitchInstruction(TableSwitchInstruction tableSwitchInstruction) {
        this._out.println();
        this._prefix = this._prefix + "  ";
        this.println("low=" + tableSwitchInstruction.getLow());
        this.println("high=" + tableSwitchInstruction.getHigh());
        int[] nArray = tableSwitchInstruction.getOffsets();
        for (int i = 0; i < nArray.length; ++i) {
            this.println("case=" + nArray[i]);
        }
        this._out.print(this._prefix + "default=" + tableSwitchInstruction.getDefaultOffset());
        this._prefix = this._prefix.substring(2);
    }

    public void enterWideInstruction(WideInstruction wideInstruction) {
        int n = wideInstruction.getInstruction();
        this._out.print(n + " <" + Constants.OPCODE_NAMES[n] + ">");
    }

    public void enterConstantPool(ConstantPool constantPool) {
        this._entryCount = 0;
        this.openBlock("ConstantPool");
    }

    public void exitConstantPool(ConstantPool constantPool) {
        this.closeBlock();
    }

    public void enterEntry(Entry entry) {
        String string = entry.getClass().getName();
        this.openBlock(++this._entryCount + ": " + string.substring(string.lastIndexOf(46) + 1));
    }

    public void exitEntry(Entry entry) {
        this.closeBlock();
    }

    public void enterClassEntry(ClassEntry classEntry) {
        this.println("name=" + classEntry.getNameIndex());
    }

    public void enterDoubleEntry(DoubleEntry doubleEntry) {
        this.println("value=" + doubleEntry.getValue());
    }

    public void enterFieldEntry(FieldEntry fieldEntry) {
        this.println("class=" + fieldEntry.getClassIndex());
        this.println("nameAndType=" + fieldEntry.getNameAndTypeIndex());
    }

    public void enterFloatEntry(FloatEntry floatEntry) {
        this.println("value=" + floatEntry.getValue());
    }

    public void enterIntEntry(IntEntry intEntry) {
        this.println("value=" + intEntry.getValue());
    }

    public void enterInterfaceMethodEntry(InterfaceMethodEntry interfaceMethodEntry) {
        this.println("class=" + interfaceMethodEntry.getClassIndex());
        this.println("nameAndType=" + interfaceMethodEntry.getNameAndTypeIndex());
    }

    public void enterLongEntry(LongEntry longEntry) {
        this.println("value=" + longEntry.getValue());
    }

    public void enterMethodEntry(MethodEntry methodEntry) {
        this.println("class=" + methodEntry.getClassIndex());
        this.println("nameAndType=" + methodEntry.getNameAndTypeIndex());
    }

    public void enterNameAndTypeEntry(NameAndTypeEntry nameAndTypeEntry) {
        this.println("name=" + nameAndTypeEntry.getNameIndex());
        this.println("descriptor=" + nameAndTypeEntry.getDescriptorIndex());
    }

    public void enterStringEntry(StringEntry stringEntry) {
        this.println("index=" + stringEntry.getStringIndex());
    }

    public void enterUTF8Entry(UTF8Entry uTF8Entry) {
        this.println("value=" + uTF8Entry.getValue());
    }

    private void println(String string) {
        this._out.print(this._prefix);
        this._out.println(string);
    }

    private void openBlock(String string) {
        this.println(string + " {");
        this._prefix = this._prefix + "  ";
    }

    private void closeBlock() {
        this._prefix = this._prefix.substring(2);
        this.println("}");
    }
}

