/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class IntEntry
extends Entry
implements ConstantEntry {
    private int _value = -1;

    public IntEntry() {
    }

    public IntEntry(int n) {
        this._value = n;
    }

    public int getType() {
        return 3;
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int n) {
        Object object = this.beforeModify();
        this._value = n;
        this.afterModify(object);
    }

    public Object getConstant() {
        return Numbers.valueOf(this.getValue());
    }

    public void setConstant(Object object) {
        this.setValue(((Number)object).intValue());
    }

    protected void readData(DataInput dataInput) throws IOException {
        this._value = dataInput.readInt();
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this._value);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterIntEntry(this);
        bCVisitor.exitIntEntry(this);
    }
}

