/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.util.HashSet;
import java.util.Set;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.util.Strings;

public abstract class TypedInstruction
extends Instruction {
    private static final Set _opcodeTypes = new HashSet(10, 1.0f);
    static /* synthetic */ Class class$java$lang$Object;

    TypedInstruction(Code code) {
        super(code);
    }

    TypedInstruction(Code code, int n) {
        super(code, n);
    }

    String mapType(String string, Class[][] classArray, boolean bl) {
        if (string == null) {
            return null;
        }
        string = this.getProject().getNameCache().getExternalForm(string, false);
        if (!_opcodeTypes.contains(string) && bl) {
            string = (class$java$lang$Object == null ? (class$java$lang$Object = TypedInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
        }
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i][0].getName().equals(string)) continue;
                string = classArray[i][1].getName();
            }
        }
        return string;
    }

    public abstract String getTypeName();

    public Class getType() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getTypeBC() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public abstract TypedInstruction setType(String var1);

    public TypedInstruction setType(Class clazz) {
        if (clazz == null) {
            return this.setType((String)null);
        }
        return this.setType(clazz.getName());
    }

    public TypedInstruction setType(BCClass bCClass) {
        if (bCClass == null) {
            return this.setType((String)null);
        }
        return this.setType(bCClass.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _opcodeTypes.add(Integer.TYPE.getName());
        _opcodeTypes.add(Long.TYPE.getName());
        _opcodeTypes.add(Float.TYPE.getName());
        _opcodeTypes.add(Double.TYPE.getName());
        _opcodeTypes.add((class$java$lang$Object == null ? (class$java$lang$Object = TypedInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName());
        _opcodeTypes.add(Byte.TYPE.getName());
        _opcodeTypes.add(Character.TYPE.getName());
        _opcodeTypes.add(Short.TYPE.getName());
        _opcodeTypes.add(Boolean.TYPE.getName());
        _opcodeTypes.add(Void.TYPE.getName());
    }
}

