/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.JumpInstruction;
import serp.bytecode.visitor.BCVisitor;

public class TableSwitchInstruction
extends JumpInstruction {
    private int _low = 0;
    private int _high = 0;
    private List _cases = new LinkedList();

    TableSwitchInstruction(Code code) {
        super(code, 170);
    }

    public int[] getOffsets() {
        int n = this.getByteIndex();
        int[] nArray = new int[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            nArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getByteIndex() - n;
        }
        return nArray;
    }

    public void setOffsets(int[] nArray) {
        int n = this.getByteIndex();
        this._cases.clear();
        for (int i = 0; i < nArray.length; ++i) {
            InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
            instructionPtrStrategy.setByteIndex(nArray[i] + n);
            this._cases.add(instructionPtrStrategy);
        }
    }

    int getLength() {
        int n = 1;
        int n2 = this.getByteIndex() + 1;
        while (n2 % 4 != 0) {
            ++n2;
            ++n;
        }
        n += 12;
        return n += 4 * this._cases.size();
    }

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public TableSwitchInstruction setDefaultTarget(Instruction instruction) {
        return (TableSwitchInstruction)this.setTarget(instruction);
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public TableSwitchInstruction setDefaultOffset(int n) {
        this.setOffset(n);
        return this;
    }

    public int getLow() {
        return this._low;
    }

    public TableSwitchInstruction setLow(int n) {
        this._low = n;
        return this;
    }

    public int getHigh() {
        return this._high;
    }

    public TableSwitchInstruction setHigh(int n) {
        this._high = n;
        return this;
    }

    public Instruction[] getTargets() {
        Instruction[] instructionArray = new Instruction[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            instructionArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getTargetInstruction();
        }
        return instructionArray;
    }

    public TableSwitchInstruction setTargets(Instruction[] instructionArray) {
        this._cases.clear();
        if (instructionArray != null) {
            for (int i = 0; i < instructionArray.length; ++i) {
                this.addTarget(instructionArray[i]);
            }
        }
        return this;
    }

    public TableSwitchInstruction addTarget(Instruction instruction) {
        this._cases.add(new InstructionPtrStrategy(this, instruction));
        return this;
    }

    public int getStackChange() {
        return -1;
    }

    private Instruction findTarget(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() != n) continue;
            return instruction;
        }
        return null;
    }

    public void updateTargets() {
        super.updateTargets();
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        super.replaceTarget(instruction, instruction2);
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).replaceTarget(instruction, instruction2);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterTableSwitchInstruction(this);
        bCVisitor.exitTableSwitchInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        TableSwitchInstruction tableSwitchInstruction = (TableSwitchInstruction)instruction;
        this.setLow(tableSwitchInstruction.getLow());
        this.setHigh(tableSwitchInstruction.getHigh());
        Iterator iterator = tableSwitchInstruction._cases.iterator();
        while (iterator.hasNext()) {
            InstructionPtrStrategy instructionPtrStrategy = (InstructionPtrStrategy)iterator.next();
            InstructionPtrStrategy instructionPtrStrategy2 = new InstructionPtrStrategy(this);
            instructionPtrStrategy2.setByteIndex(instructionPtrStrategy.getByteIndex());
            this._cases.add(instructionPtrStrategy2);
        }
    }

    void read(DataInput dataInput) throws IOException {
        int n = this.getByteIndex();
        int n2 = n + 1;
        while (n2 % 4 != 0) {
            dataInput.readByte();
            ++n2;
        }
        this.setOffset(dataInput.readInt());
        this.setLow(dataInput.readInt());
        this.setHigh(dataInput.readInt());
        this._cases.clear();
        for (n2 = 0; n2 < this._high - this._low + 1; ++n2) {
            InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
            instructionPtrStrategy.setByteIndex(n + dataInput.readInt());
            this._cases.add(instructionPtrStrategy);
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        int n = this.getByteIndex();
        int n2 = n + 1;
        while (n2 % 4 != 0) {
            dataOutput.writeByte(0);
            ++n2;
        }
        dataOutput.writeInt(this.getOffset());
        dataOutput.writeInt(this.getLow());
        dataOutput.writeInt(this.getHigh());
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            dataOutput.writeInt(((InstructionPtrStrategy)iterator.next()).getByteIndex() - n);
        }
    }
}

