/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.JumpInstruction;

public abstract class SwitchInstruction
extends JumpInstruction {
    private List _cases = new LinkedList();

    public SwitchInstruction(Code code, int n) {
        super(code, n);
    }

    public int[] getOffsets() {
        int n = this.getByteIndex();
        int[] nArray = new int[this._cases.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getByteIndex() - n;
        }
        return nArray;
    }

    public void setOffsets(int[] nArray) {
        int n = this.getByteIndex();
        this._cases.clear();
        for (int i = 0; i < nArray.length; ++i) {
            InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
            instructionPtrStrategy.setByteIndex(nArray[i] + n);
            this._cases.add(instructionPtrStrategy);
        }
    }

    public int countTargets() {
        return this._cases.size();
    }

    int getLength() {
        int n = 1;
        int n2 = this.getByteIndex() + 1;
        while (n2 % 4 != 0) {
            ++n2;
            ++n;
        }
        return n;
    }

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public SwitchInstruction setDefaultOffset(int n) {
        this.setOffset(n);
        return this;
    }

    public SwitchInstruction setDefaultTarget(Instruction instruction) {
        return (SwitchInstruction)this.setTarget(instruction);
    }

    public Instruction[] getTargets() {
        Instruction[] instructionArray = new Instruction[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            instructionArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getTargetInstruction();
        }
        return instructionArray;
    }

    public SwitchInstruction setTargets(Instruction[] instructionArray) {
        this._cases.clear();
        if (instructionArray != null) {
            for (int i = 0; i < instructionArray.length; ++i) {
                this.addTarget(instructionArray[i]);
            }
        }
        return this;
    }

    public SwitchInstruction addTarget(Instruction instruction) {
        this._cases.add(new InstructionPtrStrategy(this, instruction));
        return this;
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        return -1;
    }

    public void updateTargets() {
        super.updateTargets();
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        super.replaceTarget(instruction, instruction2);
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).replaceTarget(instruction, instruction2);
        }
    }

    void read(Instruction instruction) {
        super.read(instruction);
        SwitchInstruction switchInstruction = (SwitchInstruction)instruction;
        this._cases.clear();
        Iterator iterator = switchInstruction._cases.iterator();
        while (iterator.hasNext()) {
            InstructionPtrStrategy instructionPtrStrategy = (InstructionPtrStrategy)iterator.next();
            InstructionPtrStrategy instructionPtrStrategy2 = new InstructionPtrStrategy(this);
            instructionPtrStrategy2.setByteIndex(instructionPtrStrategy.getByteIndex());
            this._cases.add(instructionPtrStrategy2);
        }
    }

    void clearTargets() {
        this._cases.clear();
    }

    void readTarget(DataInput dataInput) throws IOException {
        InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
        instructionPtrStrategy.setByteIndex(this.getByteIndex() + dataInput.readInt());
        this._cases.add(instructionPtrStrategy);
    }

    public SwitchInstruction setCases(int[] nArray, Instruction[] instructionArray) {
        this.setMatches(nArray);
        this.setTargets(instructionArray);
        return this;
    }

    public SwitchInstruction setMatches(int[] nArray) {
        this.clearMatches();
        for (int i = 0; i < nArray.length; ++i) {
            this.addMatch(nArray[i]);
        }
        return this;
    }

    public SwitchInstruction addCase(int n, Instruction instruction) {
        this.addMatch(n);
        this.addTarget(instruction);
        return this;
    }

    public abstract SwitchInstruction addMatch(int var1);

    public abstract int[] getMatches();

    abstract void clearMatches();
}

