/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.JumpInstruction;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class LookupSwitchInstruction
extends JumpInstruction {
    private List _matches = new LinkedList();
    private List _cases = new LinkedList();

    LookupSwitchInstruction(Code code) {
        super(code, 171);
    }

    int getLength() {
        int n = 1;
        int n2 = this.getByteIndex() + 1;
        while (n2 % 4 != 0) {
            ++n2;
            ++n;
        }
        n += 8;
        return n += 8 * this._matches.size();
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        return -1;
    }

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public LookupSwitchInstruction setDefaultTarget(Instruction instruction) {
        return (LookupSwitchInstruction)this.setTarget(instruction);
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public LookupSwitchInstruction setDefaultOffset(int n) {
        this.setOffset(n);
        return this;
    }

    public LookupSwitchInstruction setCases(int[] nArray, Instruction[] instructionArray) {
        int n;
        this._matches.clear();
        this._cases.clear();
        for (n = 0; n < nArray.length; ++n) {
            this._matches.add(Numbers.valueOf(nArray[n]));
        }
        for (n = 0; n < instructionArray.length; ++n) {
            InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
            instructionPtrStrategy.setTargetInstruction(instructionArray[n]);
            this._cases.add(instructionPtrStrategy);
        }
        return this;
    }

    public int[] getOffsets() {
        int n = this.getByteIndex();
        int[] nArray = new int[this._cases.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getByteIndex() - n;
        }
        return nArray;
    }

    public int[] getMatches() {
        int[] nArray = new int[this._matches.size()];
        Iterator iterator = this._matches.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)iterator.next();
        }
        return nArray;
    }

    public Instruction[] getTargets() {
        Instruction[] instructionArray = new Instruction[this._cases.size()];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = ((InstructionPtrStrategy)this._cases.get(i)).getTargetInstruction();
        }
        return instructionArray;
    }

    public LookupSwitchInstruction addCase(int n, Instruction instruction) {
        this._matches.add(Numbers.valueOf(n));
        this._cases.add(new InstructionPtrStrategy(this, instruction));
        return this;
    }

    private Instruction findJumpPoint(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() != n) continue;
            return instruction;
        }
        return null;
    }

    public void updateTargets() {
        super.updateTargets();
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        super.replaceTarget(instruction, instruction2);
        Iterator iterator = this._cases.iterator();
        while (iterator.hasNext()) {
            ((InstructionPtrStrategy)iterator.next()).replaceTarget(instruction, instruction2);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLookupSwitchInstruction(this);
        bCVisitor.exitLookupSwitchInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        LookupSwitchInstruction lookupSwitchInstruction = (LookupSwitchInstruction)instruction;
        this._matches = new LinkedList(lookupSwitchInstruction._matches);
        this._cases.clear();
        Iterator iterator = lookupSwitchInstruction._cases.iterator();
        while (iterator.hasNext()) {
            InstructionPtrStrategy instructionPtrStrategy = (InstructionPtrStrategy)iterator.next();
            InstructionPtrStrategy instructionPtrStrategy2 = new InstructionPtrStrategy(this);
            instructionPtrStrategy2.setByteIndex(instructionPtrStrategy.getByteIndex());
            this._cases.add(instructionPtrStrategy2);
        }
    }

    void read(DataInput dataInput) throws IOException {
        int n = this.getByteIndex();
        int n2 = n + 1;
        while (n2 % 4 != 0) {
            dataInput.readByte();
            ++n2;
        }
        this.setOffset(dataInput.readInt());
        this._matches.clear();
        this._cases.clear();
        int n3 = dataInput.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this._matches.add(Numbers.valueOf(dataInput.readInt()));
            InstructionPtrStrategy instructionPtrStrategy = new InstructionPtrStrategy(this);
            instructionPtrStrategy.setByteIndex(n + dataInput.readInt());
            this._cases.add(instructionPtrStrategy);
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        int n = this.getByteIndex();
        int n2 = n + 1;
        while (n2 % 4 != 0) {
            dataOutput.writeByte(0);
            ++n2;
        }
        dataOutput.writeInt(this.getOffset());
        dataOutput.writeInt(this._matches.size());
        for (n2 = 0; n2 < this._matches.size(); ++n2) {
            dataOutput.writeInt((Integer)this._matches.get(n2));
            dataOutput.writeInt(((InstructionPtrStrategy)this._cases.get(n2)).getByteIndex() - n);
        }
    }
}

