/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.LineNumber;
import serp.bytecode.visitor.BCVisitor;

public class LineNumberTable
extends Attribute
implements InstructionPtr {
    private List _lineNumbers = new ArrayList();

    LineNumberTable(int n, Attributes attributes) {
        super(n, attributes);
    }

    public LineNumber[] getLineNumbers() {
        Collections.sort(this._lineNumbers);
        return this._lineNumbers.toArray(new LineNumber[this._lineNumbers.size()]);
    }

    public LineNumber getLineNumber(int n) {
        for (int i = this._lineNumbers.size() - 1; i >= 0; --i) {
            if (((LineNumber)this._lineNumbers.get((int)i))._target.getByteIndex() > n) continue;
            return (LineNumber)this._lineNumbers.get(i);
        }
        return null;
    }

    public LineNumber getLineNumber(Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        return this.getLineNumber(instruction.getByteIndex());
    }

    public void setLineNumbers(LineNumber[] lineNumberArray) {
        this.clear();
        if (lineNumberArray != null) {
            for (int i = 0; i < lineNumberArray.length; ++i) {
                this.addLineNumber(lineNumberArray[i]);
            }
        }
    }

    public LineNumber addLineNumber(LineNumber lineNumber) {
        LineNumber lineNumber2 = this.addLineNumber();
        lineNumber2.setStartPc(lineNumber.getStartPc());
        lineNumber2.setLine(lineNumber.getLine());
        return lineNumber2;
    }

    public LineNumber addLineNumber() {
        LineNumber lineNumber = new LineNumber(this);
        this._lineNumbers.add(lineNumber);
        return lineNumber;
    }

    public LineNumber addLineNumber(int n, int n2) {
        LineNumber lineNumber = this.addLineNumber();
        lineNumber.setStartPc(n);
        lineNumber.setLine(n2);
        return lineNumber;
    }

    public LineNumber addLineNumber(Instruction instruction, int n) {
        LineNumber lineNumber = this.addLineNumber();
        lineNumber.setStart(instruction);
        lineNumber.setLine(n);
        return lineNumber;
    }

    public void clear() {
        for (int i = 0; i < this._lineNumbers.size(); ++i) {
            ((LineNumber)this._lineNumbers.get(i)).invalidate();
        }
        this._lineNumbers.clear();
    }

    public boolean removeLineNumber(LineNumber lineNumber) {
        if (lineNumber == null || !this._lineNumbers.remove(lineNumber)) {
            return false;
        }
        lineNumber.invalidate();
        return true;
    }

    public boolean removeLineNumber(int n) {
        return this.removeLineNumber(this.getLineNumber(n));
    }

    public boolean removeLineNumber(Instruction instruction) {
        return this.removeLineNumber(this.getLineNumber(instruction));
    }

    public void updateTargets() {
        for (int i = 0; i < this._lineNumbers.size(); ++i) {
            ((LineNumber)this._lineNumbers.get(i)).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        for (int i = 0; i < this._lineNumbers.size(); ++i) {
            ((LineNumber)this._lineNumbers.get(i)).replaceTarget(instruction, instruction2);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLineNumberTable(this);
        LineNumber[] lineNumberArray = this.getLineNumbers();
        for (int i = 0; i < lineNumberArray.length; ++i) {
            lineNumberArray[i].acceptVisit(bCVisitor);
        }
        bCVisitor.exitLineNumberTable(this);
    }

    int getLength() {
        return 2 + 4 * this._lineNumbers.size();
    }

    void read(Attribute attribute) {
        this.setLineNumbers(((LineNumberTable)attribute).getLineNumbers());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            LineNumber lineNumber = this.addLineNumber();
            lineNumber.read(dataInput);
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        LineNumber[] lineNumberArray = this.getLineNumbers();
        dataOutput.writeShort(lineNumberArray.length);
        for (int i = 0; i < lineNumberArray.length; ++i) {
            lineNumberArray[i].write(dataOutput);
        }
    }

    public Code getCode() {
        return (Code)this.getOwner();
    }
}

