/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.InnerClass;
import serp.bytecode.visitor.BCVisitor;

public class InnerClasses
extends Attribute {
    private List _innerClasses = new LinkedList();

    InnerClasses(int n, Attributes attributes) {
        super(n, attributes);
    }

    public InnerClass[] getInnerClasses() {
        return this._innerClasses.toArray(new InnerClass[this._innerClasses.size()]);
    }

    public InnerClass getInnerClass(String string) {
        InnerClass[] innerClassArray = this.getInnerClasses();
        for (int i = 0; i < innerClassArray.length; ++i) {
            String string2 = innerClassArray[i].getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return innerClassArray[i];
        }
        return null;
    }

    public InnerClass[] getInnerClasses(String string) {
        LinkedList<InnerClass> linkedList = new LinkedList<InnerClass>();
        InnerClass[] innerClassArray = this.getInnerClasses();
        for (int i = 0; i < innerClassArray.length; ++i) {
            String string2 = innerClassArray[i].getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            linkedList.add(innerClassArray[i]);
        }
        return linkedList.toArray(new InnerClass[linkedList.size()]);
    }

    public void setInnerClasses(InnerClass[] innerClassArray) {
        this.clear();
        if (innerClassArray != null) {
            for (int i = 0; i < innerClassArray.length; ++i) {
                this.addInnerClass(innerClassArray[i]);
            }
        }
    }

    public InnerClass addInnerClass(InnerClass innerClass) {
        InnerClass innerClass2 = this.addInnerClass(innerClass.getName(), innerClass.getTypeName(), innerClass.getDeclarerName());
        innerClass2.setAccessFlags(innerClass.getAccessFlags());
        return innerClass2;
    }

    public InnerClass addInnerClass() {
        InnerClass innerClass = new InnerClass(this);
        this._innerClasses.add(innerClass);
        return innerClass;
    }

    public InnerClass addInnerClass(String string, String string2, String string3) {
        InnerClass innerClass = this.addInnerClass();
        innerClass.setName(string);
        innerClass.setType(string2);
        innerClass.setDeclarer(string3);
        return innerClass;
    }

    public InnerClass addInnerClass(String string, Class clazz, Class clazz2) {
        String string2 = clazz == null ? null : clazz.getName();
        String string3 = clazz2 == null ? null : clazz2.getName();
        return this.addInnerClass(string, string2, string3);
    }

    public InnerClass addInnerClass(String string, BCClass bCClass, BCClass bCClass2) {
        String string2 = bCClass == null ? null : bCClass.getName();
        String string3 = bCClass2 == null ? null : bCClass2.getName();
        return this.addInnerClass(string, string2, string3);
    }

    public void clear() {
        Iterator iterator = this._innerClasses.iterator();
        while (iterator.hasNext()) {
            InnerClass innerClass = (InnerClass)iterator.next();
            iterator.remove();
            innerClass.invalidate();
        }
    }

    public boolean removeInnerClass(String string) {
        return this.removeInnerClass(this.getInnerClass(string));
    }

    public boolean removeInnerClass(InnerClass innerClass) {
        if (innerClass == null || !this._innerClasses.remove(innerClass)) {
            return false;
        }
        innerClass.invalidate();
        return true;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterInnerClasses(this);
        InnerClass[] innerClassArray = this.getInnerClasses();
        for (int i = 0; i < innerClassArray.length; ++i) {
            innerClassArray[i].acceptVisit(bCVisitor);
        }
        bCVisitor.exitInnerClasses(this);
    }

    int getLength() {
        return 2 + 8 * this._innerClasses.size();
    }

    void read(Attribute attribute) {
        this.setInnerClasses(((InnerClasses)attribute).getInnerClasses());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            InnerClass innerClass = this.addInnerClass();
            innerClass.read(dataInput);
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        InnerClass[] innerClassArray = this.getInnerClasses();
        dataOutput.writeShort(innerClassArray.length);
        for (int i = 0; i < innerClassArray.length; ++i) {
            innerClassArray[i].write(dataOutput);
        }
    }
}

