/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.lowlevel.ComplexEntry;
import serp.util.Strings;

public abstract class FieldInstruction
extends Instruction {
    private int _index = 0;

    FieldInstruction(Code code, int n) {
        super(code, n);
    }

    int getLength() {
        return super.getLength() + 2;
    }

    public int getFieldIndex() {
        return this._index;
    }

    public FieldInstruction setFieldIndex(int n) {
        this._index = n;
        return this;
    }

    public BCField getField() {
        String string = this.getFieldDeclarerName();
        if (string == null) {
            return null;
        }
        BCClass bCClass = this.getProject().loadClass(string, this.getClassLoader());
        BCField[] bCFieldArray = bCClass.getFields(this.getFieldName());
        if (bCFieldArray.length == 0) {
            return null;
        }
        return bCFieldArray[0];
    }

    public FieldInstruction setField(BCField bCField) {
        if (bCField == null) {
            return this.setFieldIndex(0);
        }
        return this.setField(bCField.getDeclarer().getName(), bCField.getName(), bCField.getTypeName());
    }

    public FieldInstruction setField(Field field) {
        if (field == null) {
            return this.setFieldIndex(0);
        }
        return this.setField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public FieldInstruction setField(String string, String string2, String string3) {
        if (string == null && string2 == null && string3 == null) {
            return this.setFieldIndex(0);
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        string = this.getProject().getNameCache().getInternalForm(string, false);
        string3 = this.getProject().getNameCache().getInternalForm(string3, true);
        return this.setFieldIndex(this.getPool().findFieldEntry(string, string2, string3, true));
    }

    public FieldInstruction setField(String string, String string2) {
        BCClass bCClass = this.getCode().getMethod().getDeclarer();
        return this.setField(bCClass.getName(), string, string2);
    }

    public FieldInstruction setField(Class clazz, String string, Class clazz2) {
        String string2 = clazz == null ? null : clazz.getName();
        String string3 = clazz2 == null ? null : clazz2.getName();
        return this.setField(string2, string, string3);
    }

    public FieldInstruction setField(String string, Class clazz) {
        BCClass bCClass = this.getCode().getMethod().getDeclarer();
        String string2 = clazz == null ? null : clazz.getName();
        return this.setField(bCClass.getName(), string, string2);
    }

    public FieldInstruction setField(BCClass bCClass, String string, BCClass bCClass2) {
        String string2 = bCClass == null ? null : bCClass.getName();
        String string3 = bCClass2 == null ? null : bCClass2.getName();
        return this.setField(string2, string, string3);
    }

    public FieldInstruction setField(String string, BCClass bCClass) {
        BCClass bCClass2 = this.getCode().getMethod().getDeclarer();
        String string2 = bCClass == null ? null : bCClass.getName();
        return this.setField(bCClass2.getName(), string, string2);
    }

    public String getFieldName() {
        int n = this.getFieldIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = complexEntry.getNameAndTypeEntry().getNameEntry().getValue();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public FieldInstruction setFieldName(String string) {
        return this.setField(this.getFieldDeclarerName(), string, this.getFieldTypeName());
    }

    public String getFieldTypeName() {
        int n = this.getFieldIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = this.getProject().getNameCache().getExternalForm(complexEntry.getNameAndTypeEntry().getDescriptorEntry().getValue(), false);
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public Class getFieldType() {
        String string = this.getFieldTypeName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getFieldTypeBC() {
        String string = this.getFieldTypeName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public FieldInstruction setFieldType(String string) {
        return this.setField(this.getFieldDeclarerName(), this.getFieldName(), string);
    }

    public FieldInstruction setFieldType(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.setFieldType(string);
    }

    public FieldInstruction setFieldType(BCClass bCClass) {
        String string = null;
        if (bCClass != null) {
            string = bCClass.getName();
        }
        return this.setFieldType(string);
    }

    public String getFieldDeclarerName() {
        int n = this.getFieldIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = this.getProject().getNameCache().getExternalForm(complexEntry.getClassEntry().getNameEntry().getValue(), false);
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public Class getFieldDeclarerType() {
        String string = this.getFieldDeclarerName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getFieldDeclarerBC() {
        String string = this.getFieldDeclarerName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public FieldInstruction setFieldDeclarer(String string) {
        return this.setField(string, this.getFieldName(), this.getFieldTypeName());
    }

    public FieldInstruction setFieldDeclarer(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.setFieldDeclarer(string);
    }

    public FieldInstruction setFieldDeclarer(BCClass bCClass) {
        String string = null;
        if (bCClass != null) {
            string = bCClass.getName();
        }
        return this.setFieldDeclarer(string);
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!(instruction instanceof FieldInstruction)) {
            return false;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        FieldInstruction fieldInstruction = (FieldInstruction)instruction;
        String string = this.getFieldName();
        String string2 = fieldInstruction.getFieldName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        string = this.getFieldTypeName();
        string2 = fieldInstruction.getFieldTypeName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        string = this.getFieldDeclarerName();
        string2 = fieldInstruction.getFieldDeclarerName();
        return string == null || string2 == null || string.equals(string2);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        FieldInstruction fieldInstruction = (FieldInstruction)instruction;
        this.setField(fieldInstruction.getFieldDeclarerName(), fieldInstruction.getFieldName(), fieldInstruction.getFieldTypeName());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setFieldIndex(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.getFieldIndex());
    }
}

