/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;
import serp.util.Strings;

public class Exceptions
extends Attribute {
    private List _indexes = new LinkedList();

    Exceptions(int n, Attributes attributes) {
        super(n, attributes);
    }

    int getLength() {
        return 2 + 2 * this._indexes.size();
    }

    public BCMethod getMethod() {
        return (BCMethod)this.getOwner();
    }

    public int[] getExceptionIndexes() {
        int[] nArray = new int[this._indexes.size()];
        Iterator iterator = this._indexes.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)iterator.next();
        }
        return nArray;
    }

    public void setExceptionIndexes(int[] nArray) {
        this._indexes.clear();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this._indexes.add(Numbers.valueOf(nArray[i]));
            }
        }
    }

    public String[] getExceptionNames() {
        String[] stringArray = new String[this._indexes.size()];
        Iterator iterator = this._indexes.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = ((Number)iterator.next()).intValue();
            ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(n);
            stringArray[i] = this.getProject().getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
        }
        return stringArray;
    }

    public Class[] getExceptionTypes() {
        String[] stringArray = this.getExceptionNames();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Strings.toClass(stringArray[i], this.getClassLoader());
        }
        return classArray;
    }

    public BCClass[] getExceptionBCs() {
        String[] stringArray = this.getExceptionNames();
        BCClass[] bCClassArray = new BCClass[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            bCClassArray[i] = this.getProject().loadClass(stringArray[i], this.getClassLoader());
        }
        return bCClassArray;
    }

    public void setExceptions(String[] stringArray) {
        int n;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] != null) continue;
                throw new NullPointerException("exceptions[" + n + "] = null");
            }
        }
        this.clear();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.addException(stringArray[n]);
            }
        }
    }

    public void setExceptions(Class[] classArray) {
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
        }
        this.setExceptions(stringArray);
    }

    public void setExceptions(BCClass[] bCClassArray) {
        String[] stringArray = null;
        if (bCClassArray != null) {
            stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
        }
        this.setExceptions(stringArray);
    }

    public void clear() {
        this._indexes.clear();
    }

    public boolean removeException(String string) {
        String string2 = this.getProject().getNameCache().getInternalForm(string, false);
        Iterator iterator = this._indexes.iterator();
        while (iterator.hasNext()) {
            ClassEntry classEntry = (ClassEntry)this.getPool().getEntry((Integer)iterator.next());
            if (!classEntry.getNameEntry().getValue().equals(string2)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeException(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.removeException(clazz.getName());
    }

    public boolean removeException(BCClass bCClass) {
        if (bCClass == null) {
            return false;
        }
        return this.removeException(bCClass.getName());
    }

    public void addException(String string) {
        int n = this.getPool().findClassEntry(this.getProject().getNameCache().getInternalForm(string, false), true);
        this._indexes.add(Numbers.valueOf(n));
    }

    public void addException(Class clazz) {
        this.addException(clazz.getName());
    }

    public void addException(BCClass bCClass) {
        this.addException(bCClass.getName());
    }

    public boolean throwsException(String string) {
        String[] stringArray = this.getExceptionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean throwsException(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.throwsException(clazz.getName());
    }

    public boolean throwsException(BCClass bCClass) {
        if (bCClass == null) {
            return false;
        }
        return this.throwsException(bCClass.getName());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterExceptions(this);
        bCVisitor.exitExceptions(this);
    }

    void read(Attribute attribute) {
        this.setExceptions(((Exceptions)attribute).getExceptionNames());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this._indexes.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            this._indexes.add(Numbers.valueOf(dataInput.readUnsignedShort()));
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._indexes.size());
        Iterator iterator = this._indexes.iterator();
        while (iterator.hasNext()) {
            dataOutput.writeShort(((Number)iterator.next()).shortValue());
        }
    }
}

