/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class CmpInstruction
extends TypedInstruction {
    private static Class[][] _mappings = new Class[][]{{Integer.TYPE, Long.TYPE}, {Byte.TYPE, Long.TYPE}, {Character.TYPE, Long.TYPE}, {Short.TYPE, Long.TYPE}, {Boolean.TYPE, Long.TYPE}, {Void.TYPE, Long.TYPE}, {class$java$lang$Object == null ? (class$java$lang$Object = CmpInstruction.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE}};
    static /* synthetic */ Class class$java$lang$Object;

    CmpInstruction(Code code) {
        super(code);
    }

    CmpInstruction(Code code, int n) {
        super(code, n);
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 148: 
            case 151: 
            case 152: {
                return -3;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 148: {
                return Long.TYPE.getName();
            }
            case 149: 
            case 150: {
                return Float.TYPE.getName();
            }
            case 151: 
            case 152: {
                return Double.TYPE.getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        if ((string = this.mapType(string, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        int n = this.getOpcode();
        switch (string.charAt(0)) {
            case 'l': {
                return (TypedInstruction)this.setOpcode(148);
            }
            case 'f': {
                if (n == 149 || n == 151) {
                    return (TypedInstruction)this.setOpcode(149);
                }
                return (TypedInstruction)this.setOpcode(150);
            }
            case 'd': {
                if (n == 149 || n == 151) {
                    return (TypedInstruction)this.setOpcode(151);
                }
                return (TypedInstruction)this.setOpcode(152);
            }
        }
        throw new IllegalStateException();
    }

    public int getNaNValue() {
        switch (this.getOpcode()) {
            case 149: 
            case 151: {
                return -1;
            }
            case 150: 
            case 152: {
                return 1;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmpInstruction setNaNValue(int n) {
        switch (this.getOpcode()) {
            case 149: 
            case 150: {
                if (n == 1) {
                    this.setOpcode(150);
                } else {
                    if (n != -1) throw new IllegalArgumentException("Invalid nan for type");
                    this.setOpcode(149);
                }
            }
            case 151: 
            case 152: {
                if (n == 1) {
                    this.setOpcode(152);
                    break;
                }
                if (n != -1) throw new IllegalArgumentException("Invalid nan for type");
                this.setOpcode(151);
                break;
            }
        }
        if (n == 0) return this;
        throw new IllegalArgumentException("Invalid nan for type");
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterCmpInstruction(this);
        bCVisitor.exitCmpInstruction(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

