/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ComplexEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.UTF8Entry;

public abstract class BCMember
extends Attributes {
    private BCClass _owner = null;
    private int _access = 2;
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;
    private Collection _attrs = new LinkedList();

    BCMember(BCClass bCClass) {
        this._owner = bCClass;
    }

    public BCClass getDeclarer() {
        return this._owner;
    }

    public int getAccessFlags() {
        return this._access;
    }

    public void setAccessFlags(int n) {
        this._access = n;
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) > 0;
    }

    public void makePublic() {
        this.setAccessFlags(this.getAccessFlags() | 1);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFD);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFB);
    }

    public boolean isProtected() {
        return (this.getAccessFlags() & 4) > 0;
    }

    public void makeProtected() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFD);
        this.setAccessFlags(this.getAccessFlags() | 4);
    }

    public boolean isPrivate() {
        return (this.getAccessFlags() & 2) > 0;
    }

    public void makePrivate() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
        this.setAccessFlags(this.getAccessFlags() | 2);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFB);
    }

    public boolean isPackage() {
        boolean bl = false;
        bl = bl || (this.getAccessFlags() & 2) > 0;
        bl = bl || (this.getAccessFlags() & 4) > 0;
        bl = bl || (this.getAccessFlags() & 1) > 0;
        return !bl;
    }

    public void makePackage() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFD);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFB);
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public void setFinal(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x10);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) > 0;
    }

    public void setStatic(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 8);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFF7);
        }
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        String string = this.getName();
        this._nameIndex = n;
        this.setEntry(string, this.getDescriptor());
    }

    public int getDescriptorIndex() {
        return this._descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        String string = this.getDescriptor();
        this._descriptorIndex = n;
        this.setEntry(this.getName(), string);
    }

    public String getName() {
        return ((UTF8Entry)this.getPool().getEntry(this._nameIndex)).getValue();
    }

    public void setName(String string) {
        String string2 = this.getName();
        this._nameIndex = this.getPool().findUTF8Entry(string, true);
        this.setEntry(string2, this.getDescriptor());
    }

    public String getDescriptor() {
        return ((UTF8Entry)this.getPool().getEntry(this._descriptorIndex)).getValue();
    }

    public void setDescriptor(String string) {
        String string2 = this.getDescriptor();
        string = this.getProject().getNameCache().getInternalForm(string, true);
        this._descriptorIndex = this.getPool().findUTF8Entry(string, true);
        this.setEntry(this.getName(), string2);
    }

    private void setEntry(String string, String string2) {
        String string3 = this.getProject().getNameCache().getInternalForm(this._owner.getName(), false);
        ConstantPool constantPool = this.getPool();
        int n = this instanceof BCField ? constantPool.findFieldEntry(string, string2, string3, false) : (!this._owner.isInterface() ? constantPool.findMethodEntry(string, string2, string3, false) : constantPool.findInterfaceMethodEntry(string, string2, string3, false));
        if (n != 0) {
            ComplexEntry complexEntry = (ComplexEntry)constantPool.getEntry(n);
            int n2 = constantPool.findNameAndTypeEntry(this.getName(), this.getDescriptor(), true);
            complexEntry.setNameAndTypeIndex(n2);
        }
    }

    public boolean isDeprecated() {
        return this.getAttribute("Deprecated") != null;
    }

    public void setDeprecated(boolean bl) {
        if (!bl) {
            this.removeAttribute("Deprecated");
        } else if (!this.isDeprecated()) {
            this.addAttribute("Deprecated");
        }
    }

    public boolean isSynthetic() {
        return this.getAttribute("Synthetic") != null;
    }

    public void setSynthetic(boolean bl) {
        if (!bl) {
            this.removeAttribute("Synthetic");
        } else if (!this.isSynthetic()) {
            this.addAttribute("Synthetic");
        }
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    Collection getAttributesHolder() {
        return this._attrs;
    }

    void initialize(String string, String string2) {
        this._nameIndex = this.getPool().findUTF8Entry(string, true);
        this._descriptorIndex = this.getPool().findUTF8Entry(string2, true);
    }

    void invalidate() {
        this._owner = null;
    }

    void read(DataInput dataInput) throws IOException {
        this._access = dataInput.readUnsignedShort();
        this._nameIndex = dataInput.readUnsignedShort();
        this._descriptorIndex = dataInput.readUnsignedShort();
        this.readAttributes(dataInput);
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._access);
        dataOutput.writeShort(this._nameIndex);
        dataOutput.writeShort(this._descriptorIndex);
        this.writeAttributes(dataOutput);
    }
}

