/*
 * Decompiled with CFR 0.152.
 */
package modbat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import modbat.dsl.Action;
import modbat.log.Log$;
import modbat.mbt.MBT$;
import modbat.util.SourceInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class SourceInfo$ {
    public static final SourceInfo$ MODULE$;
    private final int MAXLEN;
    private final String SKIP;
    private final HashMap<Class<?>, String> cachedActionInfoFromClass;
    private final HashMap<Method, String> cachedActionInfoFromMethod;
    private final HashMap<Class<?>, String> cachedSourceInfoFromClass;
    private final HashMap<Method, String> cachedSourceInfoFromMethod;
    private final HashMap<Class<?>, List<SourceInfo.InternalAction>> cachedLaunchChoiceInfoFromClass;
    private final HashMap<Method, List<SourceInfo.InternalAction>> cachedLaunchChoiceInfoFromMethod;

    static {
        new SourceInfo$();
    }

    public int MAXLEN() {
        return this.MAXLEN;
    }

    public String SKIP() {
        return this.SKIP;
    }

    public HashMap<Class<?>, String> cachedActionInfoFromClass() {
        return this.cachedActionInfoFromClass;
    }

    public HashMap<Method, String> cachedActionInfoFromMethod() {
        return this.cachedActionInfoFromMethod;
    }

    public HashMap<Class<?>, String> cachedSourceInfoFromClass() {
        return this.cachedSourceInfoFromClass;
    }

    public HashMap<Method, String> cachedSourceInfoFromMethod() {
        return this.cachedSourceInfoFromMethod;
    }

    public HashMap<Class<?>, List<SourceInfo.InternalAction>> cachedLaunchChoiceInfoFromClass() {
        return this.cachedLaunchChoiceInfoFromClass;
    }

    public HashMap<Method, List<SourceInfo.InternalAction>> cachedLaunchChoiceInfoFromMethod() {
        return this.cachedLaunchChoiceInfoFromMethod;
    }

    public void analyzeClosure(ClassVisitor visitor, String closureName) {
        ClassReader cr = new ClassReader(this.findInURLs(new StringBuilder().append((Object)closureName).append((Object)".class").toString(), MBT$.MODULE$.classLoaderURLs()));
        try {
            cr.accept(visitor, 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log$.MODULE$.warn(new StringBuilder().append((Object)closureName.replace('.', File.separatorChar)).append((Object)".class: file not found").toString());
        }
    }

    public InputStream jarEntry(String filename, JarFile jar) {
        ZipEntry entry = jar.getEntry(filename);
        return entry == null ? null : jar.getInputStream(entry);
    }

    public InputStream findPath(Class<?> cls) {
        String filename = new StringBuilder().append((Object)cls.getName().replace('.', '/')).append((Object)".class").toString();
        return this.findInURLs(filename, MBT$.MODULE$.classLoaderURLs());
    }

    public InputStream findInURLs(String filename, URL[] urls) {
        Object object = new Object();
        try {
            Predef$.MODULE$.refArrayOps((Object[])urls).foreach((Function1)new Serializable(filename, object){
                private final String filename$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(URL url) {
                    String basename = url.getFile();
                    if (basename.isEmpty()) {
                        Log$.MODULE$.info(new StringBuilder().append((Object)"Skipping non-file URL ").append((Object)url).append((Object)".").toString());
                    } else {
                        File file = new File(basename);
                        if (file.exists()) {
                            if (basename.endsWith(".jar")) {
                                InputStream probedJarEntry = SourceInfo$.MODULE$.jarEntry(this.filename$1, new JarFile(file));
                                if (probedJarEntry != null) {
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)probedJarEntry);
                                }
                            } else {
                                String filename2 = this.filename$1.replace('/', File.separatorChar);
                                File f = new File(new StringBuilder().append((Object)basename).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)filename2).toString());
                                if (f.exists()) {
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new FileInputStream(f));
                                }
                            }
                            Log$.MODULE$.debug(new StringBuilder().append((Object)this.filename$1).append((Object)" not found in ").append((Object)basename).append((Object)".").toString());
                        } else {
                            Log$.MODULE$.warn(new StringBuilder().append((Object)"Warning: class path entry ").append((Object)basename).append((Object)" not found.").toString());
                        }
                    }
                }
                {
                    this.filename$1 = filename$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            Log$.MODULE$.error(new StringBuilder().append((Object)"Class file ").append((Object)filename).append((Object)" cannot be loaded.").toString());
            throw new ClassNotFoundException();
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (InputStream)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public String pkgNameAsDir(Class<?> cls) {
        Package pkg = cls.getPackage();
        return pkg == null ? "." : pkg.getName().replace('.', File.separatorChar);
    }

    public void clsNotFoundMsg(Class<?> cls) {
        Log$.MODULE$.error(new StringBuilder().append((Object)cls.getName().replace('.', File.separatorChar)).append((Object)".class").append((Object)": file not found").toString());
    }

    public String computeActionInfo(Action action, Class<?> cls, Method method, boolean includeLine) {
        String string;
        SourceInfo.ActionRecord r = new SourceInfo.ActionRecord();
        try {
            ClassReader cr = new ClassReader(this.findPath(cls));
            if (method == null) {
                SourceInfo.ActionInfoClsVisitor cv = new SourceInfo.ActionInfoClsVisitor(r);
                cr.accept(cv, 0);
            } else {
                r.methodInfo_$eq(method.getName());
            }
            string = includeLine ? new StringBuilder().append((Object)r.methodInfo()).append((Object)": line ").append((Object)this.sourceInfo(action, true)).toString() : r.methodInfo();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.clsNotFoundMsg(cls);
            string = "";
        }
        return string;
    }

    public String actionInfo(Action action, boolean includeLine) {
        Predef$.MODULE$.assert(action.transfunc() != null);
        Class<? super Object> cls = this.getClass(action);
        Method method = action.method();
        return method == null ? (String)this.cachedActionInfoFromClass().getOrElseUpdate(cls, (Function0)new Serializable(action, includeLine, cls){
            private final Action action$1;
            private final boolean includeLine$1;
            private final Class cls$1;

            public final String apply() {
                return SourceInfo$.MODULE$.computeActionInfo(this.action$1, this.cls$1, null, this.includeLine$1);
            }
            {
                this.action$1 = action$1;
                this.includeLine$1 = includeLine$1;
                this.cls$1 = cls$1;
            }
        }) : (String)this.cachedActionInfoFromMethod().getOrElseUpdate((Object)method, (Function0)new Serializable(action, includeLine, cls, method){
            private final Action action$1;
            private final boolean includeLine$1;
            private final Class cls$1;
            private final Method method$1;

            public final String apply() {
                return SourceInfo$.MODULE$.computeActionInfo(this.action$1, this.cls$1, this.method$1, this.includeLine$1);
            }
            {
                this.action$1 = action$1;
                this.includeLine$1 = includeLine$1;
                this.cls$1 = cls$1;
                this.method$1 = method$1;
            }
        });
    }

    public List<SourceInfo.InternalAction> launchAndChoiceInfo(Action action) {
        if (action.transfunc() == null) {
            return Nil$.MODULE$;
        }
        Class<? super Object> cls = this.getClass(action);
        Method method = action.method();
        return method == null ? (List)this.cachedLaunchChoiceInfoFromClass().getOrElseUpdate(cls, (Function0)new Serializable(cls){
            private final Class cls$2;

            public final List<SourceInfo.InternalAction> apply() {
                return SourceInfo$.MODULE$.computeLaunchChoiceInfo(this.cls$2, null);
            }
            {
                this.cls$2 = cls$2;
            }
        }) : (List)this.cachedLaunchChoiceInfoFromMethod().getOrElseUpdate((Object)method, (Function0)new Serializable(cls, method){
            private final Class cls$2;
            private final Method method$2;

            public final List<SourceInfo.InternalAction> apply() {
                return SourceInfo$.MODULE$.computeLaunchChoiceInfo(this.cls$2, this.method$2);
            }
            {
                this.cls$2 = cls$2;
                this.method$2 = method$2;
            }
        });
    }

    public List<SourceInfo.InternalAction> computeLaunchChoiceInfo(Class<?> cls, Method method) {
        Nil$ nil$;
        SourceInfo.LaunchesAndChoices r = new SourceInfo.LaunchesAndChoices();
        try {
            ClassReader cr = new ClassReader(this.findPath(cls));
            if (method == null) {
                SourceInfo.LaunchAndChoiceVisitor cv = new SourceInfo.LaunchAndChoiceVisitor(r);
                cr.accept(cv, 0);
            }
            nil$ = r.actions().toList();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.clsNotFoundMsg(cls);
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Class<? super Object> getClass(Action action) {
        Method method = action.method();
        return method == null ? action.transfunc().getClass() : method.getDeclaringClass();
    }

    public String sourceInfo(Action action, boolean lineOnly) {
        if (action.transfunc() == null) {
            return "(empty transition function)";
        }
        Class<? super Object> cls = this.getClass(action);
        Method method = action.method();
        return method == null ? (String)this.cachedSourceInfoFromClass().getOrElseUpdate(cls, (Function0)new Serializable(lineOnly, cls){
            private final boolean lineOnly$1;
            private final Class cls$3;

            public final String apply() {
                return SourceInfo$.MODULE$.computeSourceInfo(this.cls$3, null, this.lineOnly$1);
            }
            {
                this.lineOnly$1 = lineOnly$1;
                this.cls$3 = cls$3;
            }
        }) : (String)this.cachedSourceInfoFromMethod().getOrElseUpdate((Object)method, (Function0)new Serializable(lineOnly, cls, method){
            private final boolean lineOnly$1;
            private final Class cls$3;
            private final Method method$3;

            public final String apply() {
                return SourceInfo$.MODULE$.computeSourceInfo(this.cls$3, this.method$3, this.lineOnly$1);
            }
            {
                this.lineOnly$1 = lineOnly$1;
                this.cls$3 = cls$3;
                this.method$3 = method$3;
            }
        });
    }

    public String computeSourceInfo(Class<?> cls, Method method, boolean lineOnly) {
        String string;
        String pkgName = this.pkgNameAsDir(cls);
        SourceInfo.SourceRecord r = new SourceInfo.SourceRecord();
        try {
            ClassReader cr = new ClassReader(this.findPath(cls));
            if (method == null) {
                SourceInfo.SourceInfoClsVisitor cv = new SourceInfo.SourceInfoClsVisitor(r);
                cr.accept(cv, 0);
            } else {
                SourceInfo.SourceInfoMethodVisitor cv = new SourceInfo.SourceInfoMethodVisitor(r, method);
                cr.accept(cv, 0);
            }
            string = lineOnly ? ((Object)BoxesRunTime.boxToInteger((int)r.line())).toString() : new StringBuilder().append((Object)pkgName).append((Object)BoxesRunTime.boxToCharacter((char)File.separatorChar)).append((Object)r.source()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)r.line())).toString();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.clsNotFoundMsg(cls);
            string = "";
        }
        return string;
    }

    private SourceInfo$() {
        MODULE$ = this;
        this.MAXLEN = 20;
        this.SKIP = "\u0000";
        this.cachedActionInfoFromClass = new HashMap();
        this.cachedActionInfoFromMethod = new HashMap();
        this.cachedSourceInfoFromClass = new HashMap();
        this.cachedSourceInfoFromMethod = new HashMap();
        this.cachedLaunchChoiceInfoFromClass = new HashMap();
        this.cachedLaunchChoiceInfoFromMethod = new HashMap();
    }
}

