/*
 * Decompiled with CFR 0.152.
 */
package modbat.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class FieldUtil$ {
    public static final FieldUtil$ MODULE$;

    static {
        new FieldUtil$();
    }

    public boolean isBoolean(Field f) {
        return this.isBoolean(f.getType());
    }

    public boolean isBoolean(Class<?> c) {
        return c.isAssignableFrom(Boolean.TYPE) || c.getName().equals("boolean");
    }

    public boolean isByte(Field f) {
        return this.isByte(f.getType());
    }

    public boolean isByte(Class<?> c) {
        return c.isAssignableFrom(Byte.TYPE) || c.getName().equals("byte");
    }

    public boolean isChar(Field f) {
        return this.isChar(f.getType());
    }

    public boolean isChar(Class<?> c) {
        return c.isAssignableFrom(Character.TYPE) || c.getName().equals("char");
    }

    public boolean isShort(Field f) {
        return this.isShort(f.getType());
    }

    public boolean isShort(Class<?> c) {
        return c.isAssignableFrom(Short.TYPE) || c.getName().equals("short");
    }

    public boolean isInt(Field f) {
        return this.isInt(f.getType());
    }

    public boolean isInt(Class<?> c) {
        return c.isAssignableFrom(Integer.TYPE) || c.getName().equals("int");
    }

    public boolean isLong(Field f) {
        return this.isLong(f.getType());
    }

    public boolean isLong(Class<?> c) {
        return c.isAssignableFrom(Long.TYPE) || c.getName().equals("long");
    }

    public boolean isFloat(Field f) {
        return this.isFloat(f.getType());
    }

    public boolean isFloat(Class<?> c) {
        return c.isAssignableFrom(Float.TYPE) || c.getName().equals("float");
    }

    public boolean isDouble(Field f) {
        return this.isDouble(f.getType());
    }

    public boolean isDouble(Class<?> c) {
        return c.isAssignableFrom(Double.TYPE) || c.getName().equals("double");
    }

    public void clearPrivate(Field f) {
        if (Modifier.isPrivate(f.getModifiers())) {
            f.setAccessible(true);
        }
    }

    public void setInt(Field f, Object i, int v) {
        String fName = f.getName();
        try {
            Method setter = i.getClass().getDeclaredMethod(new StringBuilder().append((Object)fName).append((Object)"_$eq").toString(), Integer.TYPE);
            setter.invoke(i, BoxesRunTime.boxToInteger((int)v));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f.setInt(i, v);
        }
    }

    public void setLong(Field f, Object i, long v) {
        String fName = f.getName();
        try {
            Method setter = i.getClass().getDeclaredMethod(new StringBuilder().append((Object)fName).append((Object)"_$eq").toString(), Long.TYPE);
            setter.invoke(i, BoxesRunTime.boxToLong((long)v));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f.setLong(i, v);
        }
    }

    public void setBoolean(Field f, Object i, boolean v) {
        String fName = f.getName();
        try {
            Method setter = i.getClass().getDeclaredMethod(new StringBuilder().append((Object)fName).append((Object)"_$eq").toString(), Boolean.TYPE);
            setter.invoke(i, BoxesRunTime.boxToBoolean((boolean)v));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f.setBoolean(i, v);
        }
    }

    public void setDouble(Field f, Object i, double v) {
        String fName = f.getName();
        try {
            Method setter = i.getClass().getDeclaredMethod(new StringBuilder().append((Object)fName).append((Object)"_$eq").toString(), Double.TYPE);
            setter.invoke(i, BoxesRunTime.boxToDouble((double)v));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f.setDouble(i, v);
        }
    }

    public void set(Field f, Object i, Object v) {
        String fName = f.getName();
        try {
            Method setter = i.getClass().getDeclaredMethod(new StringBuilder().append((Object)fName).append((Object)"_$eq").toString(), Object.class);
            setter.invoke(i, v);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f.set(i, v);
        }
    }

    public byte getByte(Field f, Object i) {
        byte by;
        try {
            by = BoxesRunTime.unboxToByte((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            by = f.getByte(i);
        }
        return by;
    }

    public char getChar(Field f, Object i) {
        char c;
        try {
            c = BoxesRunTime.unboxToChar((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            c = f.getChar(i);
        }
        return c;
    }

    public short getShort(Field f, Object i) {
        short s;
        try {
            s = BoxesRunTime.unboxToShort((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            s = f.getShort(i);
        }
        return s;
    }

    public int getInt(Field f, Object i) {
        int n;
        try {
            n = BoxesRunTime.unboxToInt((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            n = f.getInt(i);
        }
        return n;
    }

    public long getLong(Field f, Object i) {
        long l;
        try {
            l = BoxesRunTime.unboxToLong((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            l = f.getLong(i);
        }
        return l;
    }

    public boolean getBoolean(Field f, Object i) {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            bl = f.getBoolean(i);
        }
        return bl;
    }

    public float getFloat(Field f, Object i) {
        float f2;
        try {
            f2 = BoxesRunTime.unboxToFloat((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            f2 = f.getFloat(i);
        }
        return f2;
    }

    public double getDouble(Field f, Object i) {
        double d;
        try {
            d = BoxesRunTime.unboxToDouble((Object)i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            d = f.getDouble(i);
        }
        return d;
    }

    public Object get(Field f, Object i) {
        Object object;
        try {
            object = i.getClass().getDeclaredMethod(f.getName(), new Class[0]).invoke(i, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.clearPrivate(f);
            object = f.get(i);
        }
        return object;
    }

    public Object getValue(Field f, Object i) {
        return this.isBoolean(f) ? BoxesRunTime.boxToBoolean((boolean)this.getBoolean(f, i)) : (this.isByte(f) ? BoxesRunTime.boxToByte((byte)this.getByte(f, i)) : (this.isChar(f) ? BoxesRunTime.boxToCharacter((char)this.getChar(f, i)) : (this.isShort(f) ? BoxesRunTime.boxToShort((short)this.getShort(f, i)) : (this.isInt(f) ? BoxesRunTime.boxToInteger((int)this.getInt(f, i)) : (this.isLong(f) ? BoxesRunTime.boxToLong((long)this.getLong(f, i)) : (this.isFloat(f) ? BoxesRunTime.boxToFloat((float)this.getFloat(f, i)) : (this.isDouble(f) ? BoxesRunTime.boxToDouble((double)this.getDouble(f, i)) : this.get(f, i))))))));
    }

    private FieldUtil$() {
        MODULE$ = this;
    }
}

