/*
 * Decompiled with CFR 0.152.
 */
package modbat.mbt;

import com.miguno.akka.testing.VirtualTime;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import modbat.dsl.Action;
import modbat.dsl.After;
import modbat.dsl.Before;
import modbat.dsl.Model;
import modbat.dsl.Transition;
import modbat.dsl.Transition$;
import modbat.log.Log$;
import modbat.mbt.MBT;
import modbat.mbt.Main$;
import modbat.mbt.NoTransitionsException;
import modbat.trace.MaybeChoice;
import modbat.util.CloneableRandom;
import modbat.util.Random;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.matching.Regex;

public final class MBT$ {
    public static final MBT$ MODULE$;
    private Class<?> modelClass;
    private final ArrayBuffer<MBT> launchedModels;
    private final ArrayBuffer<Model> launchedModelInst;
    private final HashSet<Method> invokedStaticMethods;
    private final Queue<Tuple2<MBT, String>> transitionQueue;
    private Random rng;
    private boolean rethrowExceptions;
    private URL[] classLoaderURLs;
    private boolean isOffline;
    private boolean or_else;
    private boolean checkDuplicates;
    private boolean testHasFailed;
    private Throwable externalException;
    private final Thread modbatThread;
    private final HashSet<Object> warningIssuedOn;
    private Transition currentTransition;
    private final Object stayLock;
    private final VirtualTime time;

    static {
        new MBT$();
    }

    public Class<?> modelClass() {
        return this.modelClass;
    }

    public void modelClass_$eq(Class<?> x$1) {
        this.modelClass = x$1;
    }

    public ArrayBuffer<MBT> launchedModels() {
        return this.launchedModels;
    }

    public ArrayBuffer<Model> launchedModelInst() {
        return this.launchedModelInst;
    }

    public HashSet<Method> invokedStaticMethods() {
        return this.invokedStaticMethods;
    }

    public Queue<Tuple2<MBT, String>> transitionQueue() {
        return this.transitionQueue;
    }

    public Random rng() {
        return this.rng;
    }

    public void rng_$eq(Random x$1) {
        this.rng = x$1;
    }

    public boolean rethrowExceptions() {
        return this.rethrowExceptions;
    }

    public void rethrowExceptions_$eq(boolean x$1) {
        this.rethrowExceptions = x$1;
    }

    public URL[] classLoaderURLs() {
        return this.classLoaderURLs;
    }

    public void classLoaderURLs_$eq(URL[] x$1) {
        this.classLoaderURLs = x$1;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void isOffline_$eq(boolean x$1) {
        this.isOffline = x$1;
    }

    public boolean or_else() {
        return this.or_else;
    }

    public void or_else_$eq(boolean x$1) {
        this.or_else = x$1;
    }

    public boolean checkDuplicates() {
        return this.checkDuplicates;
    }

    public void checkDuplicates_$eq(boolean x$1) {
        this.checkDuplicates = x$1;
    }

    public boolean testHasFailed() {
        return this.testHasFailed;
    }

    public void testHasFailed_$eq(boolean x$1) {
        this.testHasFailed = x$1;
    }

    public Throwable externalException() {
        return this.externalException;
    }

    public void externalException_$eq(Throwable x$1) {
        this.externalException = x$1;
    }

    public Thread modbatThread() {
        return this.modbatThread;
    }

    public HashSet<Object> warningIssuedOn() {
        return this.warningIssuedOn;
    }

    public Transition currentTransition() {
        return this.currentTransition;
    }

    public void currentTransition_$eq(Transition x$1) {
        this.currentTransition = x$1;
    }

    public Object stayLock() {
        return this.stayLock;
    }

    public VirtualTime time() {
        return this.time;
    }

    public void init() {
        this.warningIssuedOn().clear();
    }

    public boolean warningIssued(Object o) {
        boolean bl;
        if (this.warningIssuedOn().apply(o)) {
            bl = true;
        } else {
            this.warningIssuedOn().$plus$eq(o);
            bl = false;
        }
        return bl;
    }

    public void invokeMethod(Method m, Object inst) {
        try {
            m.invoke(inst, new Object[0]);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public Method[] getMethods(Model instance) {
        return instance == null ? this.modelClass().getMethods() : instance.getClass().getMethods();
    }

    public void invokeAnnotatedStaticMethods(Class<? extends Annotation> annotationType, Model instance) {
        this.invokeAll(annotationType, instance, (Function3<Class<? extends Annotation>, Method, Object, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Class<? extends Annotation> annotationType, Method m, Object instance) {
                MBT$.MODULE$.handleStatic(annotationType, m, instance);
            }
        });
    }

    public void invokeAnnotatedMethods(Class<? extends Annotation> annotationType, Model instance) {
        this.invokeAll(annotationType, instance, (Function3<Class<? extends Annotation>, Method, Object, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Class<? extends Annotation> annotationType, Method m, Object instance) {
                MBT$.MODULE$.handleDynamic(annotationType, m, instance);
            }
        });
    }

    public void invokeAll(Class<? extends Annotation> annotationType, Model model, Function3<Class<? extends Annotation>, Method, Object, BoxedUnit> handler) {
        Method[] methods = this.getMethods(model);
        Predef$.MODULE$.refArrayOps((Object[])methods).foreach((Function1)new Serializable(annotationType, model, handler){
            public static final long serialVersionUID = 0L;
            private final Class annotationType$1;
            private final Model model$1;
            private final Function3 handler$1;

            public final void apply(Method m) {
                T annotation = m.getAnnotation(this.annotationType$1);
                if (annotation != null) {
                    this.handler$1.apply((Object)this.annotationType$1, (Object)m, (Object)this.model$1);
                }
            }
            {
                this.annotationType$1 = annotationType$1;
                this.model$1 = model$1;
                this.handler$1 = handler$1;
            }
        });
    }

    public void handleStatic(Class<? extends Annotation> annotationType, Method m, Object instance) {
        if ((m.getModifiers() & 8) != 0 && !this.invokedStaticMethods().contains((Object)m)) {
            this.invokedStaticMethods().$plus$eq((Object)m);
            Log$.MODULE$.debug(new StringBuilder().append((Object)annotationType.getSimpleName()).append((Object)": static ").append((Object)m.getName()).toString());
            m.invoke(instance, new Object[0]);
        }
    }

    public void handleDynamic(Class<? extends Annotation> annotationType, Method m, Object instance) {
        if ((m.getModifiers() & 8) == 0) {
            Log$.MODULE$.debug(new StringBuilder().append((Object)annotationType.getSimpleName()).append((Object)": ").append((Object)m.getName()).toString());
            m.invoke(instance, new Object[0]);
        }
    }

    public void configClassLoader(String classpath) {
        String sep = System.getProperty("path.separator");
        String[] paths = classpath.split(sep);
        ListBuffer urls = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(urls){
            public static final long serialVersionUID = 0L;
            private final ListBuffer urls$1;

            public final ListBuffer<URL> apply(String p) {
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Adding ").append((Object)p).append((Object)" to classpath.").toString());
                return this.urls$1.$plus$eq((Object)new File(p).toURI().toURL());
            }
            {
                this.urls$1 = urls$1;
            }
        });
        this.classLoaderURLs_$eq((URL[])urls.toArray(ClassTag$.MODULE$.apply(URL.class)));
    }

    public void setRNG(Random r) {
        this.rng_$eq(r);
    }

    public void setRNG(long seed) {
        this.rng_$eq(new CloneableRandom(seed));
    }

    public void setTestFailed(boolean failed) {
        this.testHasFailed_$eq(failed);
    }

    public boolean testFailed() {
        return this.testHasFailed();
    }

    public long getRandomSeed() {
        return this.rng().getRandomSeed();
    }

    public void clearLaunchedModels() {
        this.launchedModels().clear();
        this.launchedModelInst().clear();
        this.transitionQueue().clear();
        this.or_else_$eq(false);
        this.testHasFailed_$eq(false);
        this.currentTransition_$eq(null);
    }

    public MBT getLaunchedModel(int i) {
        return (MBT)this.launchedModels().apply(i);
    }

    public void loadModelClass(String className) {
        try {
            URLClassLoader classloader = new URLClassLoader(this.classLoaderURLs(), Thread.currentThread().getContextClassLoader());
            this.modelClass_$eq(classloader.loadClass(className));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log$.MODULE$.error(new StringBuilder().append((Object)"Class \"").append((Object)className).append((Object)"\" not found.").toString());
            throw classNotFoundException;
        }
    }

    public void prepare(Model instance) {
        if (Main$.MODULE$.config().setup()) {
            this.invokeAnnotatedStaticMethods(Before.class, instance);
            this.invokeAnnotatedMethods(Before.class, instance);
        }
    }

    public void cleanup() {
        this.invokedStaticMethods().clear();
        if (Main$.MODULE$.config().cleanup()) {
            ArrayBuffer instances = (ArrayBuffer)this.launchedModelInst().reverse();
            instances.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Model inst) {
                    MBT$.MODULE$.invokeAnnotatedMethods(After.class, inst);
                }
            });
            instances.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Model inst) {
                    MBT$.MODULE$.invokeAnnotatedStaticMethods(After.class, inst);
                }
            });
            this.invokedStaticMethods().clear();
        }
    }

    public Constructor<Model> findConstructor(Class<Model> c) {
        try {
            return c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log$.MODULE$.error("No suitable constructor found.");
            Log$.MODULE$.error("A public nullary constructor is needed to instantiate the primary model.");
            Log$.MODULE$.error("Consider adding a constructor variant:");
            Log$.MODULE$.error("  def this() = this(...)");
            throw noSuchMethodException;
        }
    }

    public Model mkModel(Model modelInstance) {
        try {
            Model model;
            if (modelInstance == null) {
                Predef$.MODULE$.assert(Transition$.MODULE$.pendingTransitions().isEmpty());
                Constructor<Model> cons = this.findConstructor(this.modelClass());
                model = cons.newInstance(new Object[0]);
            } else {
                model = modelInstance;
            }
            return model;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log$.MODULE$.error("Exception in default (nullary) constructor of main model.");
            Log$.MODULE$.error("In dot mode, a constructor that ignores any data");
            Log$.MODULE$.error("is sufficient to visualize the ESFM graph.");
            if (Main$.MODULE$.config().printStackTrace()) {
                Throwable cause = invocationTargetException.getCause();
                Log$.MODULE$.error(cause.toString());
                this.printStackTrace(cause.getStackTrace());
            } else {
                Log$.MODULE$.error("Use --print-stack-trace to see the stack trace.");
            }
            throw invocationTargetException;
        }
        catch (InstantiationException instantiationException) {
            Log$.MODULE$.error("Cannot instantiate model class.");
            Log$.MODULE$.error("The class must not be abstract or an interface.");
            throw instantiationException;
        }
        catch (ClassCastException classCastException) {
            Log$.MODULE$.error("Model class does not extend Model.");
            Log$.MODULE$.error("Check if the right class was specified.");
            throw classCastException;
        }
    }

    public MBT launch(Model modelInstance) {
        Model model = this.mkModel(modelInstance);
        if (Transition$.MODULE$.pendingTransitions().isEmpty()) {
            Log$.MODULE$.error(new StringBuilder().append((Object)"Model ").append((Object)model.getClass().getName()).append((Object)" has no transitions.").toString());
            Log$.MODULE$.error("Make sure at least one transition exists of type");
            Log$.MODULE$.error("  \"a\" -> \"b\" := { code } // or, for an empty transition:");
            Log$.MODULE$.error("  \"a\" -> \"b\" := skip");
            throw new NoTransitionsException(model.getClass().getName());
        }
        MBT inst = new MBT(model, Transition$.MODULE$.getTransitions());
        Transition$.MODULE$.clear();
        return inst.addAndLaunch(modelInstance == null);
    }

    public void printStackTrace(StackTraceElement[] trace) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                Predef$.MODULE$.refArrayOps((Object[])trace).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(StackTraceElement el) {
                        String clsName = el.getClassName();
                        if (clsName.startsWith("modbat.mbt.") && !clsName.startsWith("modbat.mbt.Predef")) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        Log$.MODULE$.error(new StringBuilder().append((Object)"\tat ").append((Object)el.toString()).toString());
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public int choose(int min, int max) {
        return min == max ? min : this.rng().choose(min, max);
    }

    public Object maybe(Action action) {
        Object object;
        if (this.or_else()) {
            this.or_else_$eq(false);
            object = action.transfunc().apply();
        } else {
            boolean choice = (double)this.rng().nextFloat(true) < Main$.MODULE$.config().maybeProbability();
            MaybeChoice maybeChoice = new MaybeChoice(choice);
            this.rng().recordChoice(maybeChoice);
            object = choice ? action.transfunc().apply() : BoxedUnit.UNIT;
        }
        return object;
    }

    public boolean maybeBool(Function0<Object> pred) {
        return (double)this.rng().nextFloat(true) < Main$.MODULE$.config().maybeProbability() ? pred.apply$mcZ$sp() : false;
    }

    public boolean matchesType(Throwable ex, Regex excPattern) {
        Class<?> e = ex.getClass();
        while (e != null) {
            Some some;
            String e2;
            Class clazz;
            Option option = excPattern.findFirstIn((CharSequence)clazz.getName());
            if (option instanceof Some && (e2 = (String)(some = (Some)option).x()) != null) {
                return true;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public boolean expected(List<Regex> exc, Throwable e) {
        Object object = new Object();
        try {
            exc.foreach((Function1)new Serializable(e, object){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;
                private final Object nonLocalReturnKey2$1;

                public final void apply(Regex ex) {
                    if (MBT$.MODULE$.matchesType(this.e$1, ex)) {
                        Log$.MODULE$.debug(new StringBuilder().append((Object)"Expected: ").append((Object)this.e$1).toString());
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, true);
                    }
                }
                {
                    this.e$1 = e$1;
                    this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                }
            });
            return false;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private MBT$() {
        MODULE$ = this;
        this.modelClass = null;
        this.launchedModels = new ArrayBuffer();
        this.launchedModelInst = new ArrayBuffer();
        this.invokedStaticMethods = new HashSet();
        this.transitionQueue = new Queue();
        this.rng = null;
        this.rethrowExceptions = false;
        this.classLoaderURLs = null;
        this.isOffline = true;
        this.or_else = false;
        this.checkDuplicates = false;
        this.testHasFailed = false;
        this.externalException = null;
        this.modbatThread = Thread.currentThread();
        this.warningIssuedOn = new HashSet();
        this.currentTransition = null;
        this.stayLock = new Object();
        this.time = new VirtualTime();
    }
}

