/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.Actor$class;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorLogging$class;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.CachePolicy$Ttl$TtlIsOrdered$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.AsyncDnsResolver$SrvType$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\u0015c!B\u0001\u0003\u0005\u0019Q!\u0001E!ts:\u001cGI\\:SKN|GN^3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002e]NT!a\u0002\u0005\u0002\u0005%|'\"A\u0005\u0002\t\u0005\\7.Y\n\u0005\u0001-\tr\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!Y2u_JL!AF\n\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0005IA\u0012BA\r\u0014\u00051\t5\r^8s\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013i\u0012\u0001C:fiRLgnZ:\u0004\u0001A\u0011adH\u0007\u0002\t%\u0011\u0001\u0005\u0002\u0002\f\t:\u001c8+\u001a;uS:<7\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0019\u0017m\u00195f!\t!S%D\u0001\u0003\u0013\t1#AA\u0007Bgft7\r\u00128t\u0007\u0006\u001c\u0007.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005i1\r\\5f]R4\u0015m\u0019;pef\u0004R\u0001\u0004\u0016-_\rK!aK\u0007\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\n.\u0013\tq3CA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z!\r\u0001\u0004h\u000f\b\u0003cYr!AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA\u001c\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\t1K7\u000f\u001e\u0006\u0003o5\u0001\"\u0001P!\u000e\u0003uR!AP \u0002\u00079,GOC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$!E%oKR\u001cvnY6fi\u0006#GM]3tgB\u0019\u0001\u0007\u000f#\u0011\u0005I)\u0015B\u0001$\u0014\u0005!\t5\r^8s%\u00164\u0007\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005C\u0001\u0013\u0001\u0011\u0015Yr\t1\u0001\u001e\u0011\u0015\u0011s\t1\u0001$\u0011\u0015As\t1\u0001*\u0011\u001dy\u0005A1A\u0005\u0004A\u000b!!Z2\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\t\ra\u0003\u0001\u0015!\u0003R\u0003\r)7\r\t\u0005\b5\u0002\u0011\r\u0011b\u0001\\\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\tA!\u001e;jY&\u0011\u0011M\u0018\u0002\b)&lWm\\;u\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006AA/[7f_V$\b\u0005C\u0004f\u0001\t\u0007I\u0011\u00014\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002_!1\u0001\u000e\u0001Q\u0001\n=\nAB\\1nKN+'O^3sg\u0002BqA\u001b\u0001A\u0002\u0013%1.A\u0005sKF,Xm\u001d;JIV\tA\u000e\u0005\u0002\r[&\u0011a.\u0004\u0002\u0006'\"|'\u000f\u001e\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u00035\u0011X-];fgRLEm\u0018\u0013fcR\u0011!/\u001e\t\u0003\u0019ML!\u0001^\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bm>\f\t\u00111\u0001m\u0003\rAH%\r\u0005\u0007q\u0002\u0001\u000b\u0015\u00027\u0002\u0015I,\u0017/^3ti&#\u0007\u0005C\u0003{\u0001\u0011%10\u0001\u0004oKb$\u0018\n\u001a\u000b\u0002Y\"9Q\u0010\u0001b\u0001\n\u0013q\u0018!\u0003:fg>dg/\u001a:t+\u0005\u0019\u0005bBA\u0001\u0001\u0001\u0006IaQ\u0001\u000be\u0016\u001cx\u000e\u001c<feN\u0004\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\be\u0016\u001cW-\u001b<f+\t\tI\u0001\u0005\u0003\u0002\f\u00055Q\"\u0001\u0001\n\u0007\u0005=QCA\u0004SK\u000e,\u0017N^3\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u00059!/Z:pYZ,G\u0003CA\f\u0003W\ti$!\u0016\u0011\u000bI\u000bI\"!\b\n\u0007\u0005m1K\u0001\u0004GkR,(/\u001a\t\u0005\u0003?\t)CD\u0002\u001f\u0003CI1!a\t\u0005\u0003-!en\u001d)s_R|7m\u001c7\n\t\u0005\u001d\u0012\u0011\u0006\u0002\t%\u0016\u001cx\u000e\u001c<fI*\u0019\u00111\u0005\u0003\t\u0011\u00055\u0012\u0011\u0003a\u0001\u0003_\tAA\\1nKB!\u0011\u0011GA\u001c\u001d\ra\u00111G\u0005\u0004\u0003ki\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u000265A\u0001\"a\u0010\u0002\u0012\u0001\u0007\u0011\u0011I\u0001\fe\u0016\fX/Z:u)f\u0004X\r\u0005\u0003\u0002D\u0005Ec\u0002BA#\u0003CqA!a\u0012\u0002P9!\u0011\u0011JA'\u001d\r\u0011\u00141J\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019IA!a\u0015\u0002*\tY!+Z9vKN$H+\u001f9f\u0011\u0019i\u0018\u0011\u0003a\u0001\u0007\"9\u0011\u0011\f\u0001\u0005\n\u0005m\u0013\u0001D:f]\u0012\fV/Z:uS>tGCBA/\u0003c\n)\bE\u0003S\u00033\ty\u0006\u0005\u0003\u0002b\u0005-d\u0002BA2\u0003OrA!!\u0012\u0002f%\u00111\u0001B\u0005\u0004\u0003S\u0012\u0011!\u0003#og\u000ec\u0017.\u001a8u\u0013\u0011\ti'a\u001c\u0003\r\u0005s7o^3s\u0015\r\tIG\u0001\u0005\b\u0003g\n9\u00061\u0001E\u0003!\u0011Xm]8mm\u0016\u0014\b\u0002CA<\u0003/\u0002\r!!\u001f\u0002\u000f5,7o]1hKB!\u0011\u0011MA>\u0013\u0011\ti(a\u001c\u0003\u0017\u0011s7/U;fgRLwN\u001c\u0005\b\u0003'\u0001A\u0011BAA)!\t9\"a!\u0002\u0006\u0006\u001d\u0005\u0002CA\u0017\u0003\u007f\u0002\r!a\f\t\u0011\u0005}\u0012q\u0010a\u0001\u0003\u0003Bq!a\u001d\u0002\u0000\u0001\u0007A\tK\u0002\u0001\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#C\u0011AC1o]>$\u0018\r^5p]&!\u0011QSAH\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\b\u0011\u0005e%\u0001#\u0001\u0007\u00037\u000b\u0001#Q:z]\u000e$en\u001d*fg>dg/\u001a:\u0011\u0007\u0011\niJB\u0004\u0002\u0005!\u0005a!a(\u0014\u0007\u0005u5\u0002C\u0004I\u0003;#\t!a)\u0015\u0005\u0005m\u0005BCAT\u0003;\u0013\r\u0011\"\u0003\u0002*\u0006Y\u0011\u000e\u001d<5\u0003\u0012$'/Z:t+\t\tY\u000b\u0005\u0003\u0002.\u0006UVBAAX\u0015\u0011\t\t,a-\u0002\u00115\fGo\u00195j]\u001eT!aX\u0007\n\t\u0005]\u0016q\u0016\u0002\u0006%\u0016<W\r\u001f\u0005\n\u0003w\u000bi\n)A\u0005\u0003W\u000bA\"\u001b9wi\u0005#GM]3tg\u0002B!\"a0\u0002\u001e\n\u0007I\u0011BAU\u0003-I\u0007O\u001e\u001cBI\u0012\u0014Xm]:\t\u0013\u0005\r\u0017Q\u0014Q\u0001\n\u0005-\u0016\u0001D5qmZ\nE\r\u001a:fgN\u0004\u0003\u0002CAd\u0003;#I!!3\u0002\u001b%\u001c\u0018J\\3u\u0003\u0012$'/Z:t)\u0011\tY-!5\u0011\u00071\ti-C\u0002\u0002P6\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002.\u0005\u0015\u0007\u0019AA\u0018\u0011)\t).!(C\u0002\u0013%\u0011q[\u0001\u0006\u000b6\u0004H/_\u000b\u0003\u0003;B\u0011\"a7\u0002\u001e\u0002\u0006I!!\u0018\u0002\r\u0015k\u0007\u000f^=!\r)\ty.!(\u0011\u0002G\u0005\u0012\u0011\u001d\u0002\n#V,'/\u001f+za\u0016\u001c2!!8\fS!\ti.!:\u0003^\t\u0005e\u0001CAt\u0003;C))!;\u0003\u0011%\u0003h\u000f\u000e+za\u0016\u001c\u0012\"!:\f\u0003W\fy/!>\u0011\t\u00055\u0018Q\\\u0007\u0003\u0003;\u00032\u0001DAy\u0013\r\t\u00190\u0004\u0002\b!J|G-^2u!\ra\u0011q_\u0005\u0004\u0003sl!\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002%\u0002f\u0012\u0005\u0011Q \u000b\u0003\u0003\u007f\u0004B!!<\u0002f\"Q!1AAs\u0003\u0003%\tE!\u0002\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0001\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011iaP\u0001\u0005Y\u0006tw-\u0003\u0003\u0002:\t-\u0001B\u0003B\n\u0003K\f\t\u0011\"\u0001\u0003\u0016\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0003\t\u0004\u0019\te\u0011b\u0001B\u000e\u001b\t\u0019\u0011J\u001c;\t\u0015\t}\u0011Q]A\u0001\n\u0003\u0011\t#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\r\"\u0011\u0006\t\u0004\u0019\t\u0015\u0012b\u0001B\u0014\u001b\t\u0019\u0011I\\=\t\u0013Y\u0014i\"!AA\u0002\t]\u0001B\u0003B\u0017\u0003K\f\t\u0011\"\u0011\u00030\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00032A1!1\u0007B\u001d\u0005Gi!A!\u000e\u000b\u0007\t]R\"\u0001\u0006d_2dWm\u0019;j_:LAAa\u000f\u00036\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003@\u0005\u0015\u0018\u0011!C\u0001\u0005\u0003\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\u0014\u0019\u0005C\u0005w\u0005{\t\t\u00111\u0001\u0003$!Q!qIAs\u0003\u0003%\tE!\u0013\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u0006\t\u0015\t5\u0013Q]A\u0001\n\u0003\u0012y%\u0001\u0005u_N#(/\u001b8h)\t\u00119\u0001\u0003\u0006\u0003T\u0005\u0015\u0018\u0011!C\u0005\u0005+\n1B]3bIJ+7o\u001c7wKR\u0011!q\u000b\t\u0005\u0005\u0013\u0011I&\u0003\u0003\u0003\\\t-!AB(cU\u0016\u001cGO\u0002\u0005\u0003`\u0005u\u0005R\u0011B1\u0005!I\u0005O\u001e\u001cUsB,7#\u0003B/\u0017\u0005-\u0018q^A{\u0011\u001dA%Q\fC\u0001\u0005K\"\"Aa\u001a\u0011\t\u00055(Q\f\u0005\u000b\u0005\u0007\u0011i&!A\u0005B\t\u0015\u0001B\u0003B\n\u0005;\n\t\u0011\"\u0001\u0003\u0016!Q!q\u0004B/\u0003\u0003%\tAa\u001c\u0015\t\t\r\"\u0011\u000f\u0005\nm\n5\u0014\u0011!a\u0001\u0005/A!B!\f\u0003^\u0005\u0005I\u0011\tB\u0018\u0011)\u0011yD!\u0018\u0002\u0002\u0013\u0005!q\u000f\u000b\u0005\u0003\u0017\u0014I\bC\u0005w\u0005k\n\t\u00111\u0001\u0003$!Q!q\tB/\u0003\u0003%\tE!\u0013\t\u0015\t5#QLA\u0001\n\u0003\u0012y\u0005\u0003\u0006\u0003T\tu\u0013\u0011!C\u0005\u0005+2\u0001Ba!\u0002\u001e\"\u0015%Q\u0011\u0002\b'J4H+\u001f9f'%\u0011\tiCAv\u0003_\f)\u0010C\u0004I\u0005\u0003#\tA!#\u0015\u0005\t-\u0005\u0003BAw\u0005\u0003C!Ba\u0001\u0003\u0002\u0006\u0005I\u0011\tB\u0003\u0011)\u0011\u0019B!!\u0002\u0002\u0013\u0005!Q\u0003\u0005\u000b\u0005?\u0011\t)!A\u0005\u0002\tME\u0003\u0002B\u0012\u0005+C\u0011B\u001eBI\u0003\u0003\u0005\rAa\u0006\t\u0015\t5\"\u0011QA\u0001\n\u0003\u0012y\u0003\u0003\u0006\u0003@\t\u0005\u0015\u0011!C\u0001\u00057#B!a3\u0003\u001e\"IaO!'\u0002\u0002\u0003\u0007!1\u0005\u0005\u000b\u0005\u000f\u0012\t)!A\u0005B\t%\u0003B\u0003B'\u0005\u0003\u000b\t\u0011\"\u0011\u0003P!Q!1\u000bBA\u0003\u0003%IA!\u0016\b\u0011\t\u001d\u0016Q\u0014EC\u0003\u007f\f\u0001\"\u00139wiQK\b/Z\u0004\t\u0005W\u000bi\n#\"\u0003h\u0005A\u0011\n\u001d<7)f\u0004Xm\u0002\u0005\u00030\u0006u\u0005R\u0011BF\u0003\u001d\u0019&O\u001e+za\u00164qAa-\u0002\u001e\u0002\u0013)L\u0001\fSKN|GN^3GC&dW\rZ#yG\u0016\u0004H/[8o'!\u0011\tLa.\u0002p\u0006U\bc\u0001\u0019\u0003:&\u0019!1\u0018\u001e\u0003\u0013\u0015C8-\u001a9uS>t\u0007b\u0003B`\u0005c\u0013)\u001a!C\u0001\u0005\u0003\f1!\\:h+\t\ty\u0003C\u0006\u0003F\nE&\u0011#Q\u0001\n\u0005=\u0012\u0001B7tO\u0002Bq\u0001\u0013BY\t\u0003\u0011I\r\u0006\u0003\u0003L\n5\u0007\u0003BAw\u0005cC\u0001Ba0\u0003H\u0002\u0007\u0011q\u0006\u0005\u000b\u0005#\u0014\t,!A\u0005\u0002\tM\u0017\u0001B2paf$BAa3\u0003V\"Q!q\u0018Bh!\u0003\u0005\r!a\f\t\u0015\te'\u0011WI\u0001\n\u0003\u0011Y.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu'\u0006BA\u0018\u0005?\\#A!9\u0011\t\t\r(1^\u0007\u0003\u0005KTAAa:\u0003j\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#k\u0011\u0002\u0002Bw\u0005K\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011\u0019A!-\u0002\u0002\u0013\u0005#Q\u0001\u0005\u000b\u0005'\u0011\t,!A\u0005\u0002\tU\u0001B\u0003B\u0010\u0005c\u000b\t\u0011\"\u0001\u0003vR!!1\u0005B|\u0011%1(1_A\u0001\u0002\u0004\u00119\u0002\u0003\u0006\u0003.\tE\u0016\u0011!C!\u0005_A!Ba\u0010\u00032\u0006\u0005I\u0011\u0001B\u007f)\u0011\tYMa@\t\u0013Y\u0014Y0!AA\u0002\t\r\u0002B\u0003B$\u0005c\u000b\t\u0011\"\u0011\u0003J!Q1Q\u0001BY\u0003\u0003%\tea\u0002\u0002\r\u0015\fX/\u00197t)\u0011\tYm!\u0003\t\u0013Y\u001c\u0019!!AA\u0002\t\rrACB\u0007\u0003;\u000b\t\u0011#\u0001\u0004\u0010\u00051\"+Z:pYZ,g)Y5mK\u0012,\u0005pY3qi&|g\u000e\u0005\u0003\u0002n\u000eEaA\u0003BZ\u0003;\u000b\t\u0011#\u0001\u0004\u0014M11\u0011CB\u000b\u0003k\u0004\u0002ba\u0006\u0004\u001e\u0005=\"1Z\u0007\u0003\u00073Q1aa\u0007\u000e\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\b\u0004\u001a\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\t\u000f!\u001b\t\u0002\"\u0001\u0004$Q\u00111q\u0002\u0005\u000b\u0005\u001b\u001a\t\"!A\u0005F\t=\u0003BCB\u0015\u0007#\t\t\u0011\"!\u0004,\u0005)\u0011\r\u001d9msR!!1ZB\u0017\u0011!\u0011yla\nA\u0002\u0005=\u0002BCB\u0019\u0007#\t\t\u0011\"!\u00044\u00059QO\\1qa2LH\u0003BB\u001b\u0007w\u0001R\u0001DB\u001c\u0003_I1a!\u000f\u000e\u0005\u0019y\u0005\u000f^5p]\"Q1QHB\u0018\u0003\u0003\u0005\rAa3\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003T\rE\u0011\u0011!C\u0005\u0005+BC!!(\u0002\f\"\"\u0011qSAF\u0001")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    public final AsyncDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    @TraitSetter
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging$class.log(this);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    @Override
    public final ActorRef sender() {
        return Actor$class.sender(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor$class.aroundReceive(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor$class.aroundPreStart(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor$class.aroundPostStop(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor$class.aroundPreRestart(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor$class.aroundPostRestart(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor$class.supervisorStrategy(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor$class.preStart(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor$class.postStop(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor$class.preRestart(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor$class.postRestart(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor$class.unhandled(this, message);
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    String name = resolve2.name();
                    DnsProtocol.RequestType mode = resolve2.requestType();
                    akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolve(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        List<ActorRef> list;
        block6: {
            Future future2;
            block3: {
                Future future3;
                block5: {
                    block4: {
                        block2: {
                            if (!AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) break block2;
                            future2 = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)new Serializable(this, name){
                                public static final long serialVersionUID = 0L;
                                private final String name$2;

                                public final DnsProtocol.Resolved apply() {
                                    InetAddress inetAddress;
                                    block4: {
                                        ARecord record;
                                        ResourceRecord resourceRecord;
                                        block3: {
                                            block2: {
                                                InetAddress address = InetAddress.getByName(this.name$2);
                                                inetAddress = address;
                                                if (!(inetAddress instanceof Inet4Address)) break block2;
                                                resourceRecord = new ARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                                                break block3;
                                            }
                                            if (!(inetAddress instanceof Inet6Address)) break block4;
                                            Inet6Address inet6Address = (Inet6Address)inetAddress;
                                            resourceRecord = new AAAARecord(this.name$2, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                                        }
                                        ARecord aRecord = record = resourceRecord;
                                        return DnsProtocol$Resolved$.MODULE$.apply(this.name$2, (scala.collection.immutable.Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
                                    }
                                    throw new MatchError((Object)inetAddress);
                                }
                                {
                                    this.name$2 = name$2;
                                }
                            }));
                            break block3;
                        }
                        list = resolvers;
                        if (!Nil$.MODULE$.equals(list)) break block4;
                        future3 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out resolving ", " with nameservers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.nameServers()}))));
                        break block5;
                    }
                    if (!(list instanceof .colon.colon)) break block6;
                    .colon.colon colon2 = (.colon.colon)list;
                    ActorRef head = (ActorRef)colon2.head();
                    List tail = colon2.tl$1();
                    future3 = this.resolve(name, requestType, head).recoverWith((PartialFunction)new Serializable(this, name, requestType, tail){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AsyncDnsResolver $outer;
                        private final String name$2;
                        private final DnsProtocol.RequestType requestType$1;
                        private final List tail$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Future<DnsProtocol.Resolved> future2;
                            A1 A1 = x2;
                            Option option = NonFatal$.MODULE$.unapply(A1);
                            if (option.isEmpty()) {
                                future2 = function1.apply(x2);
                            } else {
                                Throwable t = (Throwable)option.get();
                                this.$outer.log().error(t, "Resolve failed. Trying next name server");
                                future2 = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                            }
                            return (B1)future2;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            Option option = NonFatal$.MODULE$.unapply(throwable);
                            boolean bl = !option.isEmpty();
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.name$2 = name$2;
                            this.requestType$1 = requestType$1;
                            this.tail$1 = tail$1;
                        }
                    }, (ExecutionContext)this.ec());
                }
                future2 = future3;
            }
            return future2;
        }
        throw new MatchError(list);
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.onFailure((PartialFunction)new Serializable(this, resolver, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;
            private final ActorRef resolver$1;
            private final DnsClient.DnsQuestion message$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (option.isEmpty()) {
                    object = function1.apply(x3);
                } else {
                    package$.MODULE$.actorRef2Scala(this.resolver$1).$bang(new DnsClient.DropRequest(this.message$1.id()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
                this.message$1 = message$1;
            }
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future2;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            Future<DnsClient.Answer> future3;
            Future<DnsClient.Answer> ipv4Recs;
            Future<DnsClient.Answer> future4;
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv4 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            if (ipv4) {
                Future future5;
                Option<DnsClient.Answer> option = this.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r = (DnsClient.Answer)some.x();
                    this.log().debug("Ipv4 cached {}", r);
                    future5 = Future$.MODULE$.successful((Object)r);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    future5 = this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName));
                }
                future4 = future5;
            } else {
                future4 = ipv4Recs = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            if (ipv6) {
                Future future6;
                Option<DnsClient.Answer> option = this.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r = (DnsClient.Answer)some.x();
                    this.log().debug("Ipv6 cached {}", r);
                    future6 = Future$.MODULE$.successful((Object)r);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    future6 = this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName));
                }
                future3 = future6;
            } else {
                future3 = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            Future<DnsClient.Answer> ipv6Recs = future3;
            return ipv4Recs.flatMap((Function1)new Serializable(this, name, ipv6Recs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDnsResolver $outer;
                public final String name$1;
                private final Future ipv6Recs$1;

                public final Future<DnsProtocol.Resolved> apply(DnsClient.Answer ipv4Records) {
                    if (ipv4Records.rrs().nonEmpty()) {
                        CachePolicy.Ttl minTtl4 = (CachePolicy.Ttl)((TraversableOnce)ipv4Records.rrs().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CachePolicy.Ttl apply(ResourceRecord x$2) {
                                return x$2.ttl();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                        this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, QueryType>)new Tuple2((Object)this.name$1, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$), ipv4Records, minTtl4);
                    }
                    return this.ipv6Recs$1.map((Function1)new Serializable(this, ipv4Records){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resolve$1 $outer;
                        private final DnsClient.Answer ipv4Records$1;

                        public final scala.collection.immutable.Seq<ResourceRecord> apply(DnsClient.Answer ipv6Records) {
                            if (ipv6Records.rrs().nonEmpty()) {
                                CachePolicy.Ttl minTtl6 = (CachePolicy.Ttl)((TraversableOnce)ipv6Records.rrs().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final CachePolicy.Ttl apply(ResourceRecord x$3) {
                                        return x$3.ttl();
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                                this.$outer.akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer().akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, QueryType>)new Tuple2((Object)this.$outer.name$1, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$), ipv6Records, minTtl6);
                            }
                            return (scala.collection.immutable.Seq)this.ipv4Records$1.rrs().$plus$plus(ipv6Records.rrs(), Seq$.MODULE$.canBuildFrom());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ipv4Records$1 = ipv4Records$1;
                        }
                    }, (ExecutionContext)this.$outer.ec()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resolve$1 $outer;

                        public final DnsProtocol.Resolved apply(scala.collection.immutable.Seq<ResourceRecord> recs) {
                            return DnsProtocol$Resolved$.MODULE$.apply(this.$outer.name$1, recs);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (ExecutionContext)this.$outer.ec());
                }

                public /* synthetic */ AsyncDnsResolver akka$io$dns$internal$AsyncDnsResolver$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$1 = name$1;
                    this.ipv6Recs$1 = ipv6Recs$1;
                }
            }, (ExecutionContext)this.ec());
        }
        if (!DnsProtocol$Srv$.MODULE$.equals(requestType2)) throw new MatchError((Object)requestType2);
        Option<DnsClient.Answer> option = this.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$SrvType$.MODULE$));
        if (option instanceof Some) {
            Some some = (Some)option;
            DnsClient.Answer r = (DnsClient.Answer)some.x();
            future2 = Future$.MODULE$.successful((Object)new DnsProtocol.Resolved(name, r.rrs(), r.additionalRecs()));
            return future2;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            future2 = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDnsResolver $outer;
                private final String name$1;

                public final DnsProtocol.Resolved apply(DnsClient.Answer answer) {
                    if (answer.rrs().nonEmpty()) {
                        CachePolicy.Ttl minTtl = (CachePolicy.Ttl)((TraversableOnce)answer.rrs().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final CachePolicy.Ttl apply(ResourceRecord x$4) {
                                return x$4.ttl();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                        this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, QueryType>)new Tuple2((Object)this.name$1, (Object)AsyncDnsResolver$SrvType$.MODULE$), answer, minTtl);
                    }
                    return new DnsProtocol.Resolved(this.name$1, answer.rrs(), answer.additionalRecs());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$1 = name$1;
                }
            }, (ExecutionContext)this.ec());
        }
        return future2;
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor$class.$init$(this);
        ActorLogging$class.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.log().debug("Using name servers [{}]", this.nameServers());
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static interface QueryType {
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.class.$init$((Product)this);
        }
    }
}

