/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorCell$;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ChildActorPath;
import akka.actor.ChildNameReserved$;
import akka.actor.ChildRestartStats;
import akka.actor.ChildRestartStats$;
import akka.actor.ChildStats;
import akka.actor.Deploy;
import akka.actor.FunctionRef;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.LocalScope$;
import akka.actor.MinimalActorRef;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Nobody$;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.dungeon.AbstractActorCell;
import akka.actor.dungeon.Children$;
import akka.actor.dungeon.ChildrenContainer;
import akka.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.Helpers$;
import akka.util.Unsafe;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

public abstract class Children$class {
    public static ChildrenContainer childrenRefs(ActorCell $this) {
        return (ChildrenContainer)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.childrenOffset);
    }

    public static final Iterable children(ActorCell $this) {
        return $this.childrenRefs().children();
    }

    public static final java.lang.Iterable getChildren(ActorCell $this) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter($this.children()).asJava();
    }

    public static final Option child(ActorCell $this, String name) {
        return Option$.MODULE$.apply((Object)$this.getChild(name));
    }

    public static final ActorRef getChild(ActorCell $this, String name) {
        ActorRef actorRef;
        Some some;
        ChildStats s;
        Option<ChildStats> option = $this.childrenRefs().getByName(name);
        if (option instanceof Some && (s = (ChildStats)(some = (Some)option).x()) instanceof ChildRestartStats) {
            ChildRestartStats childRestartStats = (ChildRestartStats)s;
            actorRef = childRestartStats.child();
        } else {
            actorRef = null;
        }
        return actorRef;
    }

    public static Optional findChild(ActorCell $this, String name) {
        return Optional.ofNullable($this.getChild(name));
    }

    public static ActorRef actorOf(ActorCell $this, Props props2) {
        return Children$class.makeChild($this, $this, props2, $this.randomName(), false, false);
    }

    public static ActorRef actorOf(ActorCell $this, Props props2, String name) {
        return Children$class.makeChild($this, $this, props2, Children$class.checkName($this, name), false, false);
    }

    public static ActorRef attachChild(ActorCell $this, Props props2, boolean systemService) {
        return Children$class.makeChild($this, $this, props2, $this.randomName(), true, systemService);
    }

    public static ActorRef attachChild(ActorCell $this, Props props2, String name, boolean systemService) {
        return Children$class.makeChild($this, $this, props2, Children$class.checkName($this, name), true, systemService);
    }

    private static Map functionRefs(ActorCell $this) {
        return (Map)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.functionRefsOffset);
    }

    public static InternalActorRef getFunctionRefOrNobody(ActorCell $this, String name, int uid) {
        InternalActorRef internalActorRef;
        MinimalActorRef minimalActorRef = (MinimalActorRef)Children$class.functionRefs($this).getOrElse((Object)name, Children$.MODULE$.GetNobody());
        if (minimalActorRef instanceof FunctionRef) {
            FunctionRef functionRef = (FunctionRef)minimalActorRef;
            internalActorRef = uid == 0 || functionRef.path().uid() == uid ? functionRef : Nobody$.MODULE$;
        } else {
            internalActorRef = (InternalActorRef)((Object)minimalActorRef);
        }
        return internalActorRef;
    }

    public static int getFunctionRefOrNobody$default$2(ActorCell $this) {
        return 0;
    }

    public static FunctionRef addFunctionRef(ActorCell $this, Function2 f, String name) {
        String r = $this.randomName(new StringBuilder("$$"));
        String string = name;
        String string2 = "";
        String n = !(string != null ? !string.equals(string2) : string2 != null) ? r : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r, name}));
        ChildActorPath childPath = new ChildActorPath($this.self().path(), n, ActorCell$.MODULE$.newUid());
        FunctionRef ref = new FunctionRef(childPath, $this.provider(), $this.system().eventStream(), (Function2<ActorRef, Object, BoxedUnit>)f);
        Children$class.rec$1($this, childPath, ref);
        return ref;
    }

    public static String addFunctionRef$default$2(ActorCell $this) {
        return "";
    }

    public static boolean removeFunctionRef(ActorCell $this, FunctionRef ref) {
        Predef$.MODULE$.require(ref.path().parent() == $this.self().path(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "trying to remove FunctionRef from wrong ActorCell";
            }
        });
        String name = ref.path().name();
        return Children$class.rec$2($this, name, ref);
    }

    public static void stopFunctionRefs(ActorCell $this) {
        Map refs = (Map)Unsafe.instance.getAndSetObject($this, AbstractActorCell.functionRefsOffset, Predef$.MODULE$.Map().empty());
        refs.valuesIterator().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(FunctionRef x$1) {
                x$1.stop();
            }
        });
    }

    public static final String randomName(ActorCell $this, StringBuilder sb) {
        long num = Unsafe.instance.getAndAddLong($this, AbstractActorCell.nextNameOffset, 1L);
        return Helpers$.MODULE$.base64(num, sb);
    }

    public static final String randomName(ActorCell $this) {
        long num = Unsafe.instance.getAndAddLong($this, AbstractActorCell.nextNameOffset, 1L);
        return Helpers$.MODULE$.base64(num, Helpers$.MODULE$.base64$default$2());
    }

    public static final void stop(ActorCell $this, ActorRef actor) {
        Object object;
        if ($this.childrenRefs().getByRef(actor).isDefined()) {
            boolean bl;
            ActorRef actorRef = actor;
            if (actorRef instanceof RepointableRef) {
                ActorRef actorRef2 = actorRef;
                bl = ((RepointableRef)((Object)actorRef2)).isStarted();
            } else {
                bl = true;
            }
            object = bl ? BoxesRunTime.boxToBoolean((boolean)Children$class.shallDie$1($this, actor)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        ((InternalActorRef)actor).stop();
    }

    private static final boolean swapChildrenRefs(ActorCell $this, ChildrenContainer oldChildren, ChildrenContainer newChildren) {
        return Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.childrenOffset, oldChildren, newChildren);
    }

    public static final boolean reserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.reserve(name))) continue;
            return true;
        }
    }

    public static final boolean unreserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.unreserve(name))) continue;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Option initChild(ActorCell $this, ActorRef ref) {
        Option<ChildStats> option;
        while (true) {
            ChildStats childStats;
            ChildrenContainer cc = $this.childrenRefs();
            boolean bl = false;
            Some some = null;
            option = cc.getByName(ref.path().name());
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                if (some.x() instanceof ChildRestartStats) {
                    return some;
                }
            }
            if (!bl || !ChildNameReserved$.MODULE$.equals(childStats = (ChildStats)some.x())) break;
            ChildRestartStats crs = new ChildRestartStats(ref, ChildRestartStats$.MODULE$.apply$default$2(), ChildRestartStats$.MODULE$.apply$default$3());
            String name = ref.path().name();
            if (!Children$class.swapChildrenRefs($this, cc, cc.add(name, crs))) continue;
            return new Some((Object)crs);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return None$.MODULE$;
    }

    public static final boolean setChildrenTerminationReason(ActorCell $this, ChildrenContainer.SuspendReason reason) {
        boolean bl;
        block1: {
            ChildrenContainer childrenContainer;
            while ((childrenContainer = $this.childrenRefs()) instanceof ChildrenContainer.TerminatingChildrenContainer) {
                Set<ActorRef> x$5;
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                ChildrenContainer.SuspendReason x$3 = reason;
                TreeMap<String, ChildStats> x$4 = terminatingChildrenContainer.copy$default$1();
                if (!Children$class.swapChildrenRefs($this, terminatingChildrenContainer, terminatingChildrenContainer.copy(x$4, x$5 = terminatingChildrenContainer.copy$default$2(), x$3))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final void setTerminated(ActorCell $this) {
        Unsafe.instance.putObjectVolatile($this, AbstractActorCell.childrenOffset, ChildrenContainer$TerminatedChildrenContainer$.MODULE$);
    }

    public static boolean isNormal(ActorCell $this) {
        return $this.childrenRefs().isNormal();
    }

    public static boolean isTerminating(ActorCell $this) {
        return $this.childrenRefs().isTerminating();
    }

    public static ChildrenContainer.SuspendReason waitingForChildrenOrNull(ActorCell $this) {
        ChildrenContainer.SuspendReason suspendReason;
        ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer;
        ChildrenContainer.SuspendReason w;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        ChildrenContainer.SuspendReason suspendReason2 = childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer && (w = (terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer).reason()) instanceof ChildrenContainer.WaitingForChildren ? (suspendReason = w) : null;
        return suspendReason2;
    }

    public static void suspendChildren(ActorCell $this, Set exceptFor) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this, exceptFor){
            public static final long serialVersionUID = 0L;
            private final Set exceptFor$1;

            public final void apply(ChildRestartStats x0$1) {
                ActorRef child;
                ChildRestartStats childRestartStats = x0$1;
                if (childRestartStats != null && !this.exceptFor$1.contains((Object)(child = childRestartStats.child()))) {
                    ((InternalActorRef)child).suspend();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.exceptFor$1 = exceptFor$1;
            }
        });
    }

    public static Set suspendChildren$default$1(ActorCell $this) {
        return Predef$.MODULE$.Set().empty();
    }

    public static void resumeChildren(ActorCell $this, Throwable causedByFailure, ActorRef perp) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this, causedByFailure, perp){
            public static final long serialVersionUID = 0L;
            private final Throwable causedByFailure$1;
            private final ActorRef perp$1;

            public final void apply(ChildRestartStats x0$2) {
                ActorRef child;
                ChildRestartStats childRestartStats = x0$2;
                if (childRestartStats != null && (child = childRestartStats.child()) instanceof InternalActorRef) {
                    InternalActorRef internalActorRef = (InternalActorRef)child;
                    ActorRef actorRef = this.perp$1;
                    InternalActorRef internalActorRef2 = internalActorRef;
                    internalActorRef.resume(!(actorRef != null ? !((Object)actorRef).equals(internalActorRef2) : internalActorRef2 != null) ? this.causedByFailure$1 : null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)childRestartStats);
            }
            {
                this.causedByFailure$1 = causedByFailure$1;
                this.perp$1 = perp$1;
            }
        });
    }

    public static Option getChildByName(ActorCell $this, String name) {
        return $this.childrenRefs().getByName(name);
    }

    public static Option getChildByRef(ActorCell $this, ActorRef ref) {
        return $this.childrenRefs().getByRef(ref);
    }

    public static Iterable getAllChildStats(ActorCell $this) {
        return $this.childrenRefs().stats();
    }

    /*
     * Unable to fully structure code
     */
    public static InternalActorRef getSingleChild(ActorCell $this, String name) {
        block6: {
            block5: {
                block4: {
                    if (name.indexOf(35) != -1) break block4;
                    var2_2 = $this.getChildByName(name);
                    if (var2_2 instanceof Some && (crs = (ChildStats)(var3_3 = (Some)var2_2).x()) instanceof ChildRestartStats) {
                        var5_5 = (ChildRestartStats)crs;
                        var6_6 = (InternalActorRef)var5_5.child();
                    } else {
                        var6_6 = $this.getFunctionRefOrNobody(name, $this.getFunctionRefOrNobody$default$2());
                    }
                    v0 = var6_6;
                    break block5;
                }
                var8_7 = ActorCell$.MODULE$.splitNameAndUid(name);
                if (var8_7 == null) break block6;
                childName = (String)var8_7._1();
                uid = var8_7._2$mcI$sp();
                var7_11 = var11_10 = new Tuple2((Object)childName, (Object)BoxesRunTime.boxToInteger((int)uid));
                childName = (String)var7_11._1();
                uid = var7_11._2$mcI$sp();
                var14_14 = $this.getChildByName(childName);
                if (!(var14_14 instanceof Some) || !((crs = (ChildStats)(var15_15 = (Some)var14_14).x()) instanceof ChildRestartStats)) ** GOTO lbl-1000
                var17_17 = (ChildRestartStats)crs;
                if (uid == 0 || uid == var17_17.uid()) {
                    var18_18 = (InternalActorRef)var17_17.child();
                } else lbl-1000:
                // 2 sources

                {
                    var18_18 = $this.getFunctionRefOrNobody(childName, uid);
                }
                v0 = var18_18;
            }
            return v0;
        }
        throw new MatchError(var8_7);
    }

    public static Option removeChildAndGetStateChange(ActorCell $this, ActorRef child) {
        None$ none$;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
            ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
            ChildrenContainer.SuspendReason reason = terminatingChildrenContainer.reason();
            ChildrenContainer childrenContainer2 = Children$class.removeChild$1($this, child);
            Object object = childrenContainer2 instanceof ChildrenContainer.TerminatingChildrenContainer ? None$.MODULE$ : new Some((Object)reason);
            none$ = object;
        } else {
            Children$class.removeChild$1($this, child);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static String checkName(ActorCell $this, String name) {
        String string = name;
        if (string == null) {
            throw new InvalidActorNameException("actor name must not be null");
        }
        if ("".equals(string)) {
            throw new InvalidActorNameException("actor name must not be empty");
        }
        ActorPath$.MODULE$.validatePathElement(name);
        String string2 = name;
        return string2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static ActorRef makeChild(ActorCell $this, ActorCell cell, Props props, String name, boolean async, boolean systemService) {
        block13: {
            if (!cell.system().settings().SerializeAllCreators() || systemService) ** GOTO lbl-1000
            v0 = props.deploy().scope();
            var6_6 = LocalScope$.MODULE$;
            if (v0 == null ? var6_6 != null : v0.equals(var6_6) == false) {
                oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
                ser = (Serialization)SerializationExtension$.MODULE$.apply(cell.system());
                if (oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)$this.system().provider().serializationInformation());
                }
                v1 = props.args().forall((Function1)new Serializable($this, ser){
                    public static final long serialVersionUID = 0L;
                    private final Serialization ser$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Object arg) {
                        if (arg == null) return true;
                        if (arg instanceof NoSerializationVerificationNeeded) return true;
                        Object o = arg;
                        Serializer serializer = this.ser$1.findSerializerFor(o);
                        byte[] bytes = serializer.toBinary(o);
                        String ms = Serializers$.MODULE$.manifestFor(serializer, o);
                        if (this.ser$1.deserialize(bytes, serializer.identifier(), ms).get() != null) return true;
                        return false;
                    }
                    {
                        this.ser$1 = ser$1;
                    }
                });
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
                v2 /* !! */  = BoxesRunTime.boxToBoolean((boolean)v1);
            } else lbl-1000:
            // 2 sources

            {
                v2 /* !! */  = BoxedUnit.UNIT;
            }
            if (cell.childrenRefs().isTerminating()) {
                throw new IllegalStateException("cannot create children while terminating or terminated");
            }
            $this.reserveChild(name);
            try {
                childPath = new ChildActorPath(cell.self().path(), name, ActorCell$.MODULE$.newUid());
                actor = cell.provider().actorOf(cell.systemImpl(), props, cell.self(), childPath, systemService, (Option<Deploy>)None$.MODULE$, true, async);
                if ($this.mailbox() == null) break block13;
            }
            catch (Throwable var16_16) {
                var17_17 = var16_16;
                if (var17_17 instanceof InterruptedException) {
                    var18_18 = (InterruptedException)var17_17;
                    $this.unreserveChild(name);
                    Thread.interrupted();
                    throw var18_18;
                }
                var20_19 = NonFatal$.MODULE$.unapply(var17_17);
                if (var20_19.isEmpty()) {
                    throw var16_16;
                }
                e = (Throwable)var20_19.get();
                $this.unreserveChild(name);
                throw e;
            }
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.mailbox().suspendCount()).foreach$mVc$sp((Function1)new Serializable($this, actor){
                public static final long serialVersionUID = 0L;
                private final InternalActorRef actor$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.actor$1.suspend();
                }
                {
                    this.actor$1 = actor$1;
                }
            });
        }
        $this.initChild(actor);
        actor.start();
        return actor;
        catch (Throwable var8_11) {
            try {
                var10_12 = var8_11;
                var11_13 = NonFatal$.MODULE$.unapply(var10_12);
                if (var11_13.isEmpty()) {
                    throw var8_11;
                }
                e = (Throwable)var11_13.get();
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pre-creation serialization check failed at [", "/", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cell.self().path(), name})), e);
            }
            catch (Throwable var9_15) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)var7_7);
                throw var9_15;
            }
        }
    }

    private static final void rec$1(ActorCell $this, ChildActorPath childPath$1, FunctionRef ref$1) {
        while (true) {
            Map added;
            Map old;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.functionRefsOffset, old = Children$class.functionRefs($this), added = old.updated((Object)childPath$1.name(), (Object)ref$1))) continue;
            return;
        }
    }

    private static final boolean rec$2(ActorCell $this, String name$1, FunctionRef ref$2) {
        boolean bl;
        block1: {
            Map old;
            while ((old = Children$class.functionRefs($this)).contains((Object)name$1)) {
                Map removed = (Map)old.$minus((Object)name$1);
                if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.functionRefsOffset, old, removed)) continue;
                ref$2.stop();
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean shallDie$1(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.shallDie(ref))) continue;
            return true;
        }
    }

    private static final ChildrenContainer removeChild$1(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer n;
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), n = c.remove(ref))) continue;
            return n;
        }
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer$EmptyChildrenContainer$.MODULE$);
        $this.akka$actor$dungeon$Children$$_functionRefsDoNotCallMeDirectly_$eq((Map<String, FunctionRef>)Predef$.MODULE$.Map().empty());
        $this.akka$actor$dungeon$Children$$_nextNameDoNotCallMeDirectly_$eq(0L);
    }
}

