/*
 * Decompiled with CFR 0.152.
 */
package modbat.mbt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.BitSet;
import modbat.cov.TransitionRewardTypes$;
import modbat.cov.Trie;
import modbat.cov.TrieNode;
import modbat.dsl.Init;
import modbat.dsl.Shutdown;
import modbat.dsl.State;
import modbat.dsl.Transition;
import modbat.dsl.Transition$;
import modbat.log.Log$;
import modbat.mbt.Dotify;
import modbat.mbt.MBT;
import modbat.mbt.MBT$;
import modbat.mbt.Main$;
import modbat.mbt.Modbat;
import modbat.mbt.Modbat$AppState$;
import modbat.mbt.Modbat$ShutdownHandler$;
import modbat.mbt.NoTaskException;
import modbat.mbt.NoTaskException$;
import modbat.mbt.PathInPointGraph;
import modbat.mbt.PathInStateGraph;
import modbat.mbt.PathInfo;
import modbat.mbt.TransitionQuality$;
import modbat.trace.Backtrack$;
import modbat.trace.ErrOrdering$;
import modbat.trace.ExceptionOccurred;
import modbat.trace.ExpectedExceptionMissing$;
import modbat.trace.Finished$;
import modbat.trace.Ok;
import modbat.trace.Ok$;
import modbat.trace.RecordedState;
import modbat.trace.RecordedTransition;
import modbat.trace.RecordedTransition$;
import modbat.trace.TransitionResult;
import modbat.trace.TransitionResult$;
import modbat.util.CloneableRandom;
import modbat.util.FieldUtil$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.io.StdIn$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;

public final class Modbat$ {
    public static final Modbat$ MODULE$;
    private final PrintStream origOut;
    private final PrintStream origErr;
    private PrintStream out;
    private PrintStream err;
    private String logFile;
    private String errFile;
    private int failed;
    private int count;
    private final LinkedHashMap<String, MBT> firstInstance;
    private Enumeration.Value appState;
    private ListBuffer<RecordedTransition> modbat$mbt$Modbat$$executedTransitions;
    private long modbat$mbt$Modbat$$randomSeed;
    private CloneableRandom masterRNG;
    private final HashMap<RecordedState, Object> modbat$mbt$Modbat$$timesVisited;
    private final HashMap<Tuple2<TransitionResult, String>, ListBuffer<Object>> testFailures;
    private boolean isUnitTest;
    private Trie trie;
    private ListBuffer<PathInfo> pathInfoRecorder;

    static {
        new Modbat$();
    }

    public PrintStream origOut() {
        return this.origOut;
    }

    public PrintStream origErr() {
        return this.origErr;
    }

    public PrintStream out() {
        return this.out;
    }

    public void out_$eq(PrintStream x$1) {
        this.out = x$1;
    }

    public PrintStream err() {
        return this.err;
    }

    public void err_$eq(PrintStream x$1) {
        this.err = x$1;
    }

    public String logFile() {
        return this.logFile;
    }

    public void logFile_$eq(String x$1) {
        this.logFile = x$1;
    }

    public String errFile() {
        return this.errFile;
    }

    public void errFile_$eq(String x$1) {
        this.errFile = x$1;
    }

    public int failed() {
        return this.failed;
    }

    public void failed_$eq(int x$1) {
        this.failed = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public LinkedHashMap<String, MBT> firstInstance() {
        return this.firstInstance;
    }

    public Enumeration.Value appState() {
        return this.appState;
    }

    public void appState_$eq(Enumeration.Value x$1) {
        this.appState = x$1;
    }

    public ListBuffer<RecordedTransition> modbat$mbt$Modbat$$executedTransitions() {
        return this.modbat$mbt$Modbat$$executedTransitions;
    }

    private void modbat$mbt$Modbat$$executedTransitions_$eq(ListBuffer<RecordedTransition> x$1) {
        this.modbat$mbt$Modbat$$executedTransitions = x$1;
    }

    public long modbat$mbt$Modbat$$randomSeed() {
        return this.modbat$mbt$Modbat$$randomSeed;
    }

    public void modbat$mbt$Modbat$$randomSeed_$eq(long x$1) {
        this.modbat$mbt$Modbat$$randomSeed = x$1;
    }

    public CloneableRandom masterRNG() {
        return this.masterRNG;
    }

    public void masterRNG_$eq(CloneableRandom x$1) {
        this.masterRNG = x$1;
    }

    public HashMap<RecordedState, Object> modbat$mbt$Modbat$$timesVisited() {
        return this.modbat$mbt$Modbat$$timesVisited;
    }

    public HashMap<Tuple2<TransitionResult, String>, ListBuffer<Object>> testFailures() {
        return this.testFailures;
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public void isUnitTest_$eq(boolean x$1) {
        this.isUnitTest = x$1;
    }

    public Trie trie() {
        return this.trie;
    }

    public void trie_$eq(Trie x$1) {
        this.trie = x$1;
    }

    private ListBuffer<PathInfo> pathInfoRecorder() {
        return this.pathInfoRecorder;
    }

    private void pathInfoRecorder_$eq(ListBuffer<PathInfo> x$1) {
        this.pathInfoRecorder = x$1;
    }

    public void init() {
        this.failed_$eq(0);
        this.count_$eq(0);
        this.firstInstance().clear();
        this.appState_$eq(Modbat$AppState$.MODULE$.AppExplore());
        this.modbat$mbt$Modbat$$executedTransitions().clear();
        this.modbat$mbt$Modbat$$timesVisited().clear();
        this.testFailures().clear();
        this.masterRNG_$eq(((CloneableRandom)MBT$.MODULE$.rng()).clone());
        MBT$.MODULE$.init();
        if (Main$.MODULE$.config().init()) {
            MBT$.MODULE$.invokeAnnotatedStaticMethods(Init.class, null);
        }
    }

    public void shutdown() {
        if (Main$.MODULE$.config().shutdown()) {
            MBT$.MODULE$.invokeAnnotatedStaticMethods(Shutdown.class, null);
        }
    }

    public String showFailure(Tuple2<TransitionResult, String> f) {
        TransitionResult transitionResult;
        block4: {
            String string;
            block3: {
                String failedTrans;
                block2: {
                    TransitionResult failureType = (TransitionResult)f._1();
                    failedTrans = (String)f._2();
                    Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(failureType));
                    transitionResult = failureType;
                    if (!(transitionResult instanceof ExceptionOccurred)) break block2;
                    ExceptionOccurred exceptionOccurred = (ExceptionOccurred)transitionResult;
                    String e = exceptionOccurred.exception();
                    string = new StringBuilder().append((Object)e).append((Object)" at ").append((Object)failedTrans).toString();
                    break block3;
                }
                if (!ExpectedExceptionMissing$.MODULE$.equals(transitionResult)) break block4;
                string = new StringBuilder().append((Object)"Expected exception did not occur at ").append((Object)failedTrans).toString();
            }
            return string;
        }
        throw new MatchError((Object)transitionResult);
    }

    public void showErrors() {
        if (this.testFailures().size() < 1) {
            return;
        }
        if (this.testFailures().size() == 1) {
            Log$.MODULE$.info("One type of test failure:");
        } else {
            Log$.MODULE$.info(new StringBuilder().append(this.testFailures().size()).append((Object)" types of test failures:").toString());
        }
        IntRef i = IntRef.create((int)0);
        ((IterableLike)this.testFailures().keySet().toSeq().sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TransitionResult, String> x, Tuple2<TransitionResult, String> y) {
                return ErrOrdering$.MODULE$.lt(x, y);
            }
        })).foreach((Function1)new Serializable(i){
            public static final long serialVersionUID = 0L;
            private final IntRef i$1;

            public final void apply(Tuple2<TransitionResult, String> f) {
                ++this.i$1.elem;
                Log$.MODULE$.info(new StringBuilder().append(this.i$1.elem).append((Object)") ").append((Object)Modbat$.MODULE$.showFailure(f)).append((Object)":").toString());
                ListBuffer rseeds = (ListBuffer)Modbat$.MODULE$.testFailures().apply(f);
                Log$.MODULE$.info(new StringBuilder().append((Object)"   ").append((Object)((TraversableForwarder)rseeds.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long x$1) {
                        return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(x$1));
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())).mkString(" ")).toString());
            }
            {
                this.i$1 = i$1;
            }
        });
    }

    public String passFailed(boolean b) {
        return b ? "passed" : "failed";
    }

    public void warnPrecond(MBT modelInst, Transition t, int idx) {
        Log$.MODULE$.info(new StringBuilder().append((Object)"Precondition ").append((Object)BoxesRunTime.boxToInteger((int)(idx + 1))).append((Object)" always ").append((Object)this.passFailed(t.coverage().precond().precondPassed().get(idx))).append((Object)" at transition ").append((Object)this.ppTrans(new RecordedTransition(modelInst, t, RecordedTransition$.MODULE$.$lessinit$greater$default$3(), RecordedTransition$.MODULE$.$lessinit$greater$default$4(), RecordedTransition$.MODULE$.$lessinit$greater$default$5()))).toString());
    }

    public void preconditionCoverage() {
        this.firstInstance().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, MBT> check$ifrefutable$1) {
                Tuple2<String, MBT> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, MBT> x$2) {
                Tuple2<String, MBT> tuple2 = x$2;
                if (tuple2 != null) {
                    MBT modelInst = (MBT)tuple2._2();
                    modelInst.transitions().foreach((Function1)new Serializable(this, modelInst){
                        public static final long serialVersionUID = 0L;
                        private final MBT modelInst$1;

                        public final void apply(Transition t) {
                            BitSet diffSet = (BitSet)t.coverage().precond().precondPassed().clone();
                            diffSet.xor(t.coverage().precond().precondFailed());
                            int idx = diffSet.nextSetBit(0);
                            while (idx != -1) {
                                Modbat$.MODULE$.warnPrecond(this.modelInst$1, t, idx);
                                if (t.coverage().precond().precondFailed().get(idx)) {
                                    idx = -1;
                                    continue;
                                }
                                idx = diffSet.nextSetBit(idx + 1);
                            }
                        }
                        {
                            this.modelInst$1 = modelInst$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private void pathCoverageDisplay() {
        if (Main$.MODULE$.config().logLevel() == Log$.MODULE$.Debug()) {
            Trie qual$1 = this.trie();
            TrieNode x$37 = this.trie().root();
            int x$38 = qual$1.display$default$2();
            qual$1.display(x$37, x$38);
        }
        int numOfPaths2 = this.trie().numOfPaths(this.trie().root());
        Log$.MODULE$.info(new StringBuilder().append(numOfPaths2).append((Object)" main paths executed.").toString());
        Trie qual$2 = this.trie();
        TrieNode x$39 = this.trie().root();
        int x$40 = qual$2.shortestPath$default$2();
        int x$41 = qual$2.shortestPath$default$3();
        int shortestPath2 = qual$2.shortestPath(x$39, x$40, x$41);
        Log$.MODULE$.info(new StringBuilder().append((Object)"the shortest path has ").append((Object)BoxesRunTime.boxToInteger((int)shortestPath2)).append((Object)" transitions.").toString());
        Trie qual$3 = this.trie();
        TrieNode x$42 = this.trie().root();
        int x$43 = qual$3.longestPath$default$2();
        int longestPath2 = qual$3.longestPath(x$42, x$43);
        Log$.MODULE$.info(new StringBuilder().append((Object)"the longest path has ").append((Object)BoxesRunTime.boxToInteger((int)longestPath2)).append((Object)" transitions.").toString());
        Trie qual$4 = this.trie();
        TrieNode x$44 = this.trie().root();
        int x$45 = qual$4.pathLengthRecorder$default$2();
        Map<Object, Object> x$46 = qual$4.pathLengthRecorder$default$3();
        Map<Object, Object> pathLengthResults = qual$4.pathLengthRecorder(x$44, x$45, x$46);
        Log$.MODULE$.info(new StringBuilder().append((Object)"path length results: ").append(pathLengthResults).toString());
        double averageLength = BoxesRunTime.unboxToDouble((Object)pathLengthResults.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x0$1, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$1), x1$1);
                if (tuple2 != null) {
                    double a = tuple2._1$mcD$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int k = tuple22._1$mcI$sp();
                        int v = tuple22._2$mcI$sp();
                        double d = a + (double)(k * v);
                        return d;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        })) / (double)numOfPaths2;
        Log$.MODULE$.info(new StringBuilder().append((Object)"the average length of paths is: ").append((Object)BoxesRunTime.boxToDouble((double)averageLength)).toString());
        double stdDev = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)pathLengthResults.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(averageLength){
            public static final long serialVersionUID = 0L;
            private final double averageLength$1;

            public final double apply(double x0$2, Tuple2<Object, Object> x1$2) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$2), x1$2);
                if (tuple2 != null) {
                    double a = tuple2._1$mcD$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int k = tuple22._1$mcI$sp();
                        int v = tuple22._2$mcI$sp();
                        double d = a + package$.MODULE$.pow((double)k - this.averageLength$1, 2.0) * (double)v;
                        return d;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.averageLength$1 = averageLength$1;
            }
        })) / (double)numOfPaths2);
        Log$.MODULE$.info(new StringBuilder().append((Object)"the standard deviation for the length of paths is: ").append((Object)BoxesRunTime.boxToDouble((double)stdDev)).toString());
        Tuple7<Object, Object, Object, Object, Object, Object, Object> tuple7 = new PathInPointGraph(this.trie().root(), "Point", "root").dotify();
        if (tuple7 != null) {
            Tuple7 tuple72;
            int numNodePG = BoxesRunTime.unboxToInt((Object)tuple7._1());
            int numChoiceNodePG = BoxesRunTime.unboxToInt((Object)tuple7._2());
            int numBacktrackedEdgePG = BoxesRunTime.unboxToInt((Object)tuple7._3());
            int numFailedEdgePG = BoxesRunTime.unboxToInt((Object)tuple7._4());
            int numNonChoiceEdgePG = BoxesRunTime.unboxToInt((Object)tuple7._5());
            int numChoiceEdgePG = BoxesRunTime.unboxToInt((Object)tuple7._6());
            int numCycleSelfTranPG = BoxesRunTime.unboxToInt((Object)tuple7._7());
            Tuple7 tuple73 = tuple72 = new Tuple7((Object)BoxesRunTime.boxToInteger((int)numNodePG), (Object)BoxesRunTime.boxToInteger((int)numChoiceNodePG), (Object)BoxesRunTime.boxToInteger((int)numBacktrackedEdgePG), (Object)BoxesRunTime.boxToInteger((int)numFailedEdgePG), (Object)BoxesRunTime.boxToInteger((int)numNonChoiceEdgePG), (Object)BoxesRunTime.boxToInteger((int)numChoiceEdgePG), (Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranPG));
            int numNodePG2 = BoxesRunTime.unboxToInt((Object)tuple73._1());
            int numChoiceNodePG2 = BoxesRunTime.unboxToInt((Object)tuple73._2());
            int numBacktrackedEdgePG2 = BoxesRunTime.unboxToInt((Object)tuple73._3());
            int numFailedEdgePG2 = BoxesRunTime.unboxToInt((Object)tuple73._4());
            int numNonChoiceEdgePG2 = BoxesRunTime.unboxToInt((Object)tuple73._5());
            int numChoiceEdgePG2 = BoxesRunTime.unboxToInt((Object)tuple73._6());
            int numCycleSelfTranPG2 = BoxesRunTime.unboxToInt((Object)tuple73._7());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of nodes in path-based graph:").append((Object)BoxesRunTime.boxToInteger((int)(numNodePG2 + numChoiceNodePG2))).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of choice nodes in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceNodePG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of edges in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)(numNonChoiceEdgePG2 + numChoiceEdgePG2))).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of non choice related edges in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numNonChoiceEdgePG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of backtracked edges in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numBacktrackedEdgePG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of failed edges in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numFailedEdgePG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of choice related edges in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceEdgePG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of cycles in path-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranPG2)).toString());
            Log$.MODULE$.info(new StringBuilder().append((Object)"---------------------- table data of PG -----------------------\nName & Test Cases & Nodes & Choice Nodes & Edges & failEdges & Cycles & LIP & LP & SP & AVE & SD\n").append((Object)MBT$.MODULE$.modelClass().getName()).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)this.count())).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)(numNodePG2 + numChoiceNodePG2))).append((Object)"  & ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceNodePG2)).append((Object)"  & ").append((Object)BoxesRunTime.boxToInteger((int)(numNonChoiceEdgePG2 + numChoiceEdgePG2))).append((Object)"   & ").append((Object)BoxesRunTime.boxToInteger((int)numFailedEdgePG2)).append((Object)"         & ").append((Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranPG2)).append((Object)"    & ").append((Object)BoxesRunTime.boxToInteger((int)numOfPaths2)).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)longestPath2)).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)shortestPath2)).append((Object)"  & ").append((Object)BoxesRunTime.boxToDouble((double)averageLength)).append((Object)" & ").append((Object)BoxesRunTime.boxToDouble((double)stdDev)).append((Object)"\n").append((Object)"--------------------------------------------------------------").toString());
            Tuple7<Object, Object, Object, Object, Object, Object, Object> tuple74 = new PathInStateGraph(this.trie().root(), "State", "root").dotify();
            if (tuple74 != null) {
                Tuple7 tuple75;
                int numJumpedEdge = BoxesRunTime.unboxToInt((Object)tuple74._1());
                int numChoiceNodeSG = BoxesRunTime.unboxToInt((Object)tuple74._2());
                int numBacktrackedEdgeSG = BoxesRunTime.unboxToInt((Object)tuple74._3());
                int numFailedEdgeSG = BoxesRunTime.unboxToInt((Object)tuple74._4());
                int numNonChoiceEdgeSG = BoxesRunTime.unboxToInt((Object)tuple74._5());
                int numChoiceEdgeSG = BoxesRunTime.unboxToInt((Object)tuple74._6());
                int numCycleSelfTranSG = BoxesRunTime.unboxToInt((Object)tuple74._7());
                Tuple7 tuple76 = tuple75 = new Tuple7((Object)BoxesRunTime.boxToInteger((int)numJumpedEdge), (Object)BoxesRunTime.boxToInteger((int)numChoiceNodeSG), (Object)BoxesRunTime.boxToInteger((int)numBacktrackedEdgeSG), (Object)BoxesRunTime.boxToInteger((int)numFailedEdgeSG), (Object)BoxesRunTime.boxToInteger((int)numNonChoiceEdgeSG), (Object)BoxesRunTime.boxToInteger((int)numChoiceEdgeSG), (Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranSG));
                int numJumpedEdge2 = BoxesRunTime.unboxToInt((Object)tuple76._1());
                int numChoiceNodeSG2 = BoxesRunTime.unboxToInt((Object)tuple76._2());
                int numBacktrackedEdgeSG2 = BoxesRunTime.unboxToInt((Object)tuple76._3());
                int numFailedEdgeSG2 = BoxesRunTime.unboxToInt((Object)tuple76._4());
                int numNonChoiceEdgeSG2 = BoxesRunTime.unboxToInt((Object)tuple76._5());
                int numChoiceEdgeSG2 = BoxesRunTime.unboxToInt((Object)tuple76._6());
                int numCycleSelfTranSG2 = BoxesRunTime.unboxToInt((Object)tuple76._7());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of choice nodes in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceNodeSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)(numNonChoiceEdgeSG2 + numChoiceEdgeSG2 + numJumpedEdge2))).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of non choice related edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numNonChoiceEdgeSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of backtracked edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numBacktrackedEdgeSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of failed edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numFailedEdgeSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of choice related edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceEdgeSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of Jumped dotted edges in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numJumpedEdge2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"the total number of cycles in state-based graph: ").append((Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranSG2)).toString());
                Log$.MODULE$.info(new StringBuilder().append((Object)"---------------------- table data of SG -----------------------\nName & Test Cases & Choice Nodes & Edges & failEdges & Cycles\n").append((Object)MBT$.MODULE$.modelClass().getName()).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)this.count())).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)numChoiceNodeSG2)).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)(numNonChoiceEdgeSG2 + numChoiceEdgeSG2 + numJumpedEdge2))).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)numFailedEdgeSG2)).append((Object)" & ").append((Object)BoxesRunTime.boxToInteger((int)numCycleSelfTranSG2)).append((Object)"\n").append((Object)"--------------------------------------------------------------").toString());
                return;
            }
            throw new MatchError(tuple74);
        }
        throw new MatchError(tuple7);
    }

    private void pathCoverageBFSearch() {
        String input = "";
        while (true) {
            int x$51;
            int x$50;
            int x$49;
            String x$48;
            TrieNode x$47;
            Tuple7<Object, Object, Object, Object, Object, Object, Object> tuple7;
            String string = input;
            String string2 = "quit";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return;
            }
            String string3 = input = StdIn$.MODULE$.readLine();
            String string4 = "quit";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple7 = BoxedUnit.UNIT;
                continue;
            }
            String[] goal = input.split("-");
            Trie qual$5 = this.trie();
            TrieNode foundNode = qual$5.bfSearchT(x$47 = this.trie().root(), x$48 = goal[0], x$49 = new StringOps(Predef$.MODULE$.augmentString(goal[1])).toInt(), x$50 = new StringOps(Predef$.MODULE$.augmentString(goal[2])).toInt(), x$51 = qual$5.bfSearchT$default$5());
            if (foundNode.isLeaf()) {
                Log$.MODULE$.debug("the found transition is recorded in a leaf of the trie, so there is no children to print in graphs.");
                tuple7 = BoxedUnit.UNIT;
                continue;
            }
            Trie qual$6 = this.trie();
            TrieNode x$52 = foundNode;
            int x$53 = qual$6.display$default$2();
            qual$6.display(x$52, x$53);
            new PathInStateGraph(foundNode, "State", input).dotify();
            tuple7 = new PathInPointGraph(foundNode, "Point", input).dotify();
        }
    }

    public void coverage() {
        if (Main$.MODULE$.config().dotifyPathCoverage()) {
            this.pathCoverageDisplay();
            if (Main$.MODULE$.config().bfsearchFun()) {
                this.pathCoverageBFSearch();
            }
        }
        Log$.MODULE$.info(new StringBuilder().append(this.count()).append((Object)" tests executed, ").append((Object)BoxesRunTime.boxToInteger((int)(this.count() - this.failed()))).append((Object)" ok, ").append((Object)BoxesRunTime.boxToInteger((int)this.failed())).append((Object)" failed.").toString());
        if (this.count() == 0) {
            return;
        }
        this.showErrors();
        this.firstInstance().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, MBT> check$ifrefutable$2) {
                Tuple2<String, MBT> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, MBT> x$7) {
                Tuple2<String, MBT> tuple2 = x$7;
                if (tuple2 != null) {
                    String modelName = (String)tuple2._1();
                    MBT modelInst = (MBT)tuple2._2();
                    int nCoveredStates = ((TraversableOnce)modelInst.states().values().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(State x$5) {
                            return x$5.coverage().isCovered();
                        }
                    })).size();
                    int nCoveredTrans = ((ListBuffer)modelInst.transitions().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Transition x$6) {
                            return x$6.coverage().isCovered();
                        }
                    })).size();
                    String modelStr = "";
                    if (Modbat$.MODULE$.firstInstance().size() != 1) {
                        modelStr = new StringBuilder().append((Object)modelName).append((Object)": ").toString();
                    }
                    int nStates = modelInst.states().size();
                    int nTrans = modelInst.transitions().size();
                    Log$.MODULE$.info(new StringBuilder().append((Object)modelStr).append((Object)BoxesRunTime.boxToInteger((int)nCoveredStates)).append((Object)" states covered (").append((Object)BoxesRunTime.boxToInteger((int)(nCoveredStates * 100 / nStates))).append((Object)" % out of ").append((Object)BoxesRunTime.boxToInteger((int)nStates)).append((Object)"),").toString());
                    Log$.MODULE$.info(new StringBuilder().append((Object)modelStr).append((Object)BoxesRunTime.boxToInteger((int)nCoveredTrans)).append((Object)" transitions covered (").append((Object)BoxesRunTime.boxToInteger((int)(nCoveredTrans * 100 / nTrans))).append((Object)" % out of ").append((Object)BoxesRunTime.boxToInteger((int)nTrans)).append((Object)").").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.preconditionCoverage();
        this.modbat$mbt$Modbat$$randomSeed_$eq(this.masterRNG().z() << 32 | this.masterRNG().w());
        Log$.MODULE$.info(new StringBuilder().append((Object)"Random seed for next test would be: ").append((Object)RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(this.modbat$mbt$Modbat$$randomSeed()))).toString());
        if (Main$.MODULE$.config().dotifyCoverage()) {
            this.firstInstance().withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, MBT> check$ifrefutable$3) {
                    Tuple2<String, MBT> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, MBT> x$8) {
                    Tuple2<String, MBT> tuple2 = x$8;
                    if (tuple2 != null) {
                        String modelName = (String)tuple2._1();
                        MBT modelInst = (MBT)tuple2._2();
                        new Dotify(modelInst, new StringBuilder().append((Object)modelName).append((Object)".dot").toString()).dotify(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
    }

    public void restoreChannels() {
        this.restoreChannel(this.out(), this.origOut(), this.logFile(), this.restoreChannel$default$4());
        this.restoreChannel(this.err(), this.origErr(), this.errFile(), true);
    }

    public void restoreChannel(PrintStream ch, PrintStream orig, String filename, boolean isErr) {
        if (Main$.MODULE$.config().redirectOut()) {
            ch.close();
            File file = new File(filename);
            if ((Main$.MODULE$.config().deleteEmptyLog() && file.length() == 0L || Main$.MODULE$.config().removeLogOnSuccess() && !MBT$.MODULE$.testHasFailed()) && !file.delete()) {
                Log$.MODULE$.warn(new StringBuilder().append((Object)"Cannot delete file ").append((Object)filename).toString());
            }
            if (isErr) {
                System.setErr(orig);
            } else {
                System.setOut(orig);
                Console$.MODULE$.print((Object)"\u001b[2K\r");
            }
        }
    }

    public boolean restoreChannel$default$4() {
        return false;
    }

    public void explore(int n) {
        this.init();
        if (!this.isUnitTest()) {
            Runtime.getRuntime().addShutdownHook(Modbat$ShutdownHandler$.MODULE$);
        }
        this.runTests(n);
        this.coverage();
        this.appState_$eq(Modbat$AppState$.MODULE$.AppShutdown());
        this.shutdown();
        Runtime.getRuntime().removeShutdownHook(Modbat$ShutdownHandler$.MODULE$);
    }

    public long getRandomSeed() {
        CloneableRandom rng = (CloneableRandom)MBT$.MODULE$.rng();
        Predef$.MODULE$.assert(rng.w() <= 0xFFFFFFFFL);
        Predef$.MODULE$.assert(rng.z() <= 0xFFFFFFFFL);
        return rng.z() << 32 | rng.w();
    }

    public TransitionResult wrapRun() {
        return (TransitionResult)Console$.MODULE$.withErr(this.err(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TransitionResult apply() {
                return (TransitionResult)Console$.MODULE$.withOut(Modbat$.MODULE$.out(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final TransitionResult apply() {
                        void var2_2;
                        MBT model = MBT$.MODULE$.launch(null);
                        TransitionResult result = Modbat$.MODULE$.exploreModel(model);
                        MBT$.MODULE$.cleanup();
                        return var2_2;
                    }
                });
            }
        });
    }

    public TransitionResult runTest() {
        MBT$.MODULE$.clearLaunchedModels();
        MBT$.MODULE$.testHasFailed_$eq(false);
        return this.wrapRun();
    }

    public void runTests(int n) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).foreach$mVc$sp((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        MBT$.MODULE$.rng_$eq(Modbat$.MODULE$.masterRNG().clone());
                        Modbat$.MODULE$.modbat$mbt$Modbat$$randomSeed_$eq(Modbat$.MODULE$.getRandomSeed());
                        String seed = RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(Modbat$.MODULE$.modbat$mbt$Modbat$$randomSeed()));
                        int n = Modbat$.MODULE$.failed();
                        switch (n) {
                            default: {
                                Console$.MODULE$.printf("%8d %16s, %d tests failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed, BoxesRunTime.boxToInteger((int)Modbat$.MODULE$.failed())}));
                                break;
                            }
                            case 1: {
                                Console$.MODULE$.printf("%8d %16s, one test failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed}));
                                break;
                            }
                            case 0: {
                                Console$.MODULE$.printf("%8d %16s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed}));
                            }
                        }
                        Modbat$.MODULE$.logFile_$eq(new StringBuilder().append((Object)Main$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".log").toString());
                        Modbat$.MODULE$.errFile_$eq(new StringBuilder().append((Object)Main$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".err").toString());
                        if (Main$.MODULE$.config().redirectOut()) {
                            Modbat$.MODULE$.out_$eq(new PrintStream(new FileOutputStream(Modbat$.MODULE$.logFile())));
                            System.setOut(Modbat$.MODULE$.out());
                            Modbat$.MODULE$.err_$eq(new PrintStream(new FileOutputStream(Modbat$.MODULE$.errFile()), true));
                            System.setErr(Modbat$.MODULE$.err());
                        } else {
                            Console$.MODULE$.println();
                        }
                        MBT$.MODULE$.checkDuplicates_$eq(i == 1);
                        TransitionResult result = Modbat$.MODULE$.runTest();
                        Modbat$.MODULE$.count_$eq(i);
                        Modbat$.MODULE$.restoreChannels();
                        if (TransitionResult$.MODULE$.isErr(result)) {
                            Modbat$.MODULE$.failed_$eq(Modbat$.MODULE$.failed() + 1);
                        } else {
                            TransitionResult transitionResult = result;
                            Ok ok = new Ok(Ok$.MODULE$.apply$default$1());
                            Predef$.MODULE$.assert(!(transitionResult != null ? !transitionResult.equals(ok) : ok != null));
                        }
                        Modbat$.MODULE$.masterRNG().nextInt(false);
                        if (TransitionResult$.MODULE$.isErr(result) && Main$.MODULE$.config().stopOnFailure()) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public String showTrans(RecordedTransition t) {
        return t == null ? "(transition outside model such as callback)" : t.transition().ppTrans(true);
    }

    /*
     * WARNING - void declaration
     */
    public TransitionResult exploreModel(MBT model) {
        void var3_3;
        BoxedUnit boxedUnit;
        Log$.MODULE$.debug("--- Exploring model ---");
        this.modbat$mbt$Modbat$$timesVisited().clear();
        this.modbat$mbt$Modbat$$executedTransitions().clear();
        this.pathInfoRecorder().clear();
        this.modbat$mbt$Modbat$$timesVisited().$plus$eq(new Tuple2((Object)new RecordedState(model, model.initialState()), (Object)BoxesRunTime.boxToInteger((int)1)));
        model.tracedFields().fields().foreach((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final MBT model$1;

            public final void apply(Field f) {
                Object value = FieldUtil$.MODULE$.getValue(f, this.model$1.model());
                Log$.MODULE$.fine(new StringBuilder().append((Object)"Trace field ").append((Object)f.getName()).append((Object)" has initial value ").append(value).toString());
                this.model$1.tracedFields().values().update((Object)f, value);
            }
            {
                this.model$1 = model$1;
            }
        });
        Tuple2<TransitionResult, RecordedTransition> result = this.exploreSuccessors();
        TransitionResult retVal = (TransitionResult)result._1();
        RecordedTransition recordedTrans = (RecordedTransition)result._2();
        TransitionResult transitionResult = retVal;
        Ok ok = new Ok(Ok$.MODULE$.apply$default$1());
        Predef$.MODULE$.assert(!(transitionResult == null ? ok != null : !transitionResult.equals(ok)) || TransitionResult$.MODULE$.isErr(retVal));
        MBT$.MODULE$.testHasFailed_$eq(TransitionResult$.MODULE$.isErr(retVal));
        if (TransitionResult$.MODULE$.isErr(retVal)) {
            Tuple2 entry = new Tuple2((Object)retVal, (Object)this.showTrans(recordedTrans));
            ListBuffer rseeds = (ListBuffer)this.testFailures().getOrElseUpdate((Object)entry, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ListBuffer<Object> apply() {
                    return new ListBuffer();
                }
            });
            boxedUnit = rseeds.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.modbat$mbt$Modbat$$randomSeed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Log$.MODULE$.debug("--- Resetting to initial state ---");
        return var3_3;
    }

    public void addSuccessors(MBT m, ListBuffer<Tuple2<MBT, Transition>> result, boolean quiet) {
        m.successors(quiet).foreach((Function1)new Serializable(m, result, quiet){
            public static final long serialVersionUID = 0L;
            private final MBT m$1;
            private final ListBuffer result$1;
            private final boolean quiet$1;

            public final Object apply(Transition s) {
                ListBuffer listBuffer;
                int limit;
                if (!this.quiet$1) {
                    Log$.MODULE$.debug(new StringBuilder().append((Object)"State ").append((Object)s.dest()).append((Object)" in model ").append((Object)this.m$1.name()).append((Object)" was visited ").append(Modbat$.MODULE$.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(this.m$1, s.dest()), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })).append((Object)" times.").toString());
                }
                if ((limit = Main$.MODULE$.config().loopLimit()) != 0 && BoxesRunTime.unboxToInt((Object)Modbat$.MODULE$.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(this.m$1, s.dest()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) >= limit) {
                    if (this.quiet$1) {
                        listBuffer = BoxedUnit.UNIT;
                    } else {
                        Log$.MODULE$.fine(new StringBuilder().append((Object)"Detected beginning of loop ").append((Object)BoxesRunTime.boxToInteger((int)limit)).append((Object)" (model ").append((Object)this.m$1.name()).append((Object)", state ").append((Object)s.dest()).append((Object)"), filtering transition ").append((Object)s).append((Object)".").toString());
                        listBuffer = BoxedUnit.UNIT;
                    }
                } else {
                    Tuple2 succ = new Tuple2((Object)this.m$1, (Object)s);
                    listBuffer = this.result$1.$plus$eq((Object)succ);
                }
                return listBuffer;
            }
            {
                this.m$1 = m$1;
                this.result$1 = result$1;
                this.quiet$1 = quiet$1;
            }
        });
    }

    public boolean addSuccessors$default$3() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Tuple2<MBT, Transition>> allSuccessors(MBT givenModel) {
        BoxedUnit boxedUnit;
        ListBuffer result = new ListBuffer();
        if (givenModel == null) {
            Object object = MBT$.MODULE$.stayLock();
            synchronized (object) {
                Tuple2 tuple22;
                Tuple2 tuple2 = MBT$.MODULE$.launchedModels().partition((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MBT x$9) {
                        return x$9.staying();
                    }
                });
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ArrayBuffer staying = (ArrayBuffer)tuple2._1();
                ArrayBuffer notStaying = (ArrayBuffer)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)staying, (Object)notStaying);
                ArrayBuffer staying2 = (ArrayBuffer)tuple23._1();
                ArrayBuffer notStaying2 = (ArrayBuffer)tuple23._2();
                ((ResizableArray)((TraversableLike)notStaying2.filterNot((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MBT x$11) {
                        return x$11.isObserver();
                    }
                })).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MBT x$12) {
                        return x$12.joining() == null;
                    }
                })).foreach((Function1)new Serializable(result){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer result$2;

                    public final void apply(MBT m) {
                        Modbat$.MODULE$.addSuccessors(m, (ListBuffer<Tuple2<MBT, Transition>>)this.result$2, Modbat$.MODULE$.addSuccessors$default$3());
                    }
                    {
                        this.result$2 = result$2;
                    }
                });
                if (result.isEmpty() && !staying2.isEmpty()) {
                    Option<FiniteDuration> option = MBT$.MODULE$.time().scheduler().timeUntilNextTask();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FiniteDuration s = (FiniteDuration)some.x();
                        MBT$.MODULE$.time().advance(s);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return this.allSuccessors(givenModel);
                    }
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new NoTaskException(NoTaskException$.MODULE$.$lessinit$greater$default$1(), NoTaskException$.MODULE$.$lessinit$greater$default$2());
                }
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl26 : MonitorExitStatement: MONITOREXIT : object
                boxedUnit = boxedUnit3;
                return result.toList();
            }
        }
        if (givenModel.joining() == null) {
            this.addSuccessors(givenModel, (ListBuffer<Tuple2<MBT, Transition>>)result, this.addSuccessors$default$3());
        }
        boxedUnit = BoxedUnit.UNIT;
        return result.toList();
    }

    public double totalWeight(List<Tuple2<MBT, Transition>> trans) {
        DoubleRef w = DoubleRef.create((double)0.0);
        trans.foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final DoubleRef w$1;

            public final void apply(Tuple2<MBT, Transition> t) {
                this.w$1.elem += ((Transition)t._2()).action().weight();
            }
            {
                this.w$1 = w$1;
            }
        });
        return w.elem;
    }

    public Tuple2<MBT, Transition> makeChoice(List<Tuple2<MBT, Transition>> choices, double totalW) {
        String string;
        block4: {
            Tuple2<MBT, Transition> tuple2;
            block3: {
                block2: {
                    string = Main$.MODULE$.config().search();
                    if (!"random".equals(string)) break block2;
                    tuple2 = this.weightedChoice(choices, totalW);
                    break block3;
                }
                if (!"heur".equals(string)) break block4;
                tuple2 = this.heuristicChoice(choices, totalW);
            }
            return tuple2;
        }
        throw new MatchError((Object)string);
    }

    public Tuple2<MBT, Transition> heuristicChoice(List<Tuple2<MBT, Transition>> choices, double totalW) {
        Tuple2<MBT, Transition> choice = this.banditUCBERChoice(choices, totalW);
        return choice;
    }

    private Tuple2<MBT, Transition> banditUCBERChoice(List<Tuple2<MBT, Transition>> choices, double totalW) {
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Tradeoff:").append((Object)BoxesRunTime.boxToInteger((int)Main$.MODULE$.config().banditTradeoff())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Backtracked transition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().backtrackTReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Self-transition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().selfTReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Good transition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().goodTReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Failed transition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().failTReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Passed precondition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().precondPassReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Failed precondition reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().precondFailReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Passed assertion reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().assertPassReward())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"Failed assertion reward:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().assertFailReward())).toString());
        int currentStateCount = ((MBT)((Tuple2)choices.head())._1()).currentState().coverage().count();
        List transCountLst = (List)choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$13) {
                return ((Transition)x$13._2()).coverage().count();
            }
        }, List$.MODULE$.canBuildFrom());
        List precondFailedCountLst = (List)choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$14) {
                return ((Transition)x$14._2()).coverage().expectedReward().countPrecondFail();
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of failed assertion counts:").append(choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$15) {
                return ((Transition)x$15._2()).coverage().expectedReward().countAssertFail();
            }
        }, List$.MODULE$.canBuildFrom())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of passed assertion counts:").append(choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$16) {
                return ((Transition)x$16._2()).coverage().expectedReward().countAssertPass();
            }
        }, List$.MODULE$.canBuildFrom())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of passed precondition counts:").append(choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$17) {
                return ((Transition)x$17._2()).coverage().expectedReward().countPrecondPass();
            }
        }, List$.MODULE$.canBuildFrom())).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of failed precondition counts:").append((Object)precondFailedCountLst).toString());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of precond counters:").append(choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<MBT, Transition> x$18) {
                return ((Transition)x$18._2()).coverage().precond().count();
            }
        }, List$.MODULE$.canBuildFrom())).toString());
        List expectedRewardList = (List)choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<MBT, Transition> x$19) {
                return ((Transition)x$19._2()).coverage().expectedReward().expectedReward();
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of expected reward:").append((Object)expectedRewardList).toString());
        List rewardLst = (List)choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ListBuffer<Object> apply(Tuple2<MBT, Transition> x$20) {
                return ((Transition)x$20._2()).averageReward().rewardsLst();
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of reward lists for transitions:").append((Object)rewardLst).toString());
        List averageRewardLst = (List)choices.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<MBT, Transition> x$21) {
                return ((Transition)x$21._2()).averageReward().averageReward();
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** List of average rewards for transitions:").append((Object)averageRewardLst).toString());
        int nState = currentStateCount + BoxesRunTime.unboxToInt((Object)precondFailedCountLst.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** The total number of times for current state to be visited:").append((Object)BoxesRunTime.boxToInteger((int)nState)).toString());
        List nTransLst = (List)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)transCountLst, (Object)precondFailedCountLst)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$22, int x$23) {
                return this.apply$mcIII$sp(x$22, x$23);
            }

            public int apply$mcIII$sp(int x$22, int x$23) {
                return x$22 + x$23;
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** The list to store all values of counters for already selected transitions:").append((Object)nTransLst).toString());
        if (nTransLst.contains((Object)BoxesRunTime.boxToInteger((int)0))) {
            return (Tuple2)choices.apply(nTransLst.indexOf((Object)BoxesRunTime.boxToInteger((int)0)));
        }
        List banditUCBSelectedTransLst = (List)nTransLst.map((Function1)new Serializable(nState){
            public static final long serialVersionUID = 0L;
            private final int nState$1;

            public final double apply(int n) {
                return this.apply$mcDI$sp(n);
            }

            public double apply$mcDI$sp(int n) {
                return package$.MODULE$.sqrt((double)Main$.MODULE$.config().banditTradeoff() * package$.MODULE$.log((double)this.nState$1) / (double)n);
            }
            {
                this.nState$1 = nState$1;
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** banditUCBSelectedTransLst:").append((Object)banditUCBSelectedTransLst).toString());
        List banditUCB = (List)Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2(Tuple2Zipped$.MODULE$.map$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)averageRewardLst, (Object)banditUCBSelectedTransLst)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$24, double x$25) {
                return this.apply$mcDDD$sp(x$24, x$25);
            }

            public double apply$mcDDD$sp(double x$24, double x$25) {
                return x$24 + x$25;
            }
        }, List$.MODULE$.canBuildFrom()), (Object)expectedRewardList)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$26, double x$27) {
                return this.apply$mcDDD$sp(x$26, x$27);
            }

            public double apply$mcDDD$sp(double x$26, double x$27) {
                return x$26 + x$27;
            }
        }, List$.MODULE$.canBuildFrom());
        Log$.MODULE$.debug(new StringBuilder().append((Object)"*** banditUCB:").append((Object)banditUCB).toString());
        List banditUCBChoiceCandidates = (List)((TraversableLike)banditUCB.zipWithIndex(List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(banditUCB){
            public static final long serialVersionUID = 0L;
            private final List banditUCB$1;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcD$sp() == BoxesRunTime.unboxToDouble((Object)this.banditUCB$1.max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                this.banditUCB$1 = banditUCB$1;
            }
        });
        Log$.MODULE$.info(new StringBuilder().append((Object)"*** bandit UCB candidates:").append((Object)banditUCBChoiceCandidates).toString());
        Tuple2 banditUCBChoiceCandidate = (Tuple2)banditUCBChoiceCandidates.apply(MBT$.MODULE$.rng().nextInt(banditUCBChoiceCandidates.length()));
        int banditUCBChoiceIndex = banditUCBChoiceCandidate._2$mcI$sp();
        Log$.MODULE$.info(new StringBuilder().append((Object)"*** bandit UCB chosen candidate's index:").append((Object)BoxesRunTime.boxToInteger((int)banditUCBChoiceIndex)).toString());
        return (Tuple2)choices.apply(banditUCBChoiceIndex);
    }

    public Tuple2<MBT, Transition> weightedChoice(List<Tuple2<MBT, Transition>> choices, double totalW) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Tuple2 tuple2;
            Object object = new Object();
            try {
                double n = totalW * (double)MBT$.MODULE$.rng().nextFloat(false);
                DoubleRef w = DoubleRef.create((double)0.0);
                choices.foreach((Function1)new Serializable(n, w, object){
                    public static final long serialVersionUID = 0L;
                    private final double n$1;
                    private final DoubleRef w$2;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(Tuple2<MBT, Transition> c) {
                        this.w$2.elem += ((Transition)c._2()).action().weight();
                        if (this.w$2.elem >= this.n$1) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, c);
                        }
                    }
                    {
                        this.n$1 = n$1;
                        this.w$2 = w$2;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                tuple2 = (Tuple2)choices.last();
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                tuple2 = (Tuple2)nonLocalReturnControl2.value();
            }
            return tuple2;
        }
        throw nonLocalReturnControl2;
    }

    public void updateExecHistory(MBT model, CloneableRandom localStoredRNGState, Tuple2<TransitionResult, RecordedTransition> result, List<Tuple2<Field, Object>> updates2) {
        Tuple2<TransitionResult, RecordedTransition> tuple2;
        block5: {
            block3: {
                block4: {
                    block2: {
                        tuple2 = result;
                        if (tuple2 == null) break block2;
                        TransitionResult transitionResult = (TransitionResult)tuple2._1();
                        RecordedTransition successorTrans = (RecordedTransition)tuple2._2();
                        if (!(transitionResult instanceof Ok) || successorTrans == null) break block2;
                        RecordedTransition recordedTransition = successorTrans;
                        recordedTransition.updates_$eq(updates2);
                        recordedTransition.randomTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).trace());
                        recordedTransition.debugTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).debugTrace());
                        recordedTransition.recordedChoices_$eq(((CloneableRandom)MBT$.MODULE$.rng()).getRecordedChoices());
                        ((CloneableRandom)MBT$.MODULE$.rng()).clear();
                        this.modbat$mbt$Modbat$$executedTransitions().$plus$eq((Object)recordedTransition);
                        int timesSeen = BoxesRunTime.unboxToInt((Object)this.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(model, recordedTransition.dest()), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        this.modbat$mbt$Modbat$$timesVisited().$plus$eq(new Tuple2((Object)new RecordedState(model, recordedTransition.dest()), (Object)BoxesRunTime.boxToInteger((int)(timesSeen + 1))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (tuple2 == null) break block4;
                    TransitionResult transitionResult = (TransitionResult)tuple2._1();
                    RecordedTransition backTrackedTrans = (RecordedTransition)tuple2._2();
                    if (!Backtrack$.MODULE$.equals(transitionResult) || backTrackedTrans == null) break block4;
                    RecordedTransition recordedTransition = backTrackedTrans;
                    recordedTransition.recordedChoices_$eq(((CloneableRandom)MBT$.MODULE$.rng()).getRecordedChoices());
                    MBT$.MODULE$.rng_$eq(localStoredRNGState);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (tuple2 == null) break block5;
                TransitionResult r = (TransitionResult)tuple2._1();
                RecordedTransition failedTrans = (RecordedTransition)tuple2._2();
                if (r == null) break block5;
                TransitionResult transitionResult = r;
                if (failedTrans == null) break block5;
                RecordedTransition recordedTransition = failedTrans;
                Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(transitionResult));
                recordedTransition.randomTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).trace());
                recordedTransition.debugTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).debugTrace());
                recordedTransition.recordedChoices_$eq(((CloneableRandom)MBT$.MODULE$.rng()).getRecordedChoices());
                ((CloneableRandom)MBT$.MODULE$.rng()).clear();
                this.modbat$mbt$Modbat$$executedTransitions().$plus$eq((Object)recordedTransition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean otherThreadFailed() {
        MBT$ mBT$ = MBT$.MODULE$;
        synchronized (mBT$) {
            Boolean bl;
            if (MBT$.MODULE$.testHasFailed()) {
                this.printTrace((List<RecordedTransition>)this.modbat$mbt$Modbat$$executedTransitions().toList());
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)false);
            }
            Boolean bl2 = bl;
            return BoxesRunTime.unboxToBoolean((Object)bl2);
        }
    }

    public Option<Tuple2<MBT, Transition>> invocationSuccessor() {
        Tuple2 tuple2;
        block3: {
            ListBuffer trs;
            MBT model;
            if (!MBT$.MODULE$.transitionQueue().isEmpty()) {
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Current InvokeTransitionQueue = (").append((Object)MBT$.MODULE$.transitionQueue().mkString()).append((Object)")").toString());
            }
            while (true) {
                Tuple2 tuple22;
                if (MBT$.MODULE$.transitionQueue().isEmpty()) {
                    return None$.MODULE$;
                }
                tuple2 = (Tuple2)MBT$.MODULE$.transitionQueue().dequeue();
                if (tuple2 == null) break block3;
                MBT model2 = (MBT)tuple2._1();
                String label = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)model2, (Object)label);
                model = (MBT)tuple23._1();
                String label2 = (String)tuple23._2();
                trs = (ListBuffer)((TraversableLike)model.transitions().filter((Function1)new Serializable(label2){
                    public static final long serialVersionUID = 0L;
                    private final String label$1;

                    public final boolean apply(Transition x$29) {
                        String string = x$29.action().label();
                        String string2 = this.label$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.label$1 = label$1;
                    }
                })).filter((Function1)new Serializable(model){
                    public static final long serialVersionUID = 0L;
                    private final MBT model$2;

                    public final boolean apply(Transition x$30) {
                        State state = x$30.origin();
                        State state2 = this.model$2.currentState();
                        return !(state != null ? !state.equals(state2) : state2 != null);
                    }
                    {
                        this.model$2 = model$2;
                    }
                });
                if (trs.size() == 1) break;
                Log$.MODULE$.warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " matches ", " transitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label2, BoxesRunTime.boxToInteger((int)trs.size())})));
            }
            return new Some((Object)new Tuple2((Object)model, trs.head()));
        }
        throw new MatchError((Object)tuple2);
    }

    public void checkForFieldUpdates(MBT model, Tuple2<TransitionResult, RecordedTransition> result, CloneableRandom rng) {
        List<Tuple2<Field, Object>> updates2 = model.tracedFields().updates();
        updates2.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Field, Object> u) {
                Log$.MODULE$.fine(new StringBuilder().append((Object)"Trace field ").append(u._1()).append((Object)" now has value ").append(u._2()).toString());
            }
        });
        this.updateExecHistory(model, rng, result, updates2);
    }

    public void unblockJoiningModels(MBT model) {
        ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final MBT model$3;

            public final boolean apply(MBT x$31) {
                MBT mBT = x$31.joining();
                MBT mBT2 = this.model$3;
                return !(mBT != null ? !mBT.equals(mBT2) : mBT2 != null);
            }
            {
                this.model$3 = model$3;
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(MBT m) {
                m.joining_$eq(null);
            }
        });
    }

    public void warnAboutPreconditions(List<Tuple2<MBT, Transition>> allSucc, boolean backtracked) {
        allSucc.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<MBT, Transition> succ) {
                Log$.MODULE$.warn(new StringBuilder().append((Object)"All preconditions false at transition ").append((Object)Modbat$.MODULE$.ppTrans(new RecordedTransition((MBT)succ._1(), (Transition)succ._2(), RecordedTransition$.MODULE$.$lessinit$greater$default$3(), RecordedTransition$.MODULE$.$lessinit$greater$default$4(), RecordedTransition$.MODULE$.$lessinit$greater$default$5()))).toString());
            }
        });
        Log$.MODULE$.warn("Maybe the preconditions are too strict?");
    }

    public void checkIfPendingModels() {
        if (((SeqLike)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MBT x$32) {
                return x$32.joining() != null;
            }
        })).size() != 0) {
            Log$.MODULE$.warn("Deadlock: Some models stuck waiting for another model to finish.");
            ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MBT x$33) {
                    return x$33.joining() != null;
                }
            })).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(MBT m) {
                    RecordedTransition trans = (RecordedTransition)((TraversableForwarder)Modbat$.MODULE$.modbat$mbt$Modbat$$executedTransitions().filter((Function1)new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final MBT m$2;

                        public final boolean apply(RecordedTransition x$34) {
                            return x$34.model() == this.m$2;
                        }
                        {
                            this.m$2 = m$2;
                        }
                    })).last();
                    Log$.MODULE$.warn(new StringBuilder().append((Object)m.name()).append((Object)": ").append((Object)Modbat$.MODULE$.ppTrans(trans)).toString());
                }
            });
        }
    }

    public Tuple2<TransitionResult, RecordedTransition> exploreSuccessors() {
        Tuple2<Tuple2<TransitionResult, RecordedTransition>, Modbat.PathResult> tuple2;
        block6: {
            Tuple2 tuple22;
            block5: {
                block4: {
                    TransitionResult transitionResult;
                    Tuple2 tuple23;
                    tuple2 = this.executeSuccessorTrans();
                    if (tuple2 == null || (tuple23 = (Tuple2)tuple2._1()) == null || !Finished$.MODULE$.equals(transitionResult = (TransitionResult)tuple23._1())) break block4;
                    this.insertPathInfoInTrie();
                    tuple22 = new Tuple2((Object)new Ok(Ok$.MODULE$.apply$default$1()), null);
                    break block5;
                }
                if (tuple2 == null) break block6;
                Tuple2 result = (Tuple2)tuple2._1();
                Modbat.PathResult pathResult = (Modbat.PathResult)tuple2._2();
                if (result == null) break block6;
                Tuple2 tuple24 = result;
                if (pathResult == null) break block6;
                Modbat.PathResult pathResult2 = pathResult;
                if (!pathResult2.isObserver()) {
                    this.storePathInfo(pathResult2.result(), pathResult2.successor(), pathResult2.backtracked(), pathResult2.failed());
                }
                tuple22 = tuple24;
            }
            return tuple22;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Tuple2<TransitionResult, RecordedTransition>, Modbat.PathResult> executeSuccessorTrans() {
        TransitionResult t;
        boolean bl;
        Tuple2<TransitionResult, RecordedTransition> tuple2;
        ObjectRef successor;
        ObjectRef successors2 = ObjectRef.create(this.allSuccessors(null));
        List allSucc = (List)successors2.elem;
        DoubleRef totalW = DoubleRef.create((double)this.totalWeight((List<Tuple2<MBT, Transition>>)((List)successors2.elem)));
        boolean backtracked = false;
        while (true) {
            BoxedUnit boxedUnit;
            TransitionResult transitionResult;
            void var3_3;
            void var1_1;
            if (((List)successors2.elem).isEmpty() || !(totalW.elem > 0.0) && MBT$.MODULE$.transitionQueue().isEmpty()) {
                if (((List)successors2.elem).isEmpty() && backtracked) {
                    this.warnAboutPreconditions((List<Tuple2<MBT, Transition>>)allSucc, backtracked);
                }
                Log$.MODULE$.debug("No more successors.");
                this.checkIfPendingModels();
                Transition$.MODULE$.pendingTransitions().clear();
                return new Tuple2((Object)new Tuple2((Object)Finished$.MODULE$, null), null);
            }
            CloneableRandom localStoredRNGState = ((CloneableRandom)MBT$.MODULE$.rng()).clone();
            float abortProbability = MBT$.MODULE$.rng().nextFloat(false);
            if ((double)abortProbability < Main$.MODULE$.config().abortProbability()) {
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Configured abort probability:").append((Object)BoxesRunTime.boxToDouble((double)Main$.MODULE$.config().abortProbability())).toString());
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Actual abort probability:").append((Object)BoxesRunTime.boxToFloat((float)abortProbability)).toString());
                Log$.MODULE$.debug("Aborting...");
                return new Tuple2((Object)new Tuple2((Object)Finished$.MODULE$, null), null);
            }
            successor = ObjectRef.create(null);
            successor.elem = (Tuple2)this.invocationSuccessor().getOrElse((Function0)new Serializable((ObjectRef)var1_1, (DoubleRef)var3_3){
                public static final long serialVersionUID = 0L;
                private final ObjectRef successors$1;
                private final DoubleRef totalW$1;

                public final Tuple2<MBT, Transition> apply() {
                    return Modbat$.MODULE$.makeChoice((List<Tuple2<MBT, Transition>>)((List)this.successors$1.elem), this.totalW$1.elem);
                }
                {
                    this.successors$1 = successors$1;
                    this.totalW$1 = totalW$1;
                }
            });
            if ((Tuple2)successor.elem == null) continue;
            MBT model = (MBT)((Tuple2)successor.elem)._1();
            Transition trans = (Transition)((Tuple2)successor.elem)._2();
            Predef$.MODULE$.assert(!trans.isSynthetic());
            Tuple2<TransitionResult, RecordedTransition> result = model.executeTransition(trans);
            this.checkForFieldUpdates(model, result, localStoredRNGState);
            tuple2 = result;
            if (tuple2 != null && (transitionResult = (TransitionResult)tuple2._1()) instanceof Ok) {
                boolean sameAgain;
                Ok ok = (Ok)transitionResult;
                boolean bl2 = sameAgain = ok.sameInstanceAgain();
                bl = false;
                State state = trans.origin();
                State state2 = trans.dest();
                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                    trans.averageReward().updateAverageReward(TransitionRewardTypes$.MODULE$.SelfTransReward());
                } else {
                    trans.averageReward().updateAverageReward(TransitionRewardTypes$.MODULE$.GoodTransReward());
                }
                ListBuffer succ = new ListBuffer();
                this.addSuccessors(model, (ListBuffer<Tuple2<MBT, Transition>>)succ, true);
                if (succ.size() == 0) {
                    Log$.MODULE$.debug(new StringBuilder().append((Object)"Model ").append((Object)model.name()).append((Object)" has terminated.").toString());
                    this.unblockJoiningModels(model);
                }
                var1_1.elem = bl2 ? this.allSuccessors(model) : this.allSuccessors(null);
                TransitionResult observerResult = this.updateObservers();
                if (TransitionResult$.MODULE$.isErr(observerResult)) {
                    return new Tuple2((Object)new Tuple2((Object)observerResult, result._2()), (Object)new Modbat.PathResult(result, (Tuple2<MBT, Transition>)((Tuple2)successor.elem), bl, true, true));
                }
                if (this.otherThreadFailed()) {
                    return new Tuple2((Object)new Tuple2((Object)new ExceptionOccurred(MBT$.MODULE$.externalException().toString()), null), (Object)new Modbat.PathResult(result, (Tuple2<MBT, Transition>)((Tuple2)successor.elem), bl, true, false));
                }
                List list = (List)var1_1.elem;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                TransitionResult transitionResult2;
                if (tuple2 == null || !Backtrack$.MODULE$.equals(transitionResult2 = (TransitionResult)tuple2._1())) break;
                bl = true;
                trans.averageReward().updateAverageReward(TransitionRewardTypes$.MODULE$.BacktrackTransReward());
                var1_1.elem = (List)((List)var1_1.elem).filterNot((Function1)new Serializable(successor){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef successor$1;

                    public final boolean apply(Tuple2<MBT, Transition> x$35) {
                        Tuple2<MBT, Transition> tuple2 = x$35;
                        Tuple2 tuple22 = (Tuple2)this.successor$1.elem;
                        return !(tuple2 != null ? !tuple2.equals((Object)tuple22) : tuple22 != null);
                    }
                    {
                        this.successor$1 = successor$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            this.storePathInfo(result, (Tuple2<MBT, Transition>)((Tuple2)successor.elem), bl, false);
            var3_3.elem = this.totalWeight((List<Tuple2<MBT, Transition>>)((List)var1_1.elem));
        }
        if (tuple2 != null && (t = (TransitionResult)tuple2._1()) != null) {
            void var10_10;
            void var9_9;
            TransitionResult transitionResult = t;
            var9_9.averageReward().updateAverageReward(TransitionRewardTypes$.MODULE$.FailTransReward());
            Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(transitionResult));
            this.printTrace((List<RecordedTransition>)this.modbat$mbt$Modbat$$executedTransitions().toList());
            return new Tuple2((Object)var10_10, (Object)new Modbat.PathResult((Tuple2<TransitionResult, RecordedTransition>)var10_10, (Tuple2<MBT, Transition>)((Tuple2)successor.elem), bl, true, false));
        }
        throw new MatchError(tuple2);
    }

    private void storePathInfo(Tuple2<TransitionResult, RecordedTransition> result, Tuple2<MBT, Transition> successor, boolean backtracked, boolean failed) {
        MBT model = (MBT)successor._1();
        Transition trans = (Transition)successor._2();
        if (((RecordedTransition)result._2()).recordedChoices().nonEmpty()) {
            trans.recordedChoices_$eq(((RecordedTransition)result._2()).recordedChoices());
        }
        if (Main$.MODULE$.config().dotifyPathCoverage()) {
            if (backtracked) {
                Transition.NextStateNextIf nextStateNextIf = trans.getNextStateNextIf(((RecordedTransition)result._2()).transition().origin(), false);
                this.pathInfoRecorder().$plus$eq((Object)new PathInfo(model.className(), model.mIdx(), trans, nextStateNextIf, TransitionQuality$.MODULE$.backtrack()));
            } else if (failed) {
                Transition.NextStateNextIf nextStateNextIf = trans.getNextStateNextIf(((RecordedTransition)result._2()).transition().dest(), false);
                this.pathInfoRecorder().$plus$eq((Object)new PathInfo(model.className(), model.mIdx(), trans, nextStateNextIf, TransitionQuality$.MODULE$.fail()));
                if (Main$.MODULE$.config().dotifyPathCoverage()) {
                    this.trie().insert(this.pathInfoRecorder());
                }
            } else if (((RecordedTransition)result._2()).nextState() == null) {
                Transition.NextStateNextIf nextStateNextIf = trans.getNextStateNextIf(((RecordedTransition)result._2()).transition().dest(), false);
                this.pathInfoRecorder().$plus$eq((Object)new PathInfo(model.className(), model.mIdx(), trans, nextStateNextIf, TransitionQuality$.MODULE$.OK()));
            } else {
                Transition.NextStateNextIf nextStateNextIf = trans.getNextStateNextIf(((RecordedTransition)result._2()).nextState().dest(), true);
                this.pathInfoRecorder().$plus$eq((Object)new PathInfo(model.className(), model.mIdx(), trans, nextStateNextIf, TransitionQuality$.MODULE$.OK()));
            }
        }
    }

    private void insertPathInfoInTrie() {
        this.pathInfoRecorder().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(PathInfo p) {
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Recorded information for path coverage: ").append((Object)p.toString()).append((Object)", transID:").append((Object)BoxesRunTime.boxToInteger((int)p.transition().idx())).append((Object)", nextif:").append((Object)p.nextStateNextIf()).toString());
            }
        });
        if (Main$.MODULE$.config().dotifyPathCoverage()) {
            this.trie().insert(this.pathInfoRecorder());
        }
    }

    public TransitionResult updateObservers() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            TransitionResult transitionResult;
            Object object = new Object();
            try {
                ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MBT x$36) {
                        return x$36.isObserver();
                    }
                })).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey3$1;

                    public final void apply(MBT observer) {
                        Predef$.MODULE$.assert(observer.isObserver());
                        TransitionResult observerResult = Modbat$.MODULE$.updateObserver(observer);
                        if (TransitionResult$.MODULE$.isErr(observerResult)) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey3$1, (Object)observerResult);
                        }
                    }
                    {
                        this.nonLocalReturnKey3$1 = nonLocalReturnKey3$1;
                    }
                });
                transitionResult = new Ok(Ok$.MODULE$.apply$default$1());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                transitionResult = (TransitionResult)nonLocalReturnControl2.value();
            }
            return transitionResult;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public TransitionResult updateObserver(MBT observer) {
        HashSet observedStates = new HashSet();
        Ok result = new Ok(Ok$.MODULE$.apply$default$1());
        TransitionResult transitionResult;
        while (!observedStates.contains((Object)observer.currentState())) {
            void var2_2;
            var2_2.$plus$eq((Object)observer.currentState());
            transitionResult = this.executeObserverStep(observer);
        }
        return transitionResult;
    }

    public TransitionResult executeObserverStep(MBT observer) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            TransitionResult transitionResult;
            Object object = new Object();
            try {
                observer.successors(false).foreach((Function1)new Serializable(observer, object){
                    public static final long serialVersionUID = 0L;
                    private final MBT observer$1;
                    private final Object nonLocalReturnKey4$1;

                    public final void apply(Transition trans) {
                        Predef$.MODULE$.assert(!trans.isSynthetic());
                        CloneableRandom localStoredRNGState = ((CloneableRandom)MBT$.MODULE$.rng()).clone();
                        Tuple2<TransitionResult, RecordedTransition> result = this.observer$1.executeTransition(trans);
                        Modbat$.MODULE$.updateExecHistory(this.observer$1, localStoredRNGState, result, (List<Tuple2<Field, Object>>)Nil$.MODULE$);
                        if (TransitionResult$.MODULE$.isErr((TransitionResult)result._1())) {
                            Modbat$.MODULE$.printTrace((List<RecordedTransition>)Modbat$.MODULE$.modbat$mbt$Modbat$$executedTransitions().toList());
                        }
                        Object object = result._1();
                        Backtrack$ backtrack$ = Backtrack$.MODULE$;
                        if (!(object != null ? !object.equals(backtrack$) : backtrack$ != null)) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey4$1, result._1());
                    }
                    {
                        this.observer$1 = observer$1;
                        this.nonLocalReturnKey4$1 = nonLocalReturnKey4$1;
                    }
                });
                transitionResult = new Ok(Ok$.MODULE$.apply$default$1());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                transitionResult = (TransitionResult)nonLocalReturnControl2.value();
            }
            return transitionResult;
        }
        throw nonLocalReturnControl2;
    }

    public String ppTrans(int nModels, String transName, Transition transition, StackTraceElement recAction, String modelName) {
        return nModels > 1 ? new StringBuilder().append((Object)transition.sourceInfo()).append((Object)": ").append((Object)modelName).append((Object)": ").append((Object)transName).toString() : new StringBuilder().append((Object)transition.sourceInfo()).append((Object)": ").append((Object)transName).toString();
    }

    public String ppTrans(RecordedTransition recTrans) {
        String string;
        String transStr = this.ppTrans(MBT$.MODULE$.launchedModels().size(), recTrans.trans().ppTrans(true), recTrans.transition(), recTrans.recordedAction(), recTrans.model().name());
        if (Main$.MODULE$.config().showChoices() && recTrans.randomTrace() != null && recTrans.randomTrace().length != 0) {
            String choices = Predef$.MODULE$.refArrayOps((Object[])recTrans.debugTrace()).mkString(", ");
            string = new StringBuilder().append((Object)transStr).append((Object)"; choices = (").append((Object)choices).append((Object)")").toString();
        } else {
            string = transStr;
        }
        return string;
    }

    public void printTrace(List<RecordedTransition> transitions) {
        Log$.MODULE$.warn("Error found, model trace:");
        transitions.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(RecordedTransition t) {
                Log$.MODULE$.warn(Modbat$.MODULE$.ppTrans(t));
                t.updates().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Field, Object> u) {
                        Log$.MODULE$.warn(new StringBuilder().append((Object)"  ").append(u._1()).append((Object)" = ").append(u._2()).toString());
                    }
                });
            }
        });
    }

    private Modbat$() {
        MODULE$ = this;
        this.origOut = Console$.MODULE$.out();
        this.origErr = Console$.MODULE$.err();
        this.out = this.origOut();
        this.err = this.origErr();
        this.failed = 0;
        this.count = 0;
        this.firstInstance = new LinkedHashMap();
        this.appState = Modbat$AppState$.MODULE$.AppExplore();
        this.modbat$mbt$Modbat$$executedTransitions = new ListBuffer();
        this.modbat$mbt$Modbat$$randomSeed = 0L;
        this.modbat$mbt$Modbat$$timesVisited = new HashMap();
        this.testFailures = new HashMap();
        this.isUnitTest = true;
        this.trie = new Trie();
        this.pathInfoRecorder = new ListBuffer();
    }
}

