function X = tsylv(A, B, C)
% Solve the *-Sylvester equation A*X + X'*B = C
%
% Uses a vectorized version of the algorithm in [De Teran, Dopico ELA '11]

% note that U, V here are transposed wrt the [DetD] paper
if isreal(A) && isreal(B)
    [A, B, Q, Z] = qz(A', B, 'real');
else
    [A, B, U, V] = qz(A', B);
end
A = A';
n = size(C, 2);
X = nan(n, n);
C = Z'*C*Z;

% now we have reduced to the case when A is block lower triangular and B is upper triangular
i = 1;
while i<=n
    if i==n || A(i,i+1)==0
        I = i;
    else
        I = [i,i+1];
    end
    J = 1:min(I)-1;
    K = max(I)+1:n;
    IJ = [I J];
    P = perfect_shuffle(length(I));
    % solve for X(I,I)
    mat = kron(eye(length(I)),A(I,I)) + kron(B(I,I)',eye(length(I)))*P;
    rhs = C(I,I) - A(I,J)*X(J,I) - X(J,I)'*B(J,I); %odd that X(J,I) is needed in both? double-check
    X(I,I) = reshape(mat\rhs(:),[length(I),length(I)]);
    % solve simultaneously for X(K,I) and X'(K,I)
    nn = length(I)*length(K);
    mat2 = zeros(2*nn);
    mat2(end:-2:1,end:-2:1) = kron(eye(length(I)),A(K,K));
    mat2(end:-2:1,end-1:-2:1) = kron(B(I,I)',eye(length(K)));
    mat2(end-1:-2:1,end:-2:1) = kron(eye(length(I)),B(K,K)');
    mat2(end-1:-2:1,end-1:-2:1) = kron(A(I,I),eye(length(K)));
    rhs = zeros(2*nn,1);
    rhs(end:-2:1) = reshape(C(K,I) - A(K,IJ)*X(IJ,I) - X(J,K)'*B(J,I),nn,1);
    rhs(end-1:-2:1) = reshape((C(I,K) - A(I,J)*X(J,K) - X(IJ,I)'*B(IJ,K))',nn,1);
    sol = mat2 \ rhs;
    X(K,I) = reshape(sol(end-1:-2:1),[length(K),length(I)]); X(I,K)=X(K,I)';
    X(K,I) = reshape(sol(end:-2:1),[length(K),length(I)]);
    i = i + length(I);
end
X = Q'*X*Z';

end
function P = perfect_shuffle(n)
switch n
    case 1
        P = 1;
    case 2
        P = [1 0 0 0; 0 0 1 0; 0 1 0 0; 0 0 0 1];
    otherwise
        error('unimplemented')
end
end
