function  [U,varargout]=tds_lyap_iter(tds,W,tv,varargin)
% Computes the solution to the delay lyapunov
% equation and evaluates it in the points given in tv
% which must be 0,tau/2 or tau.
%
% The method is based on preconditioned iterative method as 
% described in "Jarlebring, Poloni Iterative methods for the
% delay Lyapunov equation with T-Sylvester preconditioning, 
% 2015"


    
if (length(tds.A)>2)
   error('Only single delay is implemented'); 
end
if (length(tv)>1)
    error('Only eval in one point implemented');
end
tau=tds.hA(2);
n=length(tds.A{1});
if (tv~=0 && tv~=tau/2 && tv~=tau)
    error('Not implemented: Can only eval in  tv=0,tau/2,tau');
end

if (length(varargin)==0) % Default
    opts.method='gmres';
    opts.TOL=1e-10;
    opts.MAXIT=50;
    opts.NT=500; % number of time-discretization points
else
    opts=varargin{1};
end
method=opts.method;

% note: tds_lyap_comm defined W with different sign
w=-W(:);


% Different options to do a forward solve of the IVP:
Lcc=@(x) Lc_rk4(x,tds.A{1},tds.A{2},tau,opts.NT);

if (strcmp(method,'gmres'))
    
    [Utau2,~,~,~,resvec] = gmres(@(x) Lcc(x),w,[],opts.TOL,opts.MAXIT, @(x) precond(x, tds.A{1}, tau));
    
elseif (strcmp(method,'bicgstab'))
    [Utau2,~,~,~,resvec] = bicgstab(@(x) Lcc(x),w,opts.TOL,opts.MAXIT, @(x) precond(x, tds.A{1}, tau),[],[]);
else
    error(['Unknown method:',method]);
end
if (tv==tau/2)
    U=Utau2; 
else    
    % We need to eval the solution somewhere else
    % Integrate to t=0 with RK4.  Could be combined with Lc_rk4.m
    nt=opts.NT;
    ht=tau/(2*nt);
    u=[Utau2(:);Utau2(:)];
    tic
    for i=1:nt  
        f1=f(u,tds.A{1},tds.A{2});
        f2=f(u+0.5*ht*f1,tds.A{1},tds.A{2});
        f3=f(u+0.5*ht*f2,tds.A{1},tds.A{2});
        f4=f(u+ht*f3,tds.A{1},tds.A{2});
        u=u+(ht/6)*(f1+2*f2+2*f3+f4);
    end
    
    if (tv==0)
        U=u(n^2+(1:n^2));
    else 
        U=u((1:n^2));
    end
    U=reshape(U,n,n);        
end
if (nargout>1)
   varargout{1}=resvec;
end




    
