function tdsobj=tds_create_pdde_wave(nx,ny,tau) 
%  Creates the time-delay system object corresponding
%  to the discretization of the PDDE in Section 4.2 in
%  "Jarlebring, Poloni Iterative methods for the delay 
%  Lyapunov equation with T-Sylvester preconditioning"
%
%  Example: 
%    tdsobj=tds_create_pdde_wave(23,23,1) 
%  


    
%% nx and ny have to be odd since we need to use
%% the midpoint of the interval.
assert(mod(nx,2)==1)
assert(mod(ny,2)==1)


hx=1/(nx+1);
hy=1/(ny+1);

%% Create A0 and A1 ************************
e = ones(nx,1);
Dxx = (1/hx^2)*spdiags([e -2*e e], -1:1, nx, nx);
Dx = (1/(2*hx))*spdiags([-e 0*e e], -1:1, nx, nx);
e = ones(ny,1);
Dyy = (1/hy^2)*spdiags([e -2*e e], -1:1, ny, ny);
Ix=speye(nx,nx);
Iy=speye(ny,ny);

xv=0:hx:1;  xv=xv(2:end-1);
yv=0:hy:1;  yv=yv(2:end-1);

A0a=(kron(Iy,Dxx)+kron(Dyy,Ix));

f=@(X,Y) 5*sin(pi*X.*Y).*cos(pi*X);
F=f(xv'*ones(1,ny),ones(nx,1)*yv);
A1a=diag(F(:))*(kron(eye(ny),Dx));


% make it second order
n0=length(A1a);
A0=sparse(2*n0,2*n0);
A0(1:n0,n0+(1:n0))=speye(n0,n0);
A0(n0+(1:n0),1:n0)=A0a;
A0(n0+(1:n0),n0+(1:n0))=-1*speye(n0,n0);
A1=sparse(2*n0,2*n0);
A1(n0+(1:n0),1:n0)=A1a;

%% Input and output matrices ************************
B1=[ones(nx*ny,1);zeros(nx*ny,1)];
eex=zeros(nx,1); eex(round(nx/2))=1;
eey=zeros(ny,1); eey(round(ny/2))=1;
C1=[kron(eey',eex'),zeros(1,nx*ny)];

% create the tds object data 
tdsobj.A={A0,A1};
tdsobj.hA=[0,tau];
tdsobj.B1={B1};
tdsobj.hB1=0;
tdsobj.C1={C1};
tdsobj.hC1=0;



