function Z = precond(b, A0, tau)
% Inverts the operator Lc for A1=0 exactly.
%
% the input b can either a nxn-matrix or a n^2x1 vector.
% the output is of the same dimension as b

saved_sz=size(b);

n = round(sqrt(prod(saved_sz)));


B = reshape(b,n,n);

c = 1;
AA = A0'+c*eye(n);
BB = A0-c*eye(n);
CC = B;

%S = lyap(A0, -B);
%U0 = lyap(AA,BB,-CC);
tic
U0 = tsylv(AA,BB,CC); % It's a T-sylvester eq
tsylv_time = toc;
fprintf('T-sylv solve time: %f seconds\n',tsylv_time);


Z = U0*expm(tau*A0/2);  
Z = reshape(Z,saved_sz(1),saved_sz(2));
