function xx = f(x, A0, A1)
% derivative of the coupled linear equations (vectorized)
% [vec X(tau/2+t), vec X(tau/2-t)].


n = round(sqrt(length(x)/2));

X1 = reshape(x(1:n^2),[n,n]);
X2 = reshape(x(n^2+1:end),[n,n]);

XX1 =   X1*A0 + X2'* A1; 
XX2 = - X1'*A1 -X2* A0;

xx = [XX1(:); XX2(:)];

