% This source code reproduces the computatation of the 
% solution to the delay Lyapunov equation for the
% example described in Section 4.2 in "Jarlebring, Poloni 
% Iterative methods for the delay Lyapunov equation with 
% T-Sylvester preconditioning, 2015". 
%


%% Setup the discretization of the second order PDE
tau=1;
nx=5; 
ny=5; 
tds=tds_create_pdde_wave(nx,ny,tau);



%% When we want to compute the H2-norm
W=tds.C1{1}'*tds.C1{1};
w=W(:);

opts.MAXIT=50;
opts.TOL=1e-8;
opts.NT=500;
opts.method='gmres';
fprintf('Running GMRES\n');
[U1,resvec_gmres]=tds_lyap_iter(tds,W,tau/2,opts);
opts.method='bicgstab';
fprintf('Running BiCGStab\n')
[U2,resvec_bicgstab]=tds_lyap_iter(tds,W,tau/2,opts);
%
f1=figure(1);
clf;
semilogy(resvec_bicgstab,'k-')
hold on
semilogy(resvec_gmres,'r--')
xlabel('Iteration');
ylabel('Residual estimate');