function L = Lc_rk4(Utau2, A0, A1, tau,varargin)
% returns the action of the matrix operrator L which
% is computed using a fourth order Runge-Kutta scheme
%
% the input Utau2 can either a nxn- matrix or a n^2x1 vector.
% the output has the same dimensions as the input 
% 

n = length(A0);

if (length(varargin)>0) 
    % if we have additional param: use as number of disc points
    nt=varargin{1};
else
    nt=1000;
end

saved_sz=size(Utau2); % save for later
ht=tau/(2*nt); 
u=[Utau2(:);Utau2(:)];
tic
for i=1:nt
    % Do one RK4-step
    f1=f(u,A0,A1);
    f2=f(u+0.5*ht*f1,A0,A1);
    f3=f(u+0.5*ht*f2,A0,A1);
    f4=f(u+ht*f3,A0,A1);
    u=u+(ht/6)*(f1+2*f2+2*f3+f4);
end
ode_solve_time=toc;
fprintf('Lc-action time: %f seconds\n',ode_solve_time);

X0 = reshape(u(n^2+1:end,end), [n,n]);
Xtau = reshape(u(1:n^2,end), [n,n]);


c = 1;
L = X0'*(A0-c*eye(n)) + (A0'+c*eye(n))*X0 + Xtau'*A1 + A1'*Xtau;
L = reshape(L,saved_sz(1),saved_sz(2)); % correct the size


