/*
 * Decompiled with CFR 0.152.
 */
package modbat.mbt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.BitSet;
import modbat.dsl.Action;
import modbat.dsl.Init;
import modbat.dsl.Shutdown;
import modbat.dsl.State;
import modbat.dsl.Transition;
import modbat.dsl.Transition$;
import modbat.log.Log$;
import modbat.mbt.Dotify;
import modbat.mbt.MBT;
import modbat.mbt.MBT$;
import modbat.mbt.Main$;
import modbat.mbt.Modbat$AppState$;
import modbat.mbt.Modbat$ShutdownHandler$;
import modbat.trace.Backtrack$;
import modbat.trace.ErrOrdering$;
import modbat.trace.ExceptionOccurred;
import modbat.trace.ExpectedExceptionMissing$;
import modbat.trace.Ok;
import modbat.trace.Ok$;
import modbat.trace.RecordedState;
import modbat.trace.RecordedTransition;
import modbat.trace.RecordedTransition$;
import modbat.trace.TransitionResult;
import modbat.trace.TransitionResult$;
import modbat.util.CloneableRandom;
import modbat.util.FieldUtil$;
import modbat.util.SourceInfo$;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class Modbat$ {
    public static final Modbat$ MODULE$;
    private final PrintStream origOut;
    private final PrintStream origErr;
    private PrintStream out;
    private PrintStream err;
    private String logFile;
    private String errFile;
    private int failed;
    private int count;
    private final LinkedHashMap<String, MBT> firstInstance;
    private Enumeration.Value appState;
    private ListBuffer<RecordedTransition> modbat$mbt$Modbat$$executedTransitions;
    private long modbat$mbt$Modbat$$randomSeed;
    private final CloneableRandom masterRNG;
    private final HashMap<RecordedState, Object> modbat$mbt$Modbat$$timesVisited;
    private final HashMap<Tuple2<TransitionResult, String>, ListBuffer<Object>> testFailures;

    static {
        new Modbat$();
    }

    public PrintStream origOut() {
        return this.origOut;
    }

    public PrintStream origErr() {
        return this.origErr;
    }

    public PrintStream out() {
        return this.out;
    }

    public void out_$eq(PrintStream x$1) {
        this.out = x$1;
    }

    public PrintStream err() {
        return this.err;
    }

    public void err_$eq(PrintStream x$1) {
        this.err = x$1;
    }

    public String logFile() {
        return this.logFile;
    }

    public void logFile_$eq(String x$1) {
        this.logFile = x$1;
    }

    public String errFile() {
        return this.errFile;
    }

    public void errFile_$eq(String x$1) {
        this.errFile = x$1;
    }

    public int failed() {
        return this.failed;
    }

    public void failed_$eq(int x$1) {
        this.failed = x$1;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    public LinkedHashMap<String, MBT> firstInstance() {
        return this.firstInstance;
    }

    public Enumeration.Value appState() {
        return this.appState;
    }

    public void appState_$eq(Enumeration.Value x$1) {
        this.appState = x$1;
    }

    public ListBuffer<RecordedTransition> modbat$mbt$Modbat$$executedTransitions() {
        return this.modbat$mbt$Modbat$$executedTransitions;
    }

    private void modbat$mbt$Modbat$$executedTransitions_$eq(ListBuffer<RecordedTransition> x$1) {
        this.modbat$mbt$Modbat$$executedTransitions = x$1;
    }

    public long modbat$mbt$Modbat$$randomSeed() {
        return this.modbat$mbt$Modbat$$randomSeed;
    }

    public void modbat$mbt$Modbat$$randomSeed_$eq(long x$1) {
        this.modbat$mbt$Modbat$$randomSeed = x$1;
    }

    public CloneableRandom masterRNG() {
        return this.masterRNG;
    }

    public HashMap<RecordedState, Object> modbat$mbt$Modbat$$timesVisited() {
        return this.modbat$mbt$Modbat$$timesVisited;
    }

    public HashMap<Tuple2<TransitionResult, String>, ListBuffer<Object>> testFailures() {
        return this.testFailures;
    }

    public void init() {
        if (Main$.MODULE$.config().init()) {
            MBT$.MODULE$.invokeAnnotatedStaticMethods(Init.class, null);
        }
    }

    public void shutdown() {
        if (Main$.MODULE$.config().shutdown()) {
            MBT$.MODULE$.invokeAnnotatedStaticMethods(Shutdown.class, null);
        }
    }

    public String showFailure(Tuple2<TransitionResult, String> f) {
        TransitionResult transitionResult;
        block4: {
            String string;
            block3: {
                String failedTrans;
                block2: {
                    TransitionResult failureType = (TransitionResult)f._1();
                    failedTrans = (String)f._2();
                    Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(failureType));
                    transitionResult = failureType;
                    if (!(transitionResult instanceof ExceptionOccurred)) break block2;
                    ExceptionOccurred exceptionOccurred = (ExceptionOccurred)transitionResult;
                    String e = exceptionOccurred.exception();
                    string = new StringBuilder().append((Object)e).append((Object)" at ").append((Object)failedTrans).toString();
                    break block3;
                }
                if (!ExpectedExceptionMissing$.MODULE$.equals(transitionResult)) break block4;
                string = new StringBuilder().append((Object)"Expected exception did not occur at ").append((Object)failedTrans).toString();
            }
            return string;
        }
        throw new MatchError((Object)transitionResult);
    }

    public void showErrors() {
        if (this.testFailures().size() < 1) {
            return;
        }
        if (this.testFailures().size() == 1) {
            Log$.MODULE$.info("One type of test failure:");
        } else {
            Log$.MODULE$.info(new StringBuilder().append(this.testFailures().size()).append((Object)" types of test failures:").toString());
        }
        IntRef i = IntRef.create((int)0);
        ((IterableLike)this.testFailures().keySet().toSeq().sortWith((Function2)new Serializable(){

            public final boolean apply(Tuple2<TransitionResult, String> x, Tuple2<TransitionResult, String> y) {
                return ErrOrdering$.MODULE$.lt(x, y);
            }
        })).foreach((Function1)new Serializable(i){
            private final IntRef i$1;

            public final void apply(Tuple2<TransitionResult, String> f) {
                ++this.i$1.elem;
                Log$.MODULE$.info(new StringBuilder().append(this.i$1.elem).append((Object)") ").append((Object)Modbat$.MODULE$.showFailure(f)).append((Object)":").toString());
                ListBuffer rseeds = (ListBuffer)Modbat$.MODULE$.testFailures().apply(f);
                Log$.MODULE$.info(new StringBuilder().append((Object)"   ").append((Object)((TraversableForwarder)rseeds.map((Function1)new Serializable(this){

                    public final String apply(long x$1) {
                        return RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(x$1));
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())).mkString(" ")).toString());
            }
            {
                this.i$1 = i$1;
            }
        });
    }

    public String passFailed(boolean b) {
        return b ? "passed" : "failed";
    }

    public void warnPrecond(MBT modelInst, Transition t, int idx) {
        Log$.MODULE$.info(new StringBuilder().append((Object)"Precondition ").append((Object)BoxesRunTime.boxToInteger((int)(idx + 1))).append((Object)" always ").append((Object)this.passFailed(t.coverage().precond().precondPassed().get(idx))).append((Object)" at transition ").append((Object)this.ppTrans(new RecordedTransition(modelInst, t, RecordedTransition$.MODULE$.$lessinit$greater$default$3(), RecordedTransition$.MODULE$.$lessinit$greater$default$4(), RecordedTransition$.MODULE$.$lessinit$greater$default$5()))).toString());
    }

    public void preconditionCoverage() {
        this.firstInstance().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, MBT> check$ifrefutable$1) {
                Tuple2<String, MBT> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){

            public final void apply(Tuple2<String, MBT> x$2) {
                Tuple2<String, MBT> tuple2 = x$2;
                if (tuple2 != null) {
                    MBT modelInst = (MBT)tuple2._2();
                    modelInst.transitions().foreach((Function1)new Serializable(this, modelInst){
                        private final MBT modelInst$1;

                        public final void apply(Transition t) {
                            BitSet diffSet = (BitSet)t.coverage().precond().precondPassed().clone();
                            diffSet.xor(t.coverage().precond().precondFailed());
                            int idx = diffSet.nextSetBit(0);
                            while (idx != -1) {
                                Modbat$.MODULE$.warnPrecond(this.modelInst$1, t, idx);
                                if (t.coverage().precond().precondFailed().get(idx)) {
                                    idx = -1;
                                    continue;
                                }
                                idx = diffSet.nextSetBit(idx + 1);
                            }
                        }
                        {
                            this.modelInst$1 = modelInst$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void coverage() {
        Log$.MODULE$.info(new StringBuilder().append(this.count()).append((Object)" tests executed, ").append((Object)BoxesRunTime.boxToInteger((int)(this.count() - this.failed()))).append((Object)" ok, ").append((Object)BoxesRunTime.boxToInteger((int)this.failed())).append((Object)" failed.").toString());
        if (this.count() == 0) {
            return;
        }
        this.showErrors();
        this.firstInstance().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, MBT> check$ifrefutable$2) {
                Tuple2<String, MBT> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){

            public final void apply(Tuple2<String, MBT> x$5) {
                Tuple2<String, MBT> tuple2 = x$5;
                if (tuple2 != null) {
                    String modelName = (String)tuple2._1();
                    MBT modelInst = (MBT)tuple2._2();
                    int nCoveredStates = ((TraversableOnce)modelInst.states().values().filter((Function1)new Serializable(this){

                        public final boolean apply(State x$3) {
                            return x$3.coverage().isCovered();
                        }
                    })).size();
                    int nCoveredTrans = ((ListBuffer)modelInst.transitions().filter((Function1)new Serializable(this){

                        public final boolean apply(Transition x$4) {
                            return x$4.coverage().isCovered();
                        }
                    })).size();
                    String modelStr = "";
                    if (Modbat$.MODULE$.firstInstance().size() != 1) {
                        modelStr = new StringBuilder().append((Object)modelName).append((Object)": ").toString();
                    }
                    int nStates = modelInst.states().size();
                    int nTrans = modelInst.transitions().size();
                    Log$.MODULE$.info(new StringBuilder().append((Object)modelStr).append((Object)BoxesRunTime.boxToInteger((int)nCoveredStates)).append((Object)" states covered (").append((Object)BoxesRunTime.boxToInteger((int)(nCoveredStates * 100 / nStates))).append((Object)" % out of ").append((Object)BoxesRunTime.boxToInteger((int)nStates)).append((Object)"),").toString());
                    Log$.MODULE$.info(new StringBuilder().append((Object)modelStr).append((Object)BoxesRunTime.boxToInteger((int)nCoveredTrans)).append((Object)" transitions covered (").append((Object)BoxesRunTime.boxToInteger((int)(nCoveredTrans * 100 / nTrans))).append((Object)" % out of ").append((Object)BoxesRunTime.boxToInteger((int)nTrans)).append((Object)").").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.preconditionCoverage();
        this.modbat$mbt$Modbat$$randomSeed_$eq(this.masterRNG().z() << 32 | this.masterRNG().w());
        Log$.MODULE$.info(new StringBuilder().append((Object)"Random seed for next test would be: ").append((Object)RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(this.modbat$mbt$Modbat$$randomSeed()))).toString());
        if (Main$.MODULE$.config().dotifyCoverage()) {
            this.firstInstance().withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<String, MBT> check$ifrefutable$3) {
                    Tuple2<String, MBT> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){

                public final void apply(Tuple2<String, MBT> x$6) {
                    Tuple2<String, MBT> tuple2 = x$6;
                    if (tuple2 != null) {
                        String modelName = (String)tuple2._1();
                        MBT modelInst = (MBT)tuple2._2();
                        new Dotify(modelInst, new StringBuilder().append((Object)modelName).append((Object)".dot").toString()).dotify(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
    }

    public void restoreChannels() {
        this.restoreChannel(this.out(), this.origOut(), this.logFile(), this.restoreChannel$default$4());
        this.restoreChannel(this.err(), this.origErr(), this.errFile(), true);
    }

    public void restoreChannel(PrintStream ch, PrintStream orig, String filename, boolean isErr) {
        if (Main$.MODULE$.config().redirectOut()) {
            ch.close();
            File file = new File(filename);
            if ((Main$.MODULE$.config().deleteEmptyLog() && file.length() == 0L || Main$.MODULE$.config().removeLogOnSuccess() && !MBT$.MODULE$.testHasFailed()) && !file.delete()) {
                Log$.MODULE$.warn(new StringBuilder().append((Object)"Cannot delete file ").append((Object)filename).toString());
            }
            if (isErr) {
                Console$.MODULE$.setErr(orig);
                System.setErr(orig);
                Log$.MODULE$.err_$eq(orig);
            } else {
                Console$.MODULE$.setOut(orig);
                System.setOut(orig);
                Console$.MODULE$.print((Object)"\u001b[2K\r");
                Log$.MODULE$.log_$eq(orig);
            }
        }
    }

    public boolean restoreChannel$default$4() {
        return false;
    }

    public boolean explore(int n) {
        this.init();
        Runtime.getRuntime().addShutdownHook(Modbat$ShutdownHandler$.MODULE$);
        this.runTests(n);
        this.coverage();
        this.appState_$eq(Modbat$AppState$.MODULE$.AppShutdown());
        this.shutdown();
        return Runtime.getRuntime().removeShutdownHook(Modbat$ShutdownHandler$.MODULE$);
    }

    public long getRandomSeed() {
        CloneableRandom rng = (CloneableRandom)MBT$.MODULE$.rng();
        Predef$.MODULE$.assert(rng.w() <= 0xFFFFFFFFL);
        Predef$.MODULE$.assert(rng.z() <= 0xFFFFFFFFL);
        return rng.z() << 32 | rng.w();
    }

    public void runTests(int n) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).foreach$mVc$sp((Function1)new Serializable(object){
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        MBT$.MODULE$.rng_$eq(Modbat$.MODULE$.masterRNG().clone());
                        Modbat$.MODULE$.modbat$mbt$Modbat$$randomSeed_$eq(Modbat$.MODULE$.getRandomSeed());
                        String seed = RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(Modbat$.MODULE$.modbat$mbt$Modbat$$randomSeed()));
                        int n = Modbat$.MODULE$.failed();
                        switch (n) {
                            default: {
                                Console$.MODULE$.printf("%8d %16s, %d tests failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed, BoxesRunTime.boxToInteger((int)Modbat$.MODULE$.failed())}));
                                break;
                            }
                            case 1: {
                                Console$.MODULE$.printf("%8d %16s, one test failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed}));
                                break;
                            }
                            case 0: {
                                Console$.MODULE$.printf("%8d %16s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), seed}));
                            }
                        }
                        Modbat$.MODULE$.logFile_$eq(new StringBuilder().append((Object)Main$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".log").toString());
                        Modbat$.MODULE$.errFile_$eq(new StringBuilder().append((Object)Main$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".err").toString());
                        if (Main$.MODULE$.config().redirectOut()) {
                            Modbat$.MODULE$.out_$eq(new PrintStream(new FileOutputStream(Modbat$.MODULE$.logFile())));
                            Console$.MODULE$.setOut(Modbat$.MODULE$.out());
                            System.setOut(Modbat$.MODULE$.out());
                            Log$.MODULE$.log_$eq(Modbat$.MODULE$.out());
                            Modbat$.MODULE$.err_$eq(new PrintStream(new FileOutputStream(Modbat$.MODULE$.errFile()), true));
                            Console$.MODULE$.setErr(Modbat$.MODULE$.err());
                            System.setErr(Modbat$.MODULE$.err());
                            Log$.MODULE$.err_$eq(Modbat$.MODULE$.err());
                        } else {
                            Console$.MODULE$.println();
                        }
                        MBT$.MODULE$.clearLaunchedModels();
                        MBT$.MODULE$.testHasFailed_$eq(false);
                        MBT$.MODULE$.checkDuplicates_$eq(i == 1);
                        MBT model = MBT$.MODULE$.launch(null);
                        TransitionResult result = Modbat$.MODULE$.exploreModel(model);
                        MBT$.MODULE$.cleanup();
                        Modbat$.MODULE$.count_$eq(i);
                        Modbat$.MODULE$.restoreChannels();
                        if (TransitionResult$.MODULE$.isErr(result)) {
                            Modbat$.MODULE$.failed_$eq(Modbat$.MODULE$.failed() + 1);
                        } else {
                            TransitionResult transitionResult = result;
                            Ok ok = new Ok(Ok$.MODULE$.apply$default$1());
                            Predef$.MODULE$.assert(!(transitionResult != null ? !transitionResult.equals(ok) : ok != null));
                        }
                        Modbat$.MODULE$.masterRNG().nextInt(false);
                        if (TransitionResult$.MODULE$.isErr(result) && Main$.MODULE$.config().stopOnFailure()) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public String showTrans(RecordedTransition t) {
        return t == null ? "(transition outside model such as callback)" : t.transition().ppTrans(true);
    }

    /*
     * WARNING - void declaration
     */
    public TransitionResult exploreModel(MBT model) {
        void var3_3;
        BoxedUnit boxedUnit;
        Log$.MODULE$.debug("--- Exploring model ---");
        this.modbat$mbt$Modbat$$timesVisited().clear();
        this.modbat$mbt$Modbat$$executedTransitions().clear();
        this.modbat$mbt$Modbat$$timesVisited().$plus$eq(new Tuple2((Object)new RecordedState(model, model.initialState()), (Object)BoxesRunTime.boxToInteger((int)1)));
        model.tracedFields().fields().foreach((Function1)new Serializable(model){
            private final MBT model$1;

            public final void apply(Field f) {
                Object value = FieldUtil$.MODULE$.getValue(f, this.model$1.model());
                Log$.MODULE$.fine(new StringBuilder().append((Object)"Trace field ").append((Object)f.getName()).append((Object)" has initial value ").append(value).toString());
                this.model$1.tracedFields().values().update((Object)f, value);
            }
            {
                this.model$1 = model$1;
            }
        });
        Tuple2<TransitionResult, RecordedTransition> result = this.exploreSuccessors();
        TransitionResult retVal = (TransitionResult)result._1();
        RecordedTransition recordedTrans = (RecordedTransition)result._2();
        TransitionResult transitionResult = retVal;
        Ok ok = new Ok(Ok$.MODULE$.apply$default$1());
        Predef$.MODULE$.assert(!(transitionResult == null ? ok != null : !transitionResult.equals(ok)) || TransitionResult$.MODULE$.isErr(retVal));
        MBT$.MODULE$.testHasFailed_$eq(TransitionResult$.MODULE$.isErr(retVal));
        if (TransitionResult$.MODULE$.isErr(retVal)) {
            Tuple2 entry = new Tuple2((Object)retVal, (Object)this.showTrans(recordedTrans));
            ListBuffer rseeds = (ListBuffer)this.testFailures().getOrElseUpdate((Object)entry, (Function0)new Serializable(){

                public final ListBuffer<Object> apply() {
                    return new ListBuffer();
                }
            });
            boxedUnit = rseeds.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.modbat$mbt$Modbat$$randomSeed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Log$.MODULE$.debug("--- Resetting to initial state ---");
        return var3_3;
    }

    public void addSuccessors(MBT m, ArrayBuffer<Tuple2<MBT, Transition>> result, boolean quiet) {
        m.successors(quiet).foreach((Function1)new Serializable(m, result, quiet){
            private final MBT m$1;
            private final ArrayBuffer result$1;
            private final boolean quiet$1;

            public final Object apply(Transition s) {
                ArrayBuffer arrayBuffer;
                int limit;
                if (!this.quiet$1) {
                    Log$.MODULE$.debug(new StringBuilder().append((Object)"State ").append((Object)s.dest()).append((Object)" in model ").append((Object)this.m$1.name()).append((Object)" was visited ").append(Modbat$.MODULE$.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(this.m$1, s.dest()), (Function0)new Serializable(this){

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })).append((Object)" times.").toString());
                }
                if ((limit = Main$.MODULE$.config().loopLimit()) != 0 && BoxesRunTime.unboxToInt((Object)Modbat$.MODULE$.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(this.m$1, s.dest()), (Function0)new Serializable(this){

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) >= limit) {
                    if (this.quiet$1) {
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        Log$.MODULE$.fine(new StringBuilder().append((Object)"Detected beginning of loop ").append((Object)BoxesRunTime.boxToInteger((int)limit)).append((Object)" (model ").append((Object)this.m$1.name()).append((Object)", state ").append((Object)s.dest()).append((Object)"), filtering transition ").append((Object)s).append((Object)".").toString());
                        arrayBuffer = BoxedUnit.UNIT;
                    }
                } else {
                    Tuple2 succ = new Tuple2((Object)this.m$1, (Object)s);
                    arrayBuffer = this.result$1.$plus$eq((Object)succ);
                }
                return arrayBuffer;
            }
            {
                this.m$1 = m$1;
                this.result$1 = result$1;
                this.quiet$1 = quiet$1;
            }
        });
    }

    public boolean addSuccessors$default$3() {
        return false;
    }

    public Tuple2<MBT, Transition>[] allSuccessors(MBT givenModel) {
        ObjectRef result = ObjectRef.create((Object)new ArrayBuffer());
        if (givenModel == null) {
            ((ResizableArray)((TraversableLike)MBT$.MODULE$.launchedModels().filterNot((Function1)new Serializable(){

                public final boolean apply(MBT x$7) {
                    return x$7.isObserver();
                }
            })).filter((Function1)new Serializable(){

                public final boolean apply(MBT x$8) {
                    return x$8.joining() == null;
                }
            })).foreach((Function1)new Serializable(result){
                private final ObjectRef result$2;

                public final void apply(MBT m) {
                    Modbat$.MODULE$.addSuccessors(m, (ArrayBuffer<Tuple2<MBT, Transition>>)((ArrayBuffer)this.result$2.elem), Modbat$.MODULE$.addSuccessors$default$3());
                }
                {
                    this.result$2 = result$2;
                }
            });
        } else if (givenModel.joining() == null) {
            this.addSuccessors(givenModel, (ArrayBuffer<Tuple2<MBT, Transition>>)((ArrayBuffer)result.elem), this.addSuccessors$default$3());
        }
        return (Tuple2[])((ArrayBuffer)result.elem).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double totalWeight(Tuple2<MBT, Transition>[] trans) {
        DoubleRef w = DoubleRef.create((double)0.0);
        Predef$.MODULE$.refArrayOps((Object[])trans).foreach((Function1)new Serializable(w){
            private final DoubleRef w$1;

            public final void apply(Tuple2<MBT, Transition> t) {
                this.w$1.elem += ((Transition)t._2()).action().weight();
            }
            {
                this.w$1 = w$1;
            }
        });
        return w.elem;
    }

    public Tuple2<MBT, Transition> weightedChoice(Tuple2<MBT, Transition>[] choices, double totalW) {
        double n = totalW * (double)MBT$.MODULE$.rng().nextFloat(false);
        int i = 0;
        for (double w = ((Transition)choices[0]._2()).action().weight(); w < n; w += ((Transition)choices[++i]._2()).action().weight()) {
        }
        return choices[i];
    }

    public void updateExecHistory(MBT model, CloneableRandom localStoredRNGState, Tuple2<TransitionResult, RecordedTransition> result, List<Tuple2<Field, Object>> updates2) {
        Tuple2<TransitionResult, RecordedTransition> tuple2;
        block5: {
            block3: {
                block4: {
                    TransitionResult transitionResult;
                    block2: {
                        tuple2 = result;
                        if (tuple2 == null) break block2;
                        TransitionResult transitionResult2 = (TransitionResult)tuple2._1();
                        RecordedTransition successorTrans = (RecordedTransition)tuple2._2();
                        if (!(transitionResult2 instanceof Ok) || successorTrans == null) break block2;
                        RecordedTransition recordedTransition = successorTrans;
                        recordedTransition.updates_$eq(updates2);
                        recordedTransition.randomTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).trace());
                        recordedTransition.debugTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).debugTrace());
                        ((CloneableRandom)MBT$.MODULE$.rng()).clear();
                        this.modbat$mbt$Modbat$$executedTransitions().$plus$eq((Object)recordedTransition);
                        int timesSeen = BoxesRunTime.unboxToInt((Object)this.modbat$mbt$Modbat$$timesVisited().getOrElseUpdate((Object)new RecordedState(model, recordedTransition.dest()), (Function0)new Serializable(){

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        this.modbat$mbt$Modbat$$timesVisited().$plus$eq(new Tuple2((Object)new RecordedState(model, recordedTransition.dest()), (Object)BoxesRunTime.boxToInteger((int)(timesSeen + 1))));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (tuple2 == null || !Backtrack$.MODULE$.equals(transitionResult = (TransitionResult)tuple2._1())) break block4;
                    MBT$.MODULE$.rng_$eq(localStoredRNGState);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (tuple2 == null) break block5;
                TransitionResult r = (TransitionResult)tuple2._1();
                RecordedTransition failedTrans = (RecordedTransition)tuple2._2();
                if (r == null) break block5;
                TransitionResult transitionResult = r;
                if (failedTrans == null) break block5;
                RecordedTransition recordedTransition = failedTrans;
                Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(transitionResult));
                recordedTransition.randomTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).trace());
                recordedTransition.debugTrace_$eq(((CloneableRandom)MBT$.MODULE$.rng()).debugTrace());
                ((CloneableRandom)MBT$.MODULE$.rng()).clear();
                this.modbat$mbt$Modbat$$executedTransitions().$plus$eq((Object)recordedTransition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean otherThreadFailed() {
        MBT$ mBT$ = MBT$.MODULE$;
        synchronized (mBT$) {
            Boolean bl;
            if (MBT$.MODULE$.testHasFailed()) {
                this.printTrace((List<RecordedTransition>)this.modbat$mbt$Modbat$$executedTransitions().toList());
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)false);
            }
            Boolean bl2 = bl;
            return BoxesRunTime.unboxToBoolean((Object)bl2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<TransitionResult, RecordedTransition> exploreSuccessors() {
        Tuple2<MBT, Transition>[] successors2 = this.allSuccessors(null);
        Tuple2[] allSucc = (Tuple2[])successors2.clone();
        double totalW = this.totalWeight(successors2);
        boolean backtracked = false;
        while (!Predef$.MODULE$.refArrayOps((Object[])successors2).isEmpty() && totalW > 0.0) {
            TransitionResult t;
            Tuple2<TransitionResult, RecordedTransition> tuple2;
            block14: {
                block13: {
                    TransitionResult transitionResult;
                    BoxedUnit boxedUnit;
                    Tuple2<MBT, Transition> successor;
                    block12: {
                        boolean sameAgain;
                        TransitionResult transitionResult2;
                        CloneableRandom localStoredRNGState = ((CloneableRandom)MBT$.MODULE$.rng()).clone();
                        if ((double)MBT$.MODULE$.rng().nextFloat(false) < Main$.MODULE$.config().abortProbability()) {
                            Log$.MODULE$.debug("Aborting...");
                            return new Tuple2((Object)new Ok(Ok$.MODULE$.apply$default$1()), null);
                        }
                        successor = this.weightedChoice(successors2, totalW);
                        MBT model = (MBT)successor._1();
                        Transition trans = (Transition)successor._2();
                        Predef$.MODULE$.assert(!trans.isSynthetic());
                        Tuple2<TransitionResult, RecordedTransition> result = model.executeTransition(trans);
                        List<Tuple2<Field, Object>> updates2 = Nil$.MODULE$;
                        updates2 = model.tracedFields().updates();
                        updates2.foreach((Function1)new Serializable(){

                            public final void apply(Tuple2<Field, Object> u) {
                                Log$.MODULE$.fine(new StringBuilder().append((Object)"Trace field ").append(u._1()).append((Object)" now has value ").append(u._2()).toString());
                            }
                        });
                        this.updateExecHistory(model, localStoredRNGState, result, updates2);
                        tuple2 = result;
                        if (tuple2 == null || !((transitionResult2 = (TransitionResult)tuple2._1()) instanceof Ok)) break block12;
                        Ok ok = (Ok)transitionResult2;
                        boolean bl = sameAgain = ok.sameInstanceAgain();
                        ArrayBuffer succ = new ArrayBuffer();
                        this.addSuccessors(model, (ArrayBuffer<Tuple2<MBT, Transition>>)succ, true);
                        if (succ.size() == 0) {
                            Log$.MODULE$.debug(new StringBuilder().append((Object)"Model ").append((Object)model.name()).append((Object)" has terminated.").toString());
                            ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(model){
                                private final MBT model$2;

                                public final boolean apply(MBT x$9) {
                                    MBT mBT = x$9.joining();
                                    MBT mBT2 = this.model$2;
                                    return !(mBT != null ? !mBT.equals(mBT2) : mBT2 != null);
                                }
                                {
                                    this.model$2 = model$2;
                                }
                            })).foreach((Function1)new Serializable(){

                                public final void apply(MBT m) {
                                    m.joining_$eq(null);
                                }
                            });
                        }
                        if (this.otherThreadFailed()) {
                            return new Tuple2((Object)new ExceptionOccurred(MBT$.MODULE$.externalException().toString()), null);
                        }
                        successors2 = bl ? this.allSuccessors(model) : this.allSuccessors(null);
                        TransitionResult observerResult = this.updateObservers();
                        if (TransitionResult$.MODULE$.isErr(observerResult)) {
                            return new Tuple2((Object)observerResult, result._2());
                        }
                        if (this.otherThreadFailed()) {
                            return new Tuple2((Object)new ExceptionOccurred(MBT$.MODULE$.externalException().toString()), null);
                        }
                        backtracked = false;
                        allSucc = (Tuple2[])successors2.clone();
                        boxedUnit = BoxedUnit.UNIT;
                        break block13;
                    }
                    if (tuple2 == null || !Backtrack$.MODULE$.equals(transitionResult = (TransitionResult)tuple2._1())) break block14;
                    successors2 = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])successors2).filterNot((Function1)new Serializable(successor){
                        private final Tuple2 successor$1;

                        public final boolean apply(Tuple2<MBT, Transition> x$10) {
                            Tuple2<MBT, Transition> tuple2 = x$10;
                            Tuple2 tuple22 = this.successor$1;
                            return !(tuple2 != null ? !tuple2.equals((Object)tuple22) : tuple22 != null);
                        }
                        {
                            this.successor$1 = successor$1;
                        }
                    });
                    backtracked = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
                totalW = this.totalWeight(successors2);
                continue;
            }
            if (tuple2 != null && (t = (TransitionResult)tuple2._1()) != null) {
                void var10_9;
                TransitionResult transitionResult = t;
                Predef$.MODULE$.assert(TransitionResult$.MODULE$.isErr(transitionResult));
                this.printTrace((List<RecordedTransition>)this.modbat$mbt$Modbat$$executedTransitions().toList());
                return var10_9;
            }
            throw new MatchError(tuple2);
        }
        if (Predef$.MODULE$.refArrayOps((Object[])successors2).isEmpty() && backtracked) {
            Predef$.MODULE$.refArrayOps((Object[])allSucc).foreach((Function1)new Serializable(){

                public final void apply(Tuple2<MBT, Transition> succ) {
                    Log$.MODULE$.warn(new StringBuilder().append((Object)"All preconditions false at transition ").append((Object)Modbat$.MODULE$.ppTrans(new RecordedTransition((MBT)succ._1(), (Transition)succ._2(), RecordedTransition$.MODULE$.$lessinit$greater$default$3(), RecordedTransition$.MODULE$.$lessinit$greater$default$4(), RecordedTransition$.MODULE$.$lessinit$greater$default$5()))).toString());
                }
            });
            Log$.MODULE$.warn("Maybe the preconditions are too strict?");
        }
        Log$.MODULE$.debug("No more successors.");
        if (((SeqLike)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){

            public final boolean apply(MBT x$11) {
                return x$11.joining() != null;
            }
        })).size() != 0) {
            Log$.MODULE$.warn("Deadlock: Some models stuck waiting for another model to finish.");
            ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){

                public final boolean apply(MBT x$12) {
                    return x$12.joining() != null;
                }
            })).foreach((Function1)new Serializable(){

                public final void apply(MBT m) {
                    RecordedTransition trans = (RecordedTransition)((TraversableForwarder)Modbat$.MODULE$.modbat$mbt$Modbat$$executedTransitions().filter((Function1)new Serializable(this, m){
                        private final MBT m$2;

                        public final boolean apply(RecordedTransition x$13) {
                            return x$13.model() == this.m$2;
                        }
                        {
                            this.m$2 = m$2;
                        }
                    })).last();
                    Log$.MODULE$.warn(new StringBuilder().append((Object)m.name()).append((Object)": ").append((Object)Modbat$.MODULE$.ppTrans(trans)).toString());
                }
            });
        }
        Transition$.MODULE$.pendingTransitions().clear();
        return new Tuple2((Object)new Ok(Ok$.MODULE$.apply$default$1()), null);
    }

    public TransitionResult updateObservers() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            TransitionResult transitionResult;
            Object object = new Object();
            try {
                ((ResizableArray)MBT$.MODULE$.launchedModels().filter((Function1)new Serializable(){

                    public final boolean apply(MBT x$14) {
                        return x$14.isObserver();
                    }
                })).foreach((Function1)new Serializable(object){
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(MBT observer) {
                        Predef$.MODULE$.assert(observer.isObserver());
                        TransitionResult observerResult = Modbat$.MODULE$.updateObserver(observer);
                        if (TransitionResult$.MODULE$.isErr(observerResult)) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)observerResult);
                        }
                    }
                    {
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                transitionResult = new Ok(Ok$.MODULE$.apply$default$1());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                transitionResult = (TransitionResult)nonLocalReturnControl2.value();
            }
            return transitionResult;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public TransitionResult updateObserver(MBT observer) {
        HashSet observedStates = new HashSet();
        Ok result = new Ok(Ok$.MODULE$.apply$default$1());
        TransitionResult transitionResult;
        while (!observedStates.contains((Object)observer.currentState())) {
            void var2_2;
            var2_2.$plus$eq((Object)observer.currentState());
            transitionResult = this.executeObserverStep(observer);
        }
        return transitionResult;
    }

    public TransitionResult executeObserverStep(MBT observer) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            TransitionResult transitionResult;
            Object object = new Object();
            try {
                observer.successors(false).foreach((Function1)new Serializable(observer, object){
                    private final MBT observer$1;
                    private final Object nonLocalReturnKey3$1;

                    public final void apply(Transition trans) {
                        Predef$.MODULE$.assert(!trans.isSynthetic());
                        CloneableRandom localStoredRNGState = ((CloneableRandom)MBT$.MODULE$.rng()).clone();
                        Tuple2<TransitionResult, RecordedTransition> result = this.observer$1.executeTransition(trans);
                        Modbat$.MODULE$.updateExecHistory(this.observer$1, localStoredRNGState, result, (List<Tuple2<Field, Object>>)Nil$.MODULE$);
                        if (TransitionResult$.MODULE$.isErr((TransitionResult)result._1())) {
                            Modbat$.MODULE$.printTrace((List<RecordedTransition>)Modbat$.MODULE$.modbat$mbt$Modbat$$executedTransitions().toList());
                        }
                        Object object = result._1();
                        Backtrack$ backtrack$ = Backtrack$.MODULE$;
                        if (!(object != null ? !object.equals(backtrack$) : backtrack$ != null)) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey3$1, result._1());
                    }
                    {
                        this.observer$1 = observer$1;
                        this.nonLocalReturnKey3$1 = nonLocalReturnKey3$1;
                    }
                });
                transitionResult = new Ok(Ok$.MODULE$.apply$default$1());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                transitionResult = (TransitionResult)nonLocalReturnControl2.value();
            }
            return transitionResult;
        }
        throw nonLocalReturnControl2;
    }

    public String sourceInfo(Action action, StackTraceElement recordedAction) {
        String string;
        if (recordedAction == null) {
            Predef$.MODULE$.assert(action.transfunc() != null);
            string = SourceInfo$.MODULE$.sourceInfo(action, false);
        } else {
            String fullClsName = recordedAction.getClassName();
            int idx = fullClsName.lastIndexOf(46);
            string = idx == -1 ? new StringBuilder().append((Object)recordedAction.getFileName()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)recordedAction.getLineNumber())).toString() : new StringBuilder().append((Object)fullClsName.substring(0, idx + 1).replace('.', File.separatorChar)).append((Object)recordedAction.getFileName()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)recordedAction.getLineNumber())).toString();
        }
        return string;
    }

    public String ppTrans(int nModels, String transName, Action action, StackTraceElement recAction, String modelName) {
        String sourceInfoStr = this.sourceInfo(action, recAction);
        return nModels > 1 ? new StringBuilder().append((Object)sourceInfoStr).append((Object)": ").append((Object)modelName).append((Object)": ").append((Object)transName).toString() : new StringBuilder().append((Object)sourceInfoStr).append((Object)": ").append((Object)transName).toString();
    }

    public String ppTrans(RecordedTransition recTrans) {
        String string;
        String transStr = this.ppTrans(MBT$.MODULE$.launchedModels().size(), recTrans.trans().ppTrans(true), recTrans.transition().action(), recTrans.recordedAction(), recTrans.model().name());
        if (Main$.MODULE$.config().showChoices() && recTrans.randomTrace() != null && recTrans.randomTrace().length != 0) {
            String choices = Predef$.MODULE$.refArrayOps((Object[])recTrans.debugTrace()).mkString(", ");
            string = new StringBuilder().append((Object)transStr).append((Object)"; choices = (").append((Object)choices).append((Object)")").toString();
        } else {
            string = transStr;
        }
        return string;
    }

    public void printTrace(List<RecordedTransition> transitions) {
        Log$.MODULE$.warn("Error found, model trace:");
        transitions.foreach((Function1)new Serializable(){

            public final void apply(RecordedTransition t) {
                Log$.MODULE$.warn(Modbat$.MODULE$.ppTrans(t));
                t.updates().foreach((Function1)new Serializable(this){

                    public final void apply(Tuple2<Field, Object> u) {
                        Log$.MODULE$.warn(new StringBuilder().append((Object)"  ").append(u._1()).append((Object)" = ").append(u._2()).toString());
                    }
                });
            }
        });
    }

    private Modbat$() {
        MODULE$ = this;
        this.origOut = Console$.MODULE$.out();
        this.origErr = Console$.MODULE$.err();
        this.out = this.origOut();
        this.err = this.origErr();
        this.failed = 0;
        this.count = 0;
        this.firstInstance = new LinkedHashMap();
        this.appState = Modbat$AppState$.MODULE$.AppExplore();
        this.modbat$mbt$Modbat$$executedTransitions = new ListBuffer();
        this.modbat$mbt$Modbat$$randomSeed = 0L;
        this.masterRNG = ((CloneableRandom)MBT$.MODULE$.rng()).clone();
        this.modbat$mbt$Modbat$$timesVisited = new HashMap();
        this.testFailures = new HashMap();
    }
}

