/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javassist.bytecode.AnnotationDefaultAttribute;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.DeprecatedAttribute;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.InnerClassesAttribute;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.SourceFileAttribute;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.SyntheticAttribute;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        this.constPool = cp;
        this.name = attrname;
        this.info = attrinfo;
    }

    protected AttributeInfo(ConstPool cp, String attrname) {
        this(cp, attrname, (byte[])null);
    }

    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        this(cp, cp.addUtf8Info(attrname), attrinfo);
    }

    protected AttributeInfo(ConstPool cp, int n, DataInputStream in) throws IOException {
        this.constPool = cp;
        this.name = n;
        int len2 = in.readInt();
        this.info = new byte[len2];
        if (len2 > 0) {
            in.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool cp, DataInputStream in) throws IOException {
        int name = in.readUnsignedShort();
        String nameStr = cp.getUtf8Info(name);
        if (nameStr.charAt(0) < 'L') {
            if (nameStr.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(cp, name, in);
            }
            if (nameStr.equals("Code")) {
                return new CodeAttribute(cp, name, in);
            }
            if (nameStr.equals("ConstantValue")) {
                return new ConstantAttribute(cp, name, in);
            }
            if (nameStr.equals("Deprecated")) {
                return new DeprecatedAttribute(cp, name, in);
            }
            if (nameStr.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(cp, name, in);
            }
            if (nameStr.equals("Exceptions")) {
                return new ExceptionsAttribute(cp, name, in);
            }
            if (nameStr.equals("InnerClasses")) {
                return new InnerClassesAttribute(cp, name, in);
            }
        } else {
            if (nameStr.equals("LineNumberTable")) {
                return new LineNumberAttribute(cp, name, in);
            }
            if (nameStr.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(cp, name, in);
            }
            if (nameStr.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(cp, name, in);
            }
            if (nameStr.equals("RuntimeVisibleAnnotations") || nameStr.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(cp, name, in);
            }
            if (nameStr.equals("RuntimeVisibleParameterAnnotations") || nameStr.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(cp, name, in);
            }
            if (nameStr.equals("Signature")) {
                return new SignatureAttribute(cp, name, in);
            }
            if (nameStr.equals("SourceFile")) {
                return new SourceFileAttribute(cp, name, in);
            }
            if (nameStr.equals("Synthetic")) {
                return new SyntheticAttribute(cp, name, in);
            }
            if (nameStr.equals("StackMap")) {
                return new StackMap(cp, name, in);
            }
            if (nameStr.equals("StackMapTable")) {
                return new StackMapTable(cp, name, in);
            }
        }
        return new AttributeInfo(cp, name, in);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] newinfo) {
        this.info = newinfo;
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        int s = this.info.length;
        byte[] srcInfo = this.info;
        byte[] newInfo = new byte[s];
        for (int i = 0; i < s; ++i) {
            newInfo[i] = srcInfo[i];
        }
        return new AttributeInfo(newCp, this.getName(), newInfo);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            out.write(this.info);
        }
    }

    static int getLength(ArrayList list) {
        int size = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            size += attr.length();
        }
        return size;
    }

    static AttributeInfo lookup(ArrayList list, String name) {
        if (list == null) {
            return null;
        }
        ListIterator iterator2 = list.listIterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (!ai.getName().equals(name)) continue;
            return ai;
        }
        return null;
    }

    static synchronized void remove(ArrayList list, String name) {
        if (list == null) {
            return;
        }
        ListIterator iterator2 = list.listIterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (!ai.getName().equals(name)) continue;
            iterator2.remove();
        }
    }

    static void writeAll(ArrayList list, DataOutputStream out) throws IOException {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            attr.write(out);
        }
    }

    static ArrayList copyAll(ArrayList list, ConstPool cp) {
        if (list == null) {
            return null;
        }
        ArrayList<AttributeInfo> newList = new ArrayList<AttributeInfo>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            newList.add(attr.copy(cp, null));
        }
        return newList;
    }

    void renameClass(String oldname, String newname) {
    }

    void renameClass(Map classnames) {
    }

    static void renameClass(List attributes, String oldname, String newname) {
        Iterator iterator2 = attributes.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            ai.renameClass(oldname, newname);
        }
    }

    static void renameClass(List attributes, Map classnames) {
        Iterator iterator2 = attributes.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            ai.renameClass(classnames);
        }
    }
}

