/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache$;
import akka.io.dns.internal.AsyncDnsResolver;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.DnsClient;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001-\u0011Q\"Q:z]\u000e$en]\"bG\",'BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r!gn\u001d\u0006\u0003\u000f!\t!![8\u000b\u0003%\tA!Y6lC\u000e\u00011c\u0001\u0001\r!A\u0011QBD\u0007\u0002\r%\u0011qB\u0002\u0002\u0004\t:\u001c\bCA\u0007\u0012\u0013\t\u0011bA\u0001\u000bQKJLw\u000eZ5d\u0007\u0006\u001c\u0007.Z\"mK\u0006tW\u000f\u001d\u0005\u0006)\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\tAq!\u0007\u0001C\u0002\u0013%!$\u0001\u0005dC\u000eDWMU3g+\u0005Y\u0002c\u0001\u000f&O5\tQD\u0003\u0002\u001f?\u00051\u0011\r^8nS\u000eT!\u0001I\u0011\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002#G\u0005!Q\u000f^5m\u0015\u0005!\u0013\u0001\u00026bm\u0006L!AJ\u000f\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B\u0001\u000b\u001a6\u001b:\u0011\u0011\u0006\r\b\u0003U=r!a\u000b\u0018\u000e\u00031R!!\f\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t\td!\u0001\bTS6\u0004H.\u001a#og\u000e\u000b7\r[3\n\u0005M\"$!B\"bG\",'BA\u0019\u0007!\u00111\u0014h\u000f\"\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u001f@\u001d\t1T(\u0003\u0002?o\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqt\u0007\u0005\u0002D\u0015:\u0011A\t\u0013\b\u0003\u000b\u001es!!\u000b$\n\u0005\u00151\u0011BA\u0002\u0005\u0013\tI%!\u0001\tBgft7\r\u00128t%\u0016\u001cx\u000e\u001c<fe&\u00111\n\u0014\u0002\n#V,'/\u001f+za\u0016T!!\u0013\u0002\u0011\u00059\u000bfB\u0001#P\u0013\t\u0001&!A\u0005E]N\u001cE.[3oi&\u0011!k\u0015\u0002\u0007\u0003:\u001cx/\u001a:\u000b\u0005A\u0013\u0001BB+\u0001A\u0003%1$A\u0005dC\u000eDWMU3gA!9q\u000b\u0001b\u0001\n\u0013A\u0016\u0001\u00038b]>\u0014\u0015m]3\u0016\u0003e\u0003\"A\u000e.\n\u0005m;$\u0001\u0002'p]\u001eDa!\u0018\u0001!\u0002\u0013I\u0016!\u00038b]>\u0014\u0015m]3!\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u0019\u0019\u0017m\u00195fIR\u0011\u0011m\u001b\t\u0004m\t$\u0017BA28\u0005\u0019y\u0005\u000f^5p]B\u0011Q\r\u001b\b\u0003\u001b\u0019L!a\u001a\u0004\u0002\u0007\u0011s7/\u0003\u0002jU\nA!+Z:pYZ,GM\u0003\u0002h\r!)AN\u0018a\u0001w\u0005!a.Y7f\u0011\u0015q\u0007\u0001\"\u0005p\u0003\u0015\u0019Gn\\2l)\u0005I\u0006BB9\u0001\t\u000b1!/A\u0002hKR$\"a\u001d;\u0011\u0007Y\u0012W\nC\u0003va\u0002\u0007Q'A\u0002lKfDaa\u001e\u0001\u0005\u0006\u0019A\u0018a\u00019viR!\u0011\u0010`?\u0000!\t1$0\u0003\u0002|o\t!QK\\5u\u0011\u0015)h\u000f1\u00016\u0011\u0015qh\u000f1\u0001N\u0003\u001d\u0011XmY8sINDq!!\u0001w\u0001\u0004\t\u0019!A\u0002ui2\u0004B!!\u0002\u0002\f9\u0019Q)a\u0002\n\u0007\u0005%A!A\u0006DC\u000eDW\rU8mS\u000eL\u0018\u0002BA\u0007\u0003\u001f\u00111bQ1dQ\u0016\u0004v\u000e\\5ds*\u0019\u0011\u0011\u0002\u0003)\u0007Y\f\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003/\u0011q\u0001^1jYJ,7\rC\u0004\u0002\"\u0001!)%a\t\u0002\u000f\rdW-\u00198vaR\t\u0011\u0010\u000b\u0003\u0002 \u0005M\u0001f\u0001\u0001\u0002*A!\u00111FA\u0018\u001b\t\tiCC\u0002\u0002\u001a!IA!!\r\u0002.\tY\u0011J\u001c;fe:\fG.\u00119j\u0001")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> akka$io$dns$internal$AsyncDnsCache$$cacheRef = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ AsyncDnsCache $outer;

        public final long apply() {
            return this.apply$mcJ$sp();
        }

        public long apply$mcJ$sp() {
            return this.$outer.clock();
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }));
    private final long nanoBase = System.nanoTime();

    public AtomicReference<SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer>> akka$io$dns$internal$AsyncDnsCache$$cacheRef() {
        return this.akka$io$dns$internal$AsyncDnsCache$$cacheRef;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        return this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$)).flatMap((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsCache $outer;
            public final String name$1;

            public final Option<Dns.Resolved> apply(DnsClient.Answer ipv4) {
                return this.$outer.akka$io$dns$internal$AsyncDnsCache$$cacheRef().get().get((Tuple2<String, AsyncDnsResolver.QueryType>)new Tuple2((Object)this.name$1, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$)).map((Function1)new Serializable(this, ipv4){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$cached$1 $outer;
                    private final DnsClient.Answer ipv4$1;

                    public final Dns.Resolved apply(DnsClient.Answer ipv6) {
                        return Dns$Resolved$.MODULE$.apply(this.$outer.name$1, (Iterable<InetAddress>)((Iterable)((TraversableLike)this.ipv4$1.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x1;
                                if (A1 instanceof ARecord) {
                                    ARecord aRecord = (ARecord)A1;
                                    object = aRecord.ip();
                                } else if (A1 instanceof AAAARecord) {
                                    AAAARecord aAAARecord = (AAAARecord)A1;
                                    object = aAAARecord.ip();
                                } else {
                                    object = function1.apply(x1);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(ResourceRecord x1) {
                                ResourceRecord resourceRecord = x1;
                                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ipv4$1 = ipv4$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<DnsClient.Answer> get(Tuple2<String, AsyncDnsResolver.QueryType> key) {
        return this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().get().get(key);
    }

    public final void put(Tuple2<String, AsyncDnsResolver.QueryType> key, DnsClient.Answer records, CachePolicy.CachePolicy ttl) {
        while (true) {
            SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> cache = this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().get();
            if (!this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().compareAndSet(cache, cache.put(key, records, ttl))) continue;
            return;
        }
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, AsyncDnsResolver.QueryType>, DnsClient.Answer> c;
        do {
            c = this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().get();
        } while (!this.akka$io$dns$internal$AsyncDnsCache$$cacheRef().compareAndSet(c, c.cleanup()));
    }
}

