/*
 * Decompiled with CFR 0.152.
 */
package modbat.mbt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import modbat.config.ConfigMgr;
import modbat.config.ConfigMgr$;
import modbat.config.Configuration;
import modbat.config.Version;
import modbat.config.Version$;
import modbat.log.Log$;
import modbat.mbt.Dotify;
import modbat.mbt.MBT;
import modbat.mbt.MBT$;
import modbat.mbt.MBT$AppState$;
import modbat.mbt.MBT$ShutdownHandler$;
import modbat.mbt.Model;
import modbat.mbt.Transition;
import modbat.mbt.TransitionResult$;
import modbat.mbt.after;
import modbat.mbt.before;
import modbat.mbt.init;
import modbat.mbt.shutdown;
import modbat.util.CloneableRandom;
import modbat.util.SourceInfo$;
import scala.Console$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBT$
implements ScalaObject {
    public static final MBT$ MODULE$;
    private final Configuration config;
    private CloneableRandom rng;
    private Class<?> modelClass;
    private String modelClassName;
    private final PrintStream origOut;
    private final PrintStream origErr;
    private PrintStream out;
    private PrintStream err;
    private String logFile;
    private String errFile;
    private int failed;
    private int count;
    private MBT model;
    private Model instance;
    private final ListBuffer<MBT> launchedModels;
    private final HashMap<String, MBT> firstInstance;
    private Enumeration.Value appState;
    private ListBuffer<Tuple2<MBT, Transition>> executedTransitions;
    private ListBuffer<Object> randomNumbers;
    private URLClassLoader classloader;

    static {
        new MBT$();
    }

    public Configuration config() {
        return this.config;
    }

    public CloneableRandom rng() {
        return this.rng;
    }

    public void rng_$eq(CloneableRandom cloneableRandom) {
        this.rng = cloneableRandom;
    }

    private Class<?> modelClass() {
        return this.modelClass;
    }

    private void modelClass_$eq(Class<?> clazz) {
        this.modelClass = clazz;
    }

    public String modelClassName() {
        return this.modelClassName;
    }

    public void modelClassName_$eq(String string) {
        this.modelClassName = string;
    }

    public PrintStream origOut() {
        return this.origOut;
    }

    public PrintStream origErr() {
        return this.origErr;
    }

    public PrintStream out() {
        return this.out;
    }

    public void out_$eq(PrintStream printStream) {
        this.out = printStream;
    }

    public PrintStream err() {
        return this.err;
    }

    public void err_$eq(PrintStream printStream) {
        this.err = printStream;
    }

    public String logFile() {
        return this.logFile;
    }

    public void logFile_$eq(String string) {
        this.logFile = string;
    }

    public String errFile() {
        return this.errFile;
    }

    public void errFile_$eq(String string) {
        this.errFile = string;
    }

    public int failed() {
        return this.failed;
    }

    public void failed_$eq(int n) {
        this.failed = n;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int n) {
        this.count = n;
    }

    public MBT model() {
        return this.model;
    }

    public void model_$eq(MBT mBT) {
        this.model = mBT;
    }

    public Model instance() {
        return this.instance;
    }

    public void instance_$eq(Model model) {
        this.instance = model;
    }

    public ListBuffer<MBT> launchedModels() {
        return this.launchedModels;
    }

    public HashMap<String, MBT> firstInstance() {
        return this.firstInstance;
    }

    public Enumeration.Value appState() {
        return this.appState;
    }

    public void appState_$eq(Enumeration.Value value) {
        this.appState = value;
    }

    private ListBuffer<Tuple2<MBT, Transition>> executedTransitions() {
        return this.executedTransitions;
    }

    private void executedTransitions_$eq(ListBuffer<Tuple2<MBT, Transition>> listBuffer) {
        this.executedTransitions = listBuffer;
    }

    private ListBuffer<Object> randomNumbers() {
        return this.randomNumbers;
    }

    private void randomNumbers_$eq(ListBuffer<Object> listBuffer) {
        this.randomNumbers = listBuffer;
    }

    public URLClassLoader classloader() {
        return this.classloader;
    }

    public void classloader_$eq(URLClassLoader uRLClassLoader) {
        this.classloader = uRLClassLoader;
    }

    public void main(String[] args) {
        String string;
        ConfigMgr c = new ConfigMgr("scala modbat.jar", "CLASSNAME", this.config(), new Version(1, 0, 2, Version$.MODULE$.init$default$4()), ConfigMgr$.MODULE$.init$default$5());
        try {
            Iterator<String> remainingArgs = c.parseArgs(args);
            if (!remainingArgs.hasNext()) {
                Log$.MODULE$.error(c.header());
                Log$.MODULE$.error("Model class argument missing. Try --help.");
                System.exit(1);
            }
            this.modelClassName_$eq((String)remainingArgs.next());
            if (remainingArgs.hasNext()) {
                Log$.MODULE$.error(new StringBuilder().append((Object)"Extra arguments starting at \"").append(remainingArgs.next()).append((Object)"\" are not supported.").toString());
                System.exit(1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log$.MODULE$.error(illegalArgumentException.getMessage());
            System.exit(1);
        }
        this.setup();
        String string2 = string = this.config().mode();
        String string3 = "dot";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Dotify qual$1 = new Dotify(this.launch(null), this.config().dotFile());
            boolean x$4 = qual$1.dotify$default$1();
            qual$1.dotify(x$4);
        } else {
            this.explore(this.config().nRuns());
        }
    }

    public void setup() {
        Log$.MODULE$.setLevel(this.config().logLevel());
        String sep = System.getProperty("path.separator");
        String[] paths = this.config().classpath().split(sep);
        ListBuffer urls$1 = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(urls$1){
            public static final long serialVersionUID;
            private final ListBuffer urls$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ListBuffer<URL> apply(String p) {
                Log$.MODULE$.debug(new StringBuilder().append((Object)"Adding ").append((Object)p).append((Object)" to classpath.").toString());
                return this.urls$1.$plus$eq((Object)new File(p).toURL());
            }
            {
                this.urls$1 = listBuffer;
            }
        });
        try {
            this.classloader_$eq(new URLClassLoader((URL[])urls$1.toArray(ClassManifest$.MODULE$.classType(URL.class)), Thread.currentThread().getContextClassLoader()));
            this.modelClass_$eq(this.classloader().loadClass(this.modelClassName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log$.MODULE$.error(new StringBuilder().append((Object)"Class \"").append((Object)this.modelClassName()).append((Object)"\" not found.").toString());
            System.exit(1);
        }
        this.rng_$eq(new CloneableRandom(this.config().randomSeed()));
    }

    public void invokeAnnotatedMethods(Class<? extends Annotation> annotationType$1, Object instance$1) {
        Method[] methods = this.modelClass().getDeclaredMethods();
        Predef$.MODULE$.refArrayOps((Object[])methods).foreach((Function1)new Serializable(annotationType$1, instance$1){
            public static final long serialVersionUID;
            private final Class annotationType$1;
            private final Object instance$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Method m) {
                Object object;
                T annotation = m.getAnnotation(this.annotationType$1);
                if (annotation == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    Log$.MODULE$.debug(new StringBuilder().append((Object)this.annotationType$1.getSimpleName()).append((Object)": ").append((Object)m.getName()).toString());
                    object = m.invoke(this.instance$1, new Object[0]);
                }
                return object;
            }
            {
                this.annotationType$1 = clazz;
                this.instance$1 = object;
            }
        });
    }

    public void init() {
        if (this.config().init()) {
            this.invokeAnnotatedMethods(init.class, null);
        }
    }

    public void shutdown() {
        if (this.config().shutdown()) {
            this.invokeAnnotatedMethods(shutdown.class, null);
        }
    }

    public void prepare(Object instance) {
        if (this.config().setup()) {
            this.invokeAnnotatedMethods(before.class, instance);
        }
    }

    public void cleanup(Object instance) {
        if (this.config().cleanup()) {
            this.invokeAnnotatedMethods(after.class, instance);
        }
    }

    public void coverage() {
        Log$.MODULE$.info(new StringBuilder().append(this.count()).append((Object)" tests executed, ").append((Object)BoxesRunTime.boxToInteger((int)(this.count() - this.failed()))).append((Object)" ok, ").append((Object)BoxesRunTime.boxToInteger((int)this.failed())).append((Object)" failed.").toString());
        ((MBT)this.firstInstance().apply((Object)this.model().className())).coverage();
    }

    public void restoreChannels() {
        this.restoreChannel(this.out(), this.origOut(), this.logFile(), this.restoreChannel$default$4());
        this.restoreChannel(this.err(), this.origErr(), this.errFile(), true);
    }

    public void restoreChannel(PrintStream ch, PrintStream orig, String filename, boolean isErr) {
        if (this.config().redirectOut()) {
            File file;
            ch.close();
            if (this.config().deleteEmptyLog() && (file = new File(filename)).length() == 0L && !file.delete()) {
                Log$.MODULE$.warn(new StringBuilder().append((Object)"Cannot delete file ").append((Object)filename).toString());
            }
            if (isErr) {
                Console$.MODULE$.setErr(orig);
                System.setErr(orig);
                Log$.MODULE$.err_$eq(orig);
            } else {
                Console$.MODULE$.setOut(orig);
                System.setOut(orig);
                Console$.MODULE$.print((Object)"\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
                Log$.MODULE$.log_$eq(orig);
            }
        }
    }

    public boolean restoreChannel$default$4() {
        return false;
    }

    public boolean explore(int n) {
        this.init();
        Runtime.getRuntime().addShutdownHook(MBT$ShutdownHandler$.MODULE$);
        this.runTests(n);
        this.coverage();
        this.appState_$eq(MBT$AppState$.MODULE$.Coverage());
        this.shutdown();
        return Runtime.getRuntime().removeShutdownHook(MBT$ShutdownHandler$.MODULE$);
    }

    public MBT addAndLaunch(MBT mInstance) {
        Log$.MODULE$.fine(new StringBuilder().append((Object)"Launching new model instance ").append((Object)mInstance.name()).append((Object)"...").toString());
        this.launchedModels().$plus$eq((Object)mInstance);
        mInstance.currentState_$eq(mInstance.initialState());
        return mInstance;
    }

    public MBT launch(Model modelInstance) {
        MBT mBT;
        if (modelInstance == null) {
            Method factoryMethod = this.modelClass().getMethod("instance", new Class[0]);
            if ((factoryMethod.getModifiers() & 8) != 0) {
                if (this.model() == null) {
                    this.model_$eq((MBT)factoryMethod.invoke(null, new Object[0]));
                }
                mBT = this.addAndLaunch(this.model());
            } else {
                this.instance_$eq((Model)this.modelClass().newInstance());
                MBT newInst = (MBT)factoryMethod.invoke((Object)this.instance(), new Object[0]);
                if (this.model() == null) {
                    this.model_$eq(newInst);
                }
                mBT = this.addAndLaunch(newInst);
            }
        } else {
            mBT = this.addAndLaunch(modelInstance.instance());
        }
        return mBT;
    }

    public void runTests(int n) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                CloneableRandom storedRNGState$1 = this.rng().clone();
                Predef$.MODULE$.intWrapper(1).to(n).foreach((Function1)new Serializable(storedRNGState$1, object){
                    public static final long serialVersionUID;
                    private final CloneableRandom storedRNGState$1;
                    private final Object nonLocalReturnKey1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int v1) {
                        MBT$.MODULE$.rng_$eq(this.storedRNGState$1);
                        Predef$.MODULE$.assert(MBT$.MODULE$.rng().w() <= 0xFFFFFFFFL);
                        Predef$.MODULE$.assert(MBT$.MODULE$.rng().z() <= 0xFFFFFFFFL);
                        String seed = Predef$.MODULE$.longWrapper(MBT$.MODULE$.rng().z() << 32 | MBT$.MODULE$.rng().w()).toHexString();
                        Console$.MODULE$.printf("%8d %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v1), seed}));
                        MBT$.MODULE$.logFile_$eq(new StringBuilder().append((Object)MBT$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".log").toString());
                        MBT$.MODULE$.errFile_$eq(new StringBuilder().append((Object)MBT$.MODULE$.config().logPath()).append((Object)"/").append((Object)seed).append((Object)".err").toString());
                        if (MBT$.MODULE$.config().redirectOut()) {
                            MBT$.MODULE$.out_$eq(new PrintStream(new FileOutputStream(MBT$.MODULE$.logFile())));
                            Console$.MODULE$.setOut(MBT$.MODULE$.out());
                            System.setOut(MBT$.MODULE$.out());
                            Log$.MODULE$.log_$eq(MBT$.MODULE$.out());
                            MBT$.MODULE$.err_$eq(new PrintStream(new FileOutputStream(MBT$.MODULE$.errFile()), true));
                            Console$.MODULE$.setErr(MBT$.MODULE$.err());
                            System.setErr(MBT$.MODULE$.err());
                            Log$.MODULE$.err_$eq(MBT$.MODULE$.err());
                        } else {
                            Console$.MODULE$.println();
                        }
                        MBT$.MODULE$.launchedModels().clear();
                        MBT$.MODULE$.launch(null);
                        MBT$.MODULE$.prepare(MBT$.MODULE$.instance());
                        Enumeration.Value result = MBT$.MODULE$.exploreModel(MBT$.MODULE$.model());
                        MBT$.MODULE$.count_$eq(v1);
                        MBT$.MODULE$.cleanup(MBT$.MODULE$.instance());
                        MBT$.MODULE$.restoreChannels();
                        Enumeration.Value value = result;
                        Enumeration.Value value2 = TransitionResult$.MODULE$.Err();
                        if (!(value != null ? !value.equals(value2) : value2 != null)) {
                            MBT$.MODULE$.failed_$eq(MBT$.MODULE$.failed() + 1);
                            if (MBT$.MODULE$.config().stopOnFailure()) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxedUnit.UNIT);
                            }
                        } else {
                            Enumeration.Value value3 = result;
                            Enumeration.Value value4 = TransitionResult$.MODULE$.Ok();
                            Predef$.MODULE$.assert(!(value3 != null ? !value3.equals(value4) : value4 != null));
                        }
                        return this.storedRNGState$1.nextInt();
                    }
                    {
                        this.storedRNGState$1 = cloneableRandom;
                        this.nonLocalReturnKey1$1 = object;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                BoxedUnit cfr_ignored_0 = (BoxedUnit)nonLocalReturnControl2.value();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration.Value exploreModel(MBT model) {
        void var2_2;
        Log$.MODULE$.debug("--- Exploring model ---");
        this.executedTransitions().clear();
        this.randomNumbers().clear();
        model.initialState().covered_$eq(true);
        model.currentState_$eq(model.initialState());
        Enumeration.Value retVal = this.exploreSuccessors();
        Log$.MODULE$.debug("--- Resetting to initial state ---");
        return var2_2;
    }

    public List<Tuple2<MBT, Transition>> successorStates() {
        ObjectRef result$1 = new ObjectRef((Object)new ListBuffer());
        this.launchedModels().foreach((Function1)new Serializable(result$1){
            public static final long serialVersionUID;
            public final ObjectRef result$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MBT m$1) {
                m$1.successorStates().foreach((Function1)new Serializable(this, m$1){
                    public static final long serialVersionUID;
                    private final anonfun.successorStates.1 $outer;
                    private final MBT m$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final ListBuffer<Tuple2<MBT, Transition>> apply(Transition s) {
                        Tuple2 succ = new Tuple2((Object)this.m$1, (Object)s);
                        return ((ListBuffer)this.$outer.result$1.elem).$plus$eq((Object)succ);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.m$1 = mBT;
                    }
                });
            }
            {
                this.result$1 = objectRef;
            }
        });
        return ((ListBuffer)result$1.elem).toList();
    }

    public Enumeration.Value exploreSuccessors() {
        Tuple2<Enumeration.Value, Transition> tuple2;
        block5: {
            Enumeration.Value value;
            Tuple2 successor$1;
            List<Tuple2<MBT, Transition>> successors = this.successorStates();
            while (true) {
                if (successors.isEmpty()) {
                    Log$.MODULE$.debug("No more successors.");
                    return TransitionResult$.MODULE$.Ok();
                }
                CloneableRandom localStoredRNGState = this.rng().clone();
                if ((double)this.rng().nextFloat() < this.config().abortProbability()) {
                    Log$.MODULE$.debug("Aborting...");
                    return TransitionResult$.MODULE$.Ok();
                }
                successor$1 = (Tuple2)successors.apply(this.rng().nextInt(successors.length()));
                MBT model = (MBT)successor$1._1();
                Transition trans = (Transition)successor$1._2();
                Predef$.MODULE$.assert(!trans.isSynthetic());
                Log$.MODULE$.fine(new StringBuilder().append((Object)model.name()).append((Object)": Executing transition ").append((Object)trans).append((Object)"...").toString());
                tuple2 = model.executeTransition(trans);
                if (tuple2 == null) break block5;
                value = (Enumeration.Value)tuple2._1();
                Transition transition = (Transition)tuple2._2();
                Enumeration.Value value2 = TransitionResult$.MODULE$.Ok();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null) && transition != null) {
                    Transition successorTrans = transition;
                    Tuple2 executedTrans = new Tuple2((Object)model, (Object)successorTrans);
                    this.executedTransitions().$plus$eq((Object)executedTrans);
                    successorTrans.dest().covered_$eq(true);
                    model.currentState_$eq(successorTrans.dest());
                    successors = this.successorStates();
                    continue;
                }
                Enumeration.Value value4 = TransitionResult$.MODULE$.Backtrack();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break;
                successors = (List<Tuple2<MBT, Transition>>)successors.filterNot((Function1)new Serializable(successor$1){
                    public static final long serialVersionUID;
                    private final Tuple2 successor$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<MBT, Transition> tuple2) {
                        Tuple2<MBT, Transition> tuple22 = tuple2;
                        Tuple2 tuple23 = this.successor$1;
                        return !(tuple22 != null ? !tuple22.equals((Object)tuple23) : tuple23 != null);
                    }
                    {
                        this.successor$1 = tuple2;
                    }
                });
                this.rng_$eq(localStoredRNGState);
            }
            Enumeration.Value value6 = TransitionResult$.MODULE$.Err();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                this.executedTransitions().$plus$eq((Object)successor$1);
                this.printTrace((List<Tuple2<MBT, Transition>>)this.executedTransitions().toList());
                return TransitionResult$.MODULE$.Err();
            }
            throw new MatchError(tuple2);
        }
        throw new MatchError(tuple2);
    }

    public void printTrace(List<Tuple2<MBT, Transition>> transitions) {
        Log$.MODULE$.warn("Error found, model trace:");
        transitions.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<MBT, Transition> t) {
                MBT model = (MBT)t._1();
                Transition transition = (Transition)t._2();
                if (MBT$.MODULE$.launchedModels().size() > 1) {
                    Log$.MODULE$.warn(new StringBuilder().append((Object)SourceInfo$.MODULE$.sourceInfo(transition.transfunc())).append((Object)": ").append((Object)model.name()).append((Object)": ").append((Object)transition.toString()).toString());
                } else {
                    Log$.MODULE$.warn(new StringBuilder().append((Object)SourceInfo$.MODULE$.sourceInfo(transition.transfunc())).append((Object)": ").append((Object)transition.toString()).toString());
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int choose(int min, int max) {
        void var3_3;
        int res = this.rng().choose(min, max);
        this.randomNumbers().$plus$eq((Object)BoxesRunTime.boxToLong((long)res));
        return (int)var3_3;
    }

    private MBT$() {
        MODULE$ = this;
        this.config = new Configuration();
        this.rng = null;
        this.modelClass = null;
        this.modelClassName = null;
        this.origOut = Console$.MODULE$.out();
        this.origErr = Console$.MODULE$.err();
        this.out = this.origOut();
        this.err = this.origErr();
        Log$.MODULE$.setLevel(this.config().logLevel());
        this.failed = 0;
        this.count = 0;
        this.model = null;
        this.instance = null;
        this.launchedModels = new ListBuffer();
        this.firstInstance = new HashMap();
        this.appState = MBT$AppState$.MODULE$.Explore();
        this.executedTransitions = new ListBuffer();
        this.randomNumbers = new ListBuffer();
        this.classloader = null;
    }
}

