/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;

public class NameAndTypeEntry
extends Entry {
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;

    public NameAndTypeEntry() {
    }

    public NameAndTypeEntry(int n, int n2) {
        this._nameIndex = n;
        this._descriptorIndex = n2;
    }

    public int getType() {
        return 12;
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        Object object = this.beforeModify();
        this._nameIndex = n;
        this.afterModify(object);
    }

    public UTF8Entry getNameEntry() {
        return (UTF8Entry)this.getPool().getEntry(this._nameIndex);
    }

    public int getDescriptorIndex() {
        return this._descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        Object object = this.beforeModify();
        this._descriptorIndex = n;
        this.afterModify(object);
    }

    public UTF8Entry getDescriptorEntry() {
        return (UTF8Entry)this.getPool().getEntry(this._descriptorIndex);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterNameAndTypeEntry(this);
        bCVisitor.exitNameAndTypeEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._nameIndex = dataInput.readUnsignedShort();
        this._descriptorIndex = dataInput.readUnsignedShort();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this._nameIndex);
        dataOutput.writeShort(this._descriptorIndex);
    }
}

