/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.IIncInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class WideInstruction
extends LocalVariableInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    private int _ins = 0;
    private int _inc = -1;
    static /* synthetic */ Class class$java$lang$Object;

    WideInstruction(Code code) {
        super(code, 196);
    }

    int getLength() {
        int n = super.getLength() + 1 + 2;
        if (this.getInstruction() == 132) {
            n += 2;
        }
        return n;
    }

    public int getStackChange() {
        switch (this.getInstruction()) {
            case 21: 
            case 23: 
            case 25: {
                return 1;
            }
            case 22: 
            case 24: {
                return 2;
            }
            case 54: 
            case 56: 
            case 58: {
                return -1;
            }
            case 55: 
            case 57: {
                return -2;
            }
        }
        return 0;
    }

    public int getLogicalStackChange() {
        switch (this.getInstruction()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return 1;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return -1;
            }
        }
        return 0;
    }

    public String getTypeName() {
        switch (this.getInstruction()) {
            case 21: 
            case 54: {
                return Integer.TYPE.getName();
            }
            case 22: 
            case 55: {
                return Long.TYPE.getName();
            }
            case 23: 
            case 56: {
                return Float.TYPE.getName();
            }
            case 24: 
            case 57: {
                return Double.TYPE.getName();
            }
            case 25: 
            case 58: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = WideInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        string = this.mapType(string, _mappings, true);
        switch (this.getInstruction()) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (string == null) {
                    throw new IllegalStateException();
                }
                switch (string.charAt(0)) {
                    case 'i': {
                        return this.setInstruction(21);
                    }
                    case 'l': {
                        return this.setInstruction(22);
                    }
                    case 'f': {
                        return this.setInstruction(23);
                    }
                    case 'd': {
                        return this.setInstruction(24);
                    }
                }
                return this.setInstruction(25);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (string == null) {
                    throw new IllegalStateException();
                }
                switch (string.charAt(0)) {
                    case 'i': {
                        return this.setInstruction(54);
                    }
                    case 'l': {
                        return this.setInstruction(55);
                    }
                    case 'f': {
                        return this.setInstruction(56);
                    }
                    case 'd': {
                        return this.setInstruction(57);
                    }
                }
                return this.setInstruction(58);
            }
        }
        if (string != null) {
            throw new IllegalStateException("Augmented instruction not typed");
        }
        return this;
    }

    public int getInstruction() {
        return this._ins;
    }

    public WideInstruction setInstruction(Instruction instruction) {
        if (instruction == null) {
            return this.setInstruction(0);
        }
        this.setInstruction(instruction.getOpcode());
        if (instruction instanceof IIncInstruction) {
            this.setIncrement(((IIncInstruction)instruction).getIncrement());
        }
        return this;
    }

    public WideInstruction setInstruction(int n) {
        this._ins = n;
        return this;
    }

    public WideInstruction iinc() {
        return this.setInstruction(132);
    }

    public WideInstruction ret() {
        return this.setInstruction(169);
    }

    public WideInstruction iload() {
        return this.setInstruction(21);
    }

    public WideInstruction fload() {
        return this.setInstruction(23);
    }

    public WideInstruction aload() {
        return this.setInstruction(25);
    }

    public WideInstruction lload() {
        return this.setInstruction(22);
    }

    public WideInstruction dload() {
        return this.setInstruction(24);
    }

    public WideInstruction istore() {
        return this.setInstruction(54);
    }

    public WideInstruction fstore() {
        return this.setInstruction(56);
    }

    public WideInstruction astore() {
        return this.setInstruction(58);
    }

    public WideInstruction lstore() {
        return this.setInstruction(55);
    }

    public WideInstruction dstore() {
        return this.setInstruction(57);
    }

    public int getIncrement() {
        return this._inc;
    }

    public WideInstruction setIncrement(int n) {
        this._inc = n;
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        int n;
        if (instruction == this) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        if (!(instruction instanceof WideInstruction)) {
            return false;
        }
        WideInstruction wideInstruction = (WideInstruction)instruction;
        int n2 = this.getInstruction();
        if (n2 != (n = wideInstruction.getInstruction())) {
            return false;
        }
        if (n2 == 132) {
            int n3 = this.getIncrement();
            int n4 = wideInstruction.getIncrement();
            return n3 == -1 || n4 == -1 || n3 == n4;
        }
        return true;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterWideInstruction(this);
        bCVisitor.exitWideInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this.setInstruction(((WideInstruction)instruction).getInstruction());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setInstruction(dataInput.readUnsignedByte());
        this.setLocal(dataInput.readUnsignedShort());
        if (this.getInstruction() == 132) {
            this.setIncrement(dataInput.readUnsignedShort());
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this.getInstruction());
        dataOutput.writeShort(this.getLocal());
        if (this.getInstruction() == 132) {
            dataOutput.writeShort(this.getIncrement());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

