/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class StackInstruction
extends TypedInstruction {
    StackInstruction(Code code, int n) {
        super(code, n);
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 87: {
                return -1;
            }
            case 88: {
                return -2;
            }
            case 89: 
            case 90: 
            case 91: {
                return 1;
            }
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
        }
        return 0;
    }

    public String getTypeName() {
        return null;
    }

    public TypedInstruction setType(String string) {
        string = this.getProject().getNameCache().getExternalForm(string, false);
        return this.setWide(Long.TYPE.getName().equals(string) || Double.TYPE.getName().equals(string));
    }

    public boolean isWide() {
        switch (this.getOpcode()) {
            case 88: 
            case 92: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    public StackInstruction setWide(boolean bl) {
        switch (this.getOpcode()) {
            case 87: {
                if (!bl) break;
                this.setOpcode(88);
                break;
            }
            case 88: {
                if (bl) break;
                this.setOpcode(87);
                break;
            }
            case 89: {
                if (!bl) break;
                this.setOpcode(92);
                break;
            }
            case 92: {
                if (bl) break;
                this.setOpcode(89);
                break;
            }
            case 90: {
                if (!bl) break;
                this.setOpcode(93);
                break;
            }
            case 93: {
                if (bl) break;
                this.setOpcode(90);
                break;
            }
            case 91: {
                if (!bl) break;
                this.setOpcode(94);
                break;
            }
            case 94: {
                if (bl) break;
                this.setOpcode(91);
            }
        }
        return this;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterStackInstruction(this);
        bCVisitor.exitStackInstruction(this);
    }
}

