/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;

public class SourceFile
extends Attribute {
    int _sourceFileIndex = 0;

    SourceFile(int n, Attributes attributes) {
        super(n, attributes);
    }

    int getLength() {
        return 2;
    }

    public int getFileIndex() {
        return this._sourceFileIndex;
    }

    public void setFileIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        this._sourceFileIndex = n;
    }

    public String getFileName() {
        if (this._sourceFileIndex == 0) {
            return null;
        }
        return ((UTF8Entry)this.getPool().getEntry(this._sourceFileIndex)).getValue();
    }

    public File getFile(File file) {
        String string = this.getFileName();
        if (string == null) {
            return null;
        }
        return new File(file, string);
    }

    public void setFile(String string) {
        if (string == null) {
            this.setFileIndex(0);
        } else {
            this.setFileIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public void setFile(File file) {
        if (file == null) {
            this.setFile((String)null);
        } else {
            this.setFile(file.getName());
        }
    }

    public void setFromClassName() {
        this.setFile(((BCClass)this.getOwner()).getClassName() + ".java");
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterSourceFile(this);
        bCVisitor.exitSourceFile(this);
    }

    void read(Attribute attribute) {
        this.setFile(((SourceFile)attribute).getFileName());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.setFileIndex(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this.getFileIndex());
    }
}

