/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Strings;

public class ConvertInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Boolean.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}, {class$java$lang$Object == null ? (class$java$lang$Object = ConvertInstruction.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE}};
    private static final Class[][] _fromMappings = new Class[][]{{Boolean.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}, {class$java$lang$Object == null ? (class$java$lang$Object = ConvertInstruction.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE}, {Byte.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}};
    String _toType = null;
    String _fromType = null;
    static /* synthetic */ Class class$java$lang$Object;

    ConvertInstruction(Code code) {
        super(code);
    }

    ConvertInstruction(Code code, int n) {
        super(code, n);
    }

    public int getLogicalStackChange() {
        return 0;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                return 1;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                return -1;
            }
        }
        return 0;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 136: 
            case 139: 
            case 142: {
                return Integer.TYPE.getName();
            }
            case 133: 
            case 140: 
            case 143: {
                return Long.TYPE.getName();
            }
            case 134: 
            case 137: 
            case 144: {
                return Float.TYPE.getName();
            }
            case 135: 
            case 138: 
            case 141: {
                return Double.TYPE.getName();
            }
            case 145: {
                return Byte.TYPE.getName();
            }
            case 146: {
                return Character.TYPE.getName();
            }
            case 147: {
                return Short.TYPE.getName();
            }
        }
        return this._toType;
    }

    public TypedInstruction setType(String string) {
        String string2 = this.mapType(string, _mappings, true);
        String string3 = this.getFromTypeName();
        if (string2 == null || string3 == null || string2.equals(string3)) {
            this._toType = string2;
            this._fromType = string3;
            return (TypedInstruction)this.setOpcode(0);
        }
        this._toType = null;
        this._fromType = null;
        char c = string2.charAt(0);
        char c2 = string3.charAt(0);
        switch (c) {
            case 'i': {
                switch (c2) {
                    case 'l': {
                        return (TypedInstruction)this.setOpcode(136);
                    }
                    case 'f': {
                        return (TypedInstruction)this.setOpcode(139);
                    }
                    case 'd': {
                        return (TypedInstruction)this.setOpcode(142);
                    }
                }
            }
            case 'l': {
                switch (c2) {
                    case 'i': {
                        return (TypedInstruction)this.setOpcode(133);
                    }
                    case 'f': {
                        return (TypedInstruction)this.setOpcode(140);
                    }
                    case 'd': {
                        return (TypedInstruction)this.setOpcode(143);
                    }
                }
            }
            case 'f': {
                switch (c2) {
                    case 'i': {
                        return (TypedInstruction)this.setOpcode(134);
                    }
                    case 'l': {
                        return (TypedInstruction)this.setOpcode(137);
                    }
                    case 'd': {
                        return (TypedInstruction)this.setOpcode(144);
                    }
                }
            }
            case 'd': {
                switch (c2) {
                    case 'i': {
                        return (TypedInstruction)this.setOpcode(135);
                    }
                    case 'l': {
                        return (TypedInstruction)this.setOpcode(138);
                    }
                    case 'f': {
                        return (TypedInstruction)this.setOpcode(141);
                    }
                }
            }
            case 'b': {
                if (c2 == 'i') {
                    return (TypedInstruction)this.setOpcode(145);
                }
            }
            case 'C': {
                if (c2 == 'i') {
                    return (TypedInstruction)this.setOpcode(146);
                }
            }
            case 'S': {
                if (c2 != 'i') break;
                return (TypedInstruction)this.setOpcode(147);
            }
        }
        throw new IllegalStateException();
    }

    public String getFromTypeName() {
        switch (this.getOpcode()) {
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: {
                return Integer.TYPE.getName();
            }
            case 136: 
            case 137: 
            case 138: {
                return Long.TYPE.getName();
            }
            case 139: 
            case 140: 
            case 141: {
                return Float.TYPE.getName();
            }
            case 142: 
            case 143: 
            case 144: {
                return Double.TYPE.getName();
            }
        }
        return this._fromType;
    }

    public Class getFromType() {
        String string = this.getFromTypeName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getFromTypeBC() {
        String string = this.getFromTypeName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public ConvertInstruction setFromType(String string) {
        String string2 = this.mapType(string, _fromMappings, true);
        String string3 = this.getTypeName();
        if (string3 == null || string2 == null || string3.equals(string2)) {
            this._toType = string3;
            this._fromType = string2;
            return (ConvertInstruction)this.setOpcode(0);
        }
        this._toType = null;
        this._fromType = null;
        char c = string3.charAt(0);
        char c2 = string2.charAt(0);
        switch (c2) {
            case 'i': {
                switch (c) {
                    case 'l': {
                        return (ConvertInstruction)this.setOpcode(133);
                    }
                    case 'f': {
                        return (ConvertInstruction)this.setOpcode(134);
                    }
                    case 'd': {
                        return (ConvertInstruction)this.setOpcode(135);
                    }
                    case 'b': {
                        return (ConvertInstruction)this.setOpcode(145);
                    }
                    case 'c': {
                        return (ConvertInstruction)this.setOpcode(146);
                    }
                    case 's': {
                        return (ConvertInstruction)this.setOpcode(147);
                    }
                }
            }
            case 'l': {
                switch (c) {
                    case 'i': {
                        return (ConvertInstruction)this.setOpcode(136);
                    }
                    case 'f': {
                        return (ConvertInstruction)this.setOpcode(137);
                    }
                    case 'd': {
                        return (ConvertInstruction)this.setOpcode(138);
                    }
                }
            }
            case 'f': {
                switch (c) {
                    case 'i': {
                        return (ConvertInstruction)this.setOpcode(139);
                    }
                    case 'l': {
                        return (ConvertInstruction)this.setOpcode(140);
                    }
                    case 'd': {
                        return (ConvertInstruction)this.setOpcode(141);
                    }
                }
            }
            case 'd': {
                switch (c) {
                    case 'i': {
                        return (ConvertInstruction)this.setOpcode(142);
                    }
                    case 'l': {
                        return (ConvertInstruction)this.setOpcode(143);
                    }
                    case 'f': {
                        return (ConvertInstruction)this.setOpcode(144);
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    public ConvertInstruction setFromType(Class clazz) {
        if (clazz == null) {
            return this.setFromType((String)null);
        }
        return this.setFromType(clazz.getName());
    }

    public ConvertInstruction setFromType(BCClass bCClass) {
        if (bCClass == null) {
            return this.setFromType((String)null);
        }
        return this.setFromType(bCClass.getName());
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!(instruction instanceof ConvertInstruction)) {
            return false;
        }
        ConvertInstruction convertInstruction = (ConvertInstruction)instruction;
        if (this.getOpcode() != 0 && this.getOpcode() == convertInstruction.getOpcode()) {
            return true;
        }
        String string = this.getTypeName();
        String string2 = convertInstruction.getTypeName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        string = this.getFromTypeName();
        string2 = convertInstruction.getFromTypeName();
        return string == null || string2 == null || string.equals(string2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConvertInstruction(this);
        bCVisitor.exitConvertInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        ConvertInstruction convertInstruction = (ConvertInstruction)instruction;
        this._toType = convertInstruction._toType;
        this._fromType = convertInstruction._fromType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

