/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.BCClass;
import serp.bytecode.BCMember;
import serp.bytecode.ConstantValue;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class BCField
extends BCMember
implements VisitAcceptor {
    BCField(BCClass bCClass) {
        super(bCClass);
    }

    public boolean isVolatile() {
        return (this.getAccessFlags() & 0x40) > 0;
    }

    public void setVolatile(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x40);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFBF);
        }
    }

    public boolean isTransient() {
        return (this.getAccessFlags() & 0x80) > 0;
    }

    public void setTransient(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x80);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFF7F);
        }
    }

    public String getTypeName() {
        return this.getProject().getNameCache().getExternalForm(this.getDescriptor(), false);
    }

    public Class getType() {
        return Strings.toClass(this.getTypeName(), this.getClassLoader());
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getTypeName(), this.getClassLoader());
    }

    public void setType(String string) {
        this.setDescriptor(string);
    }

    public void setType(Class clazz) {
        this.setType(clazz.getName());
    }

    public void setType(BCClass bCClass) {
        this.setType(bCClass.getName());
    }

    public ConstantValue getConstantValue(boolean bl) {
        ConstantValue constantValue = (ConstantValue)this.getAttribute("ConstantValue");
        if (!bl || constantValue != null) {
            return constantValue;
        }
        if (constantValue == null) {
            constantValue = (ConstantValue)this.addAttribute("ConstantValue");
        }
        return constantValue;
    }

    public boolean removeConstantValue() {
        return this.removeAttribute("ConstantValue");
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterBCField(this);
        this.visitAttributes(bCVisitor);
        bCVisitor.exitBCField(this);
    }

    void initialize(String string, String string2) {
        super.initialize(string, string2);
        this.makePrivate();
    }
}

