/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import serp.bytecode.Attribute;
import serp.bytecode.BCEntity;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;

public abstract class Attributes
implements BCEntity {
    public Attribute[] getAttributes() {
        Collection collection = this.getAttributesHolder();
        return collection.toArray(new Attribute[collection.size()]);
    }

    public Attribute getAttribute(String string) {
        Collection collection = this.getAttributesHolder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public Attribute[] getAttributes(String string) {
        LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
        Collection collection = this.getAttributesHolder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            linkedList.add(attribute);
        }
        return linkedList.toArray(new Attribute[linkedList.size()]);
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.clearAttributes();
        if (attributeArray != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                this.addAttribute(attributeArray[i]);
            }
        }
    }

    public Attribute addAttribute(Attribute attribute) {
        Attribute attribute2 = this.addAttribute(attribute.getName());
        attribute2.read(attribute);
        return attribute2;
    }

    public Attribute addAttribute(String string) {
        Attribute attribute = Attribute.create(string, this);
        this.getAttributesHolder().add(attribute);
        return attribute;
    }

    public void clearAttributes() {
        Collection collection = this.getAttributesHolder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            attribute.invalidate();
        }
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(this.getAttribute(string));
    }

    public boolean removeAttribute(Attribute attribute) {
        if (attribute == null || !this.getAttributesHolder().remove(attribute)) {
            return false;
        }
        attribute.invalidate();
        return true;
    }

    void visitAttributes(BCVisitor bCVisitor) {
        Iterator iterator = this.getAttributesHolder().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            bCVisitor.enterAttribute(attribute);
            attribute.acceptVisit(bCVisitor);
            bCVisitor.exitAttribute(attribute);
        }
    }

    void readAttributes(DataInput dataInput) throws IOException {
        Collection collection = this.getAttributesHolder();
        collection.clear();
        for (int i = dataInput.readUnsignedShort(); i > 0; --i) {
            String string = ((UTF8Entry)this.getPool().getEntry(dataInput.readUnsignedShort())).getValue();
            Attribute attribute = this.addAttribute(string);
            attribute.read(dataInput, dataInput.readInt());
        }
    }

    void writeAttributes(DataOutput dataOutput) throws IOException {
        Collection collection = this.getAttributesHolder();
        dataOutput.writeShort(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            dataOutput.writeShort(attribute.getNameIndex());
            int n = attribute.getLength();
            dataOutput.writeInt(n);
            attribute.write(dataOutput, n);
        }
    }

    abstract Collection getAttributesHolder();
}

