/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;

public class DoubleEntry
extends Entry
implements ConstantEntry {
    private double _value = 0.0;

    public DoubleEntry() {
    }

    public DoubleEntry(double d) {
        this._value = d;
    }

    public boolean isWide() {
        return true;
    }

    public int getType() {
        return 6;
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double d) {
        Object object = this.beforeModify();
        this._value = d;
        this.afterModify(object);
    }

    public Object getConstant() {
        return new Double(this.getValue());
    }

    public void setConstant(Object object) {
        this.setValue(((Number)object).doubleValue());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterDoubleEntry(this);
        bCVisitor.exitDoubleEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._value = dataInput.readDouble();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this._value);
    }
}

