/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class NewArrayInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Void.TYPE, Integer.TYPE}, {class$java$lang$Object == null ? (class$java$lang$Object = NewArrayInstruction.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE}};
    private int _code = -1;
    static /* synthetic */ Class class$java$lang$Object;

    NewArrayInstruction(Code code) {
        super(code, 188);
    }

    int getLength() {
        return super.getLength() + 1;
    }

    public String getTypeName() {
        switch (this.getTypeCode()) {
            case 4: {
                return Boolean.TYPE.getName();
            }
            case 5: {
                return Character.TYPE.getName();
            }
            case 6: {
                return Float.TYPE.getName();
            }
            case 7: {
                return Double.TYPE.getName();
            }
            case 8: {
                return Byte.TYPE.getName();
            }
            case 9: {
                return Short.TYPE.getName();
            }
            case 10: {
                return Integer.TYPE.getName();
            }
            case 11: {
                return Long.TYPE.getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        if ((string = this.mapType(string, _mappings, true)) == null) {
            return this.setTypeCode(-1);
        }
        switch (string.charAt(0)) {
            case 'b': {
                if (Boolean.TYPE.getName().equals(string)) {
                    return this.setTypeCode(4);
                }
                return this.setTypeCode(8);
            }
            case 'c': {
                return this.setTypeCode(5);
            }
            case 'f': {
                return this.setTypeCode(6);
            }
            case 'd': {
                return this.setTypeCode(7);
            }
            case 's': {
                return this.setTypeCode(9);
            }
            case 'i': {
                return this.setTypeCode(10);
            }
            case 'l': {
                return this.setTypeCode(11);
            }
        }
        throw new IllegalStateException();
    }

    public int getTypeCode() {
        return this._code;
    }

    public NewArrayInstruction setTypeCode(int n) {
        this._code = n;
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!(instruction instanceof NewArrayInstruction)) {
            return false;
        }
        NewArrayInstruction newArrayInstruction = (NewArrayInstruction)instruction;
        int n = this.getTypeCode();
        int n2 = newArrayInstruction.getTypeCode();
        return n == -1 || n2 == -1 || n == n2;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterNewArrayInstruction(this);
        bCVisitor.exitNewArrayInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this.setTypeCode(((NewArrayInstruction)instruction).getTypeCode());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setTypeCode(dataInput.readUnsignedByte());
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this.getTypeCode());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

