/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.NameCache;
import serp.bytecode.lowlevel.ComplexEntry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Strings;

public class MethodInstruction
extends Instruction {
    private int _index = 0;

    MethodInstruction(Code code, int n) {
        super(code, n);
    }

    int getLength() {
        if (this.getOpcode() == 185) {
            return super.getLength() + 4;
        }
        return super.getLength() + 2;
    }

    public int getLogicalStackChange() {
        String string = this.getMethodReturnName();
        if (string == null) {
            return 0;
        }
        int n = 0;
        if (this.getOpcode() != 184) {
            --n;
        }
        String[] stringArray = this.getMethodParamNames();
        for (int i = 0; i < stringArray.length; ++i) {
            --n;
        }
        if (!Void.TYPE.getName().equals(string)) {
            ++n;
        }
        return n;
    }

    public int getStackChange() {
        String string = this.getMethodReturnName();
        if (string == null) {
            return 0;
        }
        int n = 0;
        if (this.getOpcode() != 184) {
            --n;
        }
        String[] stringArray = this.getMethodParamNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (Long.TYPE.getName().equals(stringArray[n2]) || Double.TYPE.getName().equals(stringArray[n2])) {
                --n;
            }
            ++n2;
            --n;
        }
        if (!Void.TYPE.getName().equals(string)) {
            ++n;
        }
        if (Long.TYPE.getName().equals(string) || Double.TYPE.getName().equals(string)) {
            ++n;
        }
        return n;
    }

    public int getMethodIndex() {
        return this._index;
    }

    public MethodInstruction setMethodIndex(int n) {
        this._index = n;
        return this;
    }

    public BCMethod getMethod() {
        String string = this.getMethodDeclarerName();
        if (string == null) {
            return null;
        }
        BCClass bCClass = this.getProject().loadClass(string, this.getClassLoader());
        BCMethod[] bCMethodArray = bCClass.getMethods(this.getMethodName(), this.getMethodParamNames());
        if (bCMethodArray.length == 0) {
            return null;
        }
        return bCMethodArray[0];
    }

    public MethodInstruction setMethod(BCMethod bCMethod) {
        if (bCMethod == null) {
            return this.setMethodIndex(0);
        }
        return this.setMethod(bCMethod.getDeclarer().getName(), bCMethod.getName(), bCMethod.getReturnName(), bCMethod.getParamNames());
    }

    public MethodInstruction setMethod(Method method) {
        if (method == null) {
            return this.setMethodIndex(0);
        }
        return this.setMethod(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public MethodInstruction setMethod(Constructor constructor) {
        if (constructor == null) {
            return this.setMethodIndex(0);
        }
        this.setOpcode(183);
        return this.setMethod(constructor.getDeclaringClass(), "<init>", Void.TYPE, constructor.getParameterTypes());
    }

    public MethodInstruction setMethod(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null && string3 == null && string == null && (stringArray == null || stringArray.length == 0)) {
            return this.setMethodIndex(0);
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        NameCache nameCache = this.getProject().getNameCache();
        string3 = nameCache.getInternalForm(string3, true);
        string = nameCache.getInternalForm(string, false);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = nameCache.getInternalForm(stringArray[i], true);
        }
        String string4 = nameCache.getDescriptor(string3, stringArray);
        if (this.getOpcode() == 185) {
            return this.setMethodIndex(this.getPool().findInterfaceMethodEntry(string, string2, string4, true));
        }
        return this.setMethodIndex(this.getPool().findMethodEntry(string, string2, string4, true));
    }

    public MethodInstruction setMethod(String string, String string2, String[] stringArray) {
        BCClass bCClass = this.getCode().getMethod().getDeclarer();
        return this.setMethod(bCClass.getName(), string, string2, stringArray);
    }

    public MethodInstruction setMethod(Class clazz, String string, Class clazz2, Class[] classArray) {
        String string2 = clazz == null ? null : clazz.getName();
        String string3 = clazz2 == null ? null : clazz2.getName();
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
        }
        return this.setMethod(string2, string, string3, stringArray);
    }

    public MethodInstruction setMethod(String string, Class clazz, Class[] classArray) {
        BCClass bCClass = this.getCode().getMethod().getDeclarer();
        String string2 = clazz == null ? null : clazz.getName();
        String[] stringArray = null;
        if (classArray != null) {
            stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
        }
        return this.setMethod(bCClass.getName(), string, string2, stringArray);
    }

    public MethodInstruction setMethod(BCClass bCClass, String string, BCClass bCClass2, BCClass[] bCClassArray) {
        String string2 = bCClass == null ? null : bCClass.getName();
        String string3 = bCClass2 == null ? null : bCClass2.getName();
        String[] stringArray = null;
        if (bCClassArray != null) {
            stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
        }
        return this.setMethod(string2, string, string3, stringArray);
    }

    public MethodInstruction setMethod(String string, BCClass bCClass, BCClass[] bCClassArray) {
        BCClass bCClass2 = this.getCode().getMethod().getDeclarer();
        String string2 = bCClass == null ? null : bCClass.getName();
        String[] stringArray = null;
        if (bCClassArray != null) {
            stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
        }
        return this.setMethod(bCClass2.getName(), string, string2, stringArray);
    }

    public String getMethodName() {
        int n = this.getMethodIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = complexEntry.getNameAndTypeEntry().getNameEntry().getValue();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public MethodInstruction setMethodName(String string) {
        return this.setMethod(this.getMethodDeclarerName(), string, this.getMethodReturnName(), this.getMethodParamNames());
    }

    public String getMethodReturnName() {
        int n = this.getMethodIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = complexEntry.getNameAndTypeEntry().getDescriptorEntry().getValue();
        NameCache nameCache = this.getProject().getNameCache();
        String string2 = nameCache.getExternalForm(nameCache.getDescriptorReturnName(string), false);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public Class getMethodReturnType() {
        String string = this.getMethodReturnName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getMethodReturnBC() {
        String string = this.getMethodReturnName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public MethodInstruction setMethodReturn(String string) {
        return this.setMethod(this.getMethodDeclarerName(), this.getMethodName(), string, this.getMethodParamNames());
    }

    public MethodInstruction setMethodReturn(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.setMethodReturn(string);
    }

    public MethodInstruction setMethodReturn(BCClass bCClass) {
        String string = null;
        if (bCClass != null) {
            string = bCClass.getName();
        }
        return this.setMethodReturn(string);
    }

    public String[] getMethodParamNames() {
        int n = this.getMethodIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = complexEntry.getNameAndTypeEntry().getDescriptorEntry().getValue();
        NameCache nameCache = this.getProject().getNameCache();
        String[] stringArray = nameCache.getDescriptorParamNames(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = nameCache.getExternalForm(stringArray[i], false);
        }
        return stringArray;
    }

    public Class[] getMethodParamTypes() {
        String[] stringArray = this.getMethodParamNames();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Strings.toClass(stringArray[i], this.getClassLoader());
        }
        return classArray;
    }

    public BCClass[] getMethodParamBCs() {
        String[] stringArray = this.getMethodParamNames();
        BCClass[] bCClassArray = new BCClass[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            bCClassArray[i] = this.getProject().loadClass(stringArray[i], this.getClassLoader());
        }
        return bCClassArray;
    }

    public MethodInstruction setMethodParams(String[] stringArray) {
        return this.setMethod(this.getMethodDeclarerName(), this.getMethodName(), this.getMethodReturnName(), stringArray);
    }

    public void setMethodParams(Class[] classArray) {
        if (classArray == null) {
            this.setMethodParams((String[])null);
        } else {
            String[] stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
            this.setMethodParams(stringArray);
        }
    }

    public void setMethodParams(BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            this.setMethodParams((String[])null);
        } else {
            String[] stringArray = new String[bCClassArray.length];
            for (int i = 0; i < bCClassArray.length; ++i) {
                stringArray[i] = bCClassArray[i].getName();
            }
            this.setMethodParams(stringArray);
        }
    }

    public String getMethodDeclarerName() {
        int n = this.getMethodIndex();
        if (n == 0) {
            return null;
        }
        ComplexEntry complexEntry = (ComplexEntry)this.getPool().getEntry(n);
        String string = this.getProject().getNameCache().getExternalForm(complexEntry.getClassEntry().getNameEntry().getValue(), false);
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public Class getMethodDeclarerType() {
        String string = this.getMethodDeclarerName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getMethodDeclarerBC() {
        String string = this.getMethodDeclarerName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public MethodInstruction setMethodDeclarer(String string) {
        return this.setMethod(string, this.getMethodName(), this.getMethodReturnName(), this.getMethodParamNames());
    }

    public MethodInstruction setMethodDeclarer(Class clazz) {
        String string = null;
        if (clazz != null) {
            string = clazz.getName();
        }
        return this.setMethodDeclarer(string);
    }

    public MethodInstruction setMethodDeclarer(BCClass bCClass) {
        String string = null;
        if (bCClass != null) {
            string = bCClass.getName();
        }
        return this.setMethodDeclarer(string);
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (instruction == this) {
            return true;
        }
        if (!(instruction instanceof MethodInstruction)) {
            return false;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        MethodInstruction methodInstruction = (MethodInstruction)instruction;
        String string = this.getMethodName();
        String string2 = methodInstruction.getMethodName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        string = this.getMethodReturnName();
        string2 = methodInstruction.getMethodReturnName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        string = this.getMethodDeclarerName();
        string2 = methodInstruction.getMethodDeclarerName();
        if (string != null && string2 != null && !string.equals(string2)) {
            return false;
        }
        String[] stringArray = this.getMethodParamNames();
        String[] stringArray2 = methodInstruction.getMethodParamNames();
        if (stringArray.length != 0 && stringArray2.length != 0 && stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray2[i] == null || stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMethodInstruction(this);
        bCVisitor.exitMethodInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        MethodInstruction methodInstruction = (MethodInstruction)instruction;
        this.setMethod(methodInstruction.getMethodDeclarerName(), methodInstruction.getMethodName(), methodInstruction.getMethodReturnName(), methodInstruction.getMethodParamNames());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setMethodIndex(dataInput.readUnsignedShort());
        if (this.getOpcode() == 185) {
            dataInput.readByte();
            dataInput.readByte();
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.getMethodIndex());
        if (this.getOpcode() == 185) {
            String[] stringArray = this.getMethodParamNames();
            int n = 1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (Long.TYPE.getName().equals(stringArray[n2]) || Double.TYPE.getName().equals(stringArray[n2])) {
                    ++n;
                }
                ++n2;
                ++n;
            }
            dataOutput.writeByte(n);
            dataOutput.writeByte(0);
        }
    }
}

