/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariable;
import serp.bytecode.LocalVariableTable;
import serp.bytecode.TypedInstruction;

public abstract class LocalVariableInstruction
extends TypedInstruction {
    private int _index = -1;

    LocalVariableInstruction(Code code) {
        super(code);
    }

    LocalVariableInstruction(Code code, int n) {
        super(code, n);
        this.calculateLocal();
    }

    public String getTypeName() {
        return null;
    }

    public TypedInstruction setType(String string) {
        throw new UnsupportedOperationException();
    }

    public int getLocal() {
        return this._index;
    }

    public LocalVariableInstruction setLocal(int n) {
        this._index = n;
        this.calculateOpcode();
        return this;
    }

    public int getParam() {
        return this.getCode().getParamsIndex(this.getLocal());
    }

    public LocalVariableInstruction setParam(int n) {
        int n2 = this.getCode().getLocalsIndex(n);
        if (n2 != -1) {
            BCMethod bCMethod = this.getCode().getMethod();
            this.setType(bCMethod.getParamNames()[n]);
        }
        return this.setLocal(n2);
    }

    public LocalVariable getLocalVariable() {
        LocalVariableTable localVariableTable = this.getCode().getLocalVariableTable(false);
        if (localVariableTable == null) {
            return null;
        }
        return localVariableTable.getLocalVariable(this.getLocal());
    }

    public LocalVariableInstruction setLocalVariable(LocalVariable localVariable) {
        if (localVariable == null) {
            return this.setLocal(-1);
        }
        String string = localVariable.getTypeName();
        if (string != null) {
            this.setType(string);
        }
        return this.setLocal(localVariable.getLocal());
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!this.getClass().equals(instruction.getClass())) {
            return false;
        }
        LocalVariableInstruction localVariableInstruction = (LocalVariableInstruction)instruction;
        int n = this.getLocal();
        int n2 = localVariableInstruction.getLocal();
        return n == -1 || n2 == -1 || n == n2;
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this.setLocal(((LocalVariableInstruction)instruction).getLocal());
    }

    void calculateOpcode() {
    }

    void calculateLocal() {
    }
}

