/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCClass;
import serp.bytecode.BCEntity;
import serp.bytecode.InnerClasses;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class InnerClass
implements BCEntity,
VisitAcceptor {
    private int _index = 0;
    private int _nameIndex = 0;
    private int _ownerIndex = 0;
    private int _access = 2;
    private InnerClasses _owner = null;

    InnerClass(InnerClasses innerClasses) {
        this._owner = innerClasses;
    }

    public InnerClasses getOwner() {
        return this._owner;
    }

    void invalidate() {
        this._owner = null;
    }

    public int getAccessFlags() {
        return this._access;
    }

    public void setAccessFlags(int n) {
        this._access = n;
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) > 0;
    }

    public void makePublic() {
        this.setAccessFlags(this.getAccessFlags() | 1);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFD);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFB);
    }

    public boolean isProtected() {
        return (this.getAccessFlags() & 4) > 0;
    }

    public void makeProtected() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFD);
        this.setAccessFlags(this.getAccessFlags() | 4);
    }

    public boolean isPrivate() {
        return (this.getAccessFlags() & 2) > 0;
    }

    public void makePrivate() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
        this.setAccessFlags(this.getAccessFlags() | 2);
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFB);
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public void setFinal(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x10);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) > 0;
    }

    public void setStatic(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 8);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFF7);
        }
    }

    public boolean isInterface() {
        return (this.getAccessFlags() & 0x200) > 0;
    }

    public void setInterface(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x200);
            this.setAbstract(true);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFDFF);
        }
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) > 0;
    }

    public void setAbstract(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x200);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFDFF);
        }
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        this._nameIndex = n;
    }

    public String getName() {
        if (this.getNameIndex() == 0) {
            return null;
        }
        return ((UTF8Entry)this.getPool().getEntry(this.getNameIndex())).getValue();
    }

    public void setName(String string) {
        if (string == null) {
            this.setNameIndex(0);
        } else {
            this.setNameIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public int getTypeIndex() {
        return this._index;
    }

    public void setTypeIndex(int n) {
        this._index = n;
    }

    public String getTypeName() {
        if (this.getTypeIndex() == 0) {
            return null;
        }
        ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(this.getTypeIndex());
        return this.getProject().getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
    }

    public Class getType() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getTypeBC() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public void setType(String string) {
        if (string == null) {
            this.setTypeIndex(0);
        } else {
            string = this.getProject().getNameCache().getInternalForm(string, false);
            this.setTypeIndex(this.getPool().findClassEntry(string, true));
        }
    }

    public void setType(Class clazz) {
        if (clazz == null) {
            this.setType((String)null);
        } else {
            this.setType(clazz.getName());
        }
    }

    public void setType(BCClass bCClass) {
        if (bCClass == null) {
            this.setType((String)null);
        } else {
            this.setType(bCClass.getName());
        }
    }

    public int getDeclarerIndex() {
        return this._ownerIndex;
    }

    public void setDeclarerIndex(int n) {
        this._ownerIndex = n;
    }

    public String getDeclarerName() {
        if (this.getDeclarerIndex() == 0) {
            return null;
        }
        ClassEntry classEntry = (ClassEntry)this.getPool().getEntry(this.getDeclarerIndex());
        return this.getProject().getNameCache().getExternalForm(classEntry.getNameEntry().getValue(), false);
    }

    public Class getDeclarerType() {
        String string = this.getDeclarerName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getDeclarerBC() {
        String string = this.getDeclarerName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public void setDeclarer(String string) {
        if (string == null) {
            this.setDeclarerIndex(0);
        } else {
            string = this.getProject().getNameCache().getInternalForm(string, false);
            this.setDeclarerIndex(this.getPool().findClassEntry(string, true));
        }
    }

    public void setDeclarer(Class clazz) {
        if (clazz == null) {
            this.setDeclarer((String)null);
        } else {
            this.setDeclarer(clazz.getName());
        }
    }

    public void setDeclarer(BCClass bCClass) {
        if (bCClass == null) {
            this.setDeclarer((String)null);
        } else {
            this.setDeclarer(bCClass.getName());
        }
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterInnerClass(this);
        bCVisitor.exitInnerClass(this);
    }

    void read(DataInput dataInput) throws IOException {
        this.setTypeIndex(dataInput.readUnsignedShort());
        this.setDeclarerIndex(dataInput.readUnsignedShort());
        this.setNameIndex(dataInput.readUnsignedShort());
        this.setAccessFlags(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getTypeIndex());
        dataOutput.writeShort(this.getDeclarerIndex());
        dataOutput.writeShort(this.getNameIndex());
        dataOutput.writeShort(this.getAccessFlags());
    }
}

